/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleUpdater;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.apache.logging.log4j.Logger;

public class BattleManager {
    private int IDCounter = 0;
    protected Map<Integer, Battle> battleMap;
    private Thread updaterThread;
    private Logger logger;

    public BattleManager(Logger logger) {
        this.logger = logger;
        this.battleMap = new Hashtable<Integer, Battle>();
        this.updaterThread = new Thread(new BattleUpdater(this));
        this.updaterThread.start();
    }

    public boolean checkAttack(LivingAttackEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) && TurnBasedMinecraftMod.config.getEntityInfoReference(event.getEntity().getClass().getName()) == null || !(event.getSource().func_76346_g() instanceof EntityPlayer) && TurnBasedMinecraftMod.config.getEntityInfoReference(event.getSource().func_76346_g().getClass().getName()) == null) {
            return false;
        }
        EntityInfo entityInfo = TurnBasedMinecraftMod.config.getMatchingEntityInfo(event.getEntity());
        if (entityInfo != null && (TurnBasedMinecraftMod.config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            for (Battle b : this.battleMap.values()) {
                if (!b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) continue;
                this.logger.debug("Attack Canceled: attacked ignores battle but attacker in battle");
                return true;
            }
            this.logger.debug("Attack Not Canceled: attacked ignores battle");
            return false;
        }
        entityInfo = TurnBasedMinecraftMod.config.getMatchingEntityInfo(event.getSource().func_76346_g());
        if (entityInfo != null && (TurnBasedMinecraftMod.config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            for (Battle b : this.battleMap.values()) {
                if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
                this.logger.debug("Attack Canceled: attacker ignores battle but attacked in battle");
                return true;
            }
            this.logger.debug("Attack Not Canceled: attacker ignores battle");
            return false;
        }
        Entity inBattle = null;
        Entity notInBattle = null;
        Battle battle = null;
        for (Battle b : this.battleMap.values()) {
            if (b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) {
                if (inBattle != null) {
                    this.logger.debug("Attack Canceled: both are in battle");
                    return true;
                }
                inBattle = event.getSource().func_76346_g();
                notInBattle = event.getEntity();
                battle = b;
            }
            if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
            if (inBattle != null) {
                this.logger.debug("Attack Canceled: both are in battle");
                return true;
            }
            inBattle = event.getEntity();
            notInBattle = event.getSource().func_76346_g();
            battle = b;
        }
        if (inBattle == null) {
            if (event.getEntity() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof EntityPlayer) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add(event.getEntity());
                sideB.add(event.getSource().func_76346_g());
                this.createBattle(sideA, sideB);
                this.logger.debug("Attack Not Canceled: new battle created");
            } else {
                this.logger.debug("Attack Not Canceled: neither are in battle or players");
            }
            return false;
        }
        if (battle.hasCombatantInSideA(inBattle.func_145782_y())) {
            battle.addCombatantToSideB(notInBattle);
        } else {
            battle.addCombatantToSideA(notInBattle);
        }
        this.logger.debug("Attack Canceled: one is in battle");
        return true;
    }

    private Battle createBattle(Collection<Entity> sideA, Collection<Entity> sideB) {
        while (this.battleMap.containsKey(this.IDCounter)) {
            ++this.IDCounter;
        }
        Battle newBattle = new Battle(this.IDCounter, sideA, sideB, true);
        this.battleMap.put(this.IDCounter, newBattle);
        newBattle.notifyPlayersBattleInfo();
        return newBattle;
    }

    public Battle getBattleByID(int id) {
        return this.battleMap.get(id);
    }
}

