/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.Logger;

public class Config {
    private Map<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>();
    private Set<EntityInfo.Category> ignoreBattleTypes = new HashSet<EntityInfo.Category>();
    private Logger logger;
    private int playerSpeed = 50;
    private int playerHasteSpeed = 80;
    private int playerSlowSpeed = 20;
    private int playerAttackProbability = 100;
    private int playerEvasion = 10;
    private int defenseDuration = 1;
    private int fleeGoodProbability = 90;
    private int fleeBadProbability = 40;

    public Config(Logger logger) {
        this.logger = logger;
        int internalVersion = 0;
        try {
            InputStream is = this.getClass().getResourceAsStream("/assets/TurnBasedMinecraft/TBM_Config.xml");
            if (is == null) {
                logger.error("Internal resource is null");
            }
            internalVersion = this.getConfigFileVersion(is);
        }
        catch (Exception is) {
            // empty catch block
        }
        if (internalVersion == 0) {
            logger.error("Failed to check version of internal config file");
        } else {
            TurnBasedMinecraftMod.setConfigVersion(internalVersion);
        }
        try {
            File testLoad = new File("config/TurnBasedMinecraft/TBM_Config.xml");
            if (!testLoad.exists()) {
                this.writeConfig();
            }
        }
        catch (Exception e) {
            logger.error("Failed to check/create-new config file");
        }
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.xml");
        if (!configFile.exists() || !configFile.canRead()) {
            logger.error("Failed to read/parse config file config/TurnBasedMinecraft/TBM_Config.xml");
            return;
        }
        int configVersion = this.getConfigFileVersion(configFile);
        if (configVersion < TurnBasedMinecraftMod.getConfigVersion()) {
            logger.warn("Config file TBM_Config.xml is older version, renaming...");
            this.moveOldConfig();
            try {
                this.writeConfig();
            }
            catch (Exception e) {
                logger.error("Failed to write config file!");
            }
        }
        try {
            this.parseConfig(configFile);
        }
        catch (Exception e) {
            logger.error("Failed to parse config file!");
        }
    }

    private void writeConfig() throws IOException {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.xml");
        File dirs = configFile.getParentFile();
        dirs.mkdirs();
        InputStream configStream = this.getClass().getResourceAsStream("/assets/TurnBasedMinecraft/TBM_Config.xml");
        FileOutputStream configOutput = new FileOutputStream(configFile);
        byte[] buf = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = configStream.read(buf);
            if (read <= 0) continue;
            configOutput.write(buf, 0, read);
        }
        configStream.close();
        configOutput.close();
    }

    private void moveOldConfig() {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.xml");
        if (configFile.exists()) {
            configFile.renameTo(new File("config/TurnBasedMinecraft/TBM_Config_" + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + ".xml"));
        }
    }

    private boolean parseConfig(File configFile) throws XMLStreamException, FactoryConfigurationError, IOException {
        FileInputStream fis = new FileInputStream(configFile);
        XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(fis);
        while (xmlReader.hasNext()) {
            xmlReader.next();
            if (!xmlReader.isStartElement() || xmlReader.getLocalName().equals("TurnBasedMinecraftConfig") || xmlReader.getLocalName().equals("Version")) continue;
            if (xmlReader.getLocalName().equals("IgnoreBattleTypes")) {
                do {
                    xmlReader.next();
                    if (!xmlReader.isStartElement()) continue;
                    this.ignoreBattleTypes.add(EntityInfo.Category.fromString(xmlReader.getLocalName()));
                } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("IgnoreBattleTypes"));
                continue;
            }
            if (xmlReader.getLocalName().equals("PlayerStats")) {
                do {
                    xmlReader.next();
                    if (!xmlReader.isStartElement()) continue;
                    if (xmlReader.getLocalName().equals("Speed")) {
                        this.playerSpeed = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("HasteSpeed")) {
                        this.playerHasteSpeed = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("SlowSpeed")) {
                        this.playerSlowSpeed = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("AttackProbability")) {
                        this.playerAttackProbability = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (!xmlReader.getLocalName().equals("Evasion")) continue;
                    this.playerEvasion = Integer.parseInt(xmlReader.getElementText());
                } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("PlayerStats"));
                continue;
            }
            if (xmlReader.getLocalName().equals("DefenseDuration")) {
                this.defenseDuration = Integer.parseInt(xmlReader.getElementText());
                continue;
            }
            if (xmlReader.getLocalName().equals("FleeGoodProbability")) {
                this.fleeGoodProbability = Integer.parseInt(xmlReader.getElementText());
                continue;
            }
            if (xmlReader.getLocalName().equals("FleeBadProbability")) {
                this.fleeBadProbability = Integer.parseInt(xmlReader.getElementText());
                continue;
            }
            if (!xmlReader.getLocalName().equals("EntityStats")) continue;
            do {
                xmlReader.next();
                if (!xmlReader.isStartElement()) continue;
                String classType = xmlReader.getLocalName();
                EntityInfo eInfo = new EntityInfo();
                try {
                    eInfo.classType = Class.forName(classType);
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Failed to get class of name " + classType);
                }
                do {
                    xmlReader.next();
                    if (!xmlReader.isStartElement()) continue;
                    if (xmlReader.getLocalName().equals("AttackPower")) {
                        for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                            if (xmlReader.getAttributeLocalName(i).equals("Probability")) {
                                eInfo.attackProbability = Integer.parseInt(xmlReader.getAttributeValue(i));
                                continue;
                            }
                            if (!xmlReader.getAttributeLocalName(i).equals("Variance")) continue;
                            eInfo.attackVariance = Integer.parseInt(xmlReader.getAttributeValue(i));
                        }
                        eInfo.attackPower = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("AttackEffect")) {
                        for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                            if (!xmlReader.getAttributeLocalName(i).equals("Probability")) continue;
                            eInfo.attackEffectProbability = Integer.parseInt(xmlReader.getAttributeValue(i));
                        }
                        eInfo.attackEffect = EntityInfo.Effect.fromString(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("Evasion")) {
                        eInfo.evasion = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("DefenseDamage")) {
                        for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                            if (!xmlReader.getAttributeLocalName(i).equals("Probability")) continue;
                            eInfo.defenseDamageProbability = Integer.parseInt(xmlReader.getAttributeValue(i));
                        }
                        eInfo.defenseDamage = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("Category")) {
                        eInfo.category = EntityInfo.Category.fromString(xmlReader.getElementText());
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("Conflicts")) {
                        do {
                            xmlReader.next();
                            if (!xmlReader.isStartElement()) continue;
                            try {
                                Class<?> conflictingType = Class.forName(xmlReader.getLocalName());
                                eInfo.conflictingTypes.add(conflictingType);
                            }
                            catch (ClassNotFoundException e) {
                                this.logger.warn("Invalid conflicting type for entity " + eInfo.classType.getName());
                            }
                        } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("Conflicts"));
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("IgnoreBattle")) {
                        if (!xmlReader.getElementText().toLowerCase().equals("true")) continue;
                        eInfo.ignoreBattle = true;
                        continue;
                    }
                    if (xmlReader.getLocalName().equals("Speed")) {
                        eInfo.speed = Integer.parseInt(xmlReader.getElementText());
                        continue;
                    }
                    if (!xmlReader.getLocalName().equals("Decision")) continue;
                    do {
                        xmlReader.next();
                        if (!xmlReader.isStartElement()) continue;
                        if (xmlReader.getLocalName().equals("Attack")) {
                            eInfo.decisionAttack = Integer.parseInt(xmlReader.getElementText());
                            continue;
                        }
                        if (xmlReader.getLocalName().equals("Defend")) {
                            eInfo.decisionDefend = Integer.parseInt(xmlReader.getElementText());
                            continue;
                        }
                        if (!xmlReader.getLocalName().equals("Flee")) continue;
                        eInfo.decisionFlee = Integer.parseInt(xmlReader.getElementText());
                    } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("Decision"));
                } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals(classType));
                if (eInfo.classType == null) continue;
                this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
            } while (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("EntityStats"));
        }
        xmlReader.close();
        fis.close();
        return true;
    }

    public int getPlayerSpeed() {
        return this.playerSpeed;
    }

    public int getPlayerHasteSpeed() {
        return this.playerHasteSpeed;
    }

    public int getPlayerSlowSpeed() {
        return this.playerSlowSpeed;
    }

    public int getPlayerAttackProbability() {
        return this.playerAttackProbability;
    }

    public int getPlayerEvasion() {
        return this.playerEvasion;
    }

    public int getDefenseDuration() {
        return this.defenseDuration;
    }

    public int getFleeGoodProbability() {
        return this.fleeGoodProbability;
    }

    public int getFleeBadProbability() {
        return this.fleeBadProbability;
    }

    public EntityInfo getEntityInfo(String classFullName) {
        return this.entityInfoMap.get(classFullName).clone();
    }

    protected EntityInfo getEntityInfoReference(String classFullName) {
        return this.entityInfoMap.get(classFullName);
    }

    protected EntityInfo getMatchingEntityInfo(Object entity) {
        if (entity == null) {
            return null;
        }
        EntityInfo matching = this.entityInfoMap.get(entity.getClass().getName());
        if (matching != null && matching.classType.isInstance(entity)) {
            for (Class c : matching.conflictingTypes) {
                if (!c.isInstance(entity)) continue;
                return this.entityInfoMap.get(c.getName());
            }
            return matching;
        }
        return null;
    }

    private int getConfigFileVersion(File configFile) {
        try {
            return this.getConfigFileVersion(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private int getConfigFileVersion(InputStream configStream) {
        int configVersion = 1;
        try {
            XMLStreamReader xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(configStream);
            while (xmlReader.hasNext()) {
                xmlReader.next();
                if (!xmlReader.isStartElement() || !xmlReader.getLocalName().equals("Version")) continue;
                configVersion = Integer.parseInt(xmlReader.getElementText());
                break;
            }
            xmlReader.close();
        }
        catch (Exception e) {
            return 0;
        }
        return configVersion;
    }

    public boolean isIgnoreBattleType(EntityInfo.Category type) {
        return this.ignoreBattleTypes.contains((Object)type);
    }
}

