/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import java.util.ArrayList;
import java.util.List;

public class EntityInfo {
    public Class classType = null;
    public List<Class> conflictingTypes = new ArrayList<Class>();
    public boolean ignoreBattle = false;
    public int attackPower = 0;
    public int attackProbability = 70;
    public int attackVariance = 0;
    public Effect attackEffect = Effect.UNKNOWN;
    public int attackEffectProbability = 50;
    public int defenseDamage = 0;
    public int defenseDamageProbability = 0;
    public int evasion = 15;
    public int speed = 50;
    public Category category = Category.UNKNOWN;
    public int decisionAttack = 70;
    public int decisionDefend = 20;
    public int decisionFlee = 10;

    public EntityInfo clone() {
        EntityInfo newEntityInfo = new EntityInfo();
        newEntityInfo.classType = this.classType;
        newEntityInfo.conflictingTypes = new ArrayList<Class>();
        for (Class c : this.conflictingTypes) {
            newEntityInfo.conflictingTypes.add(c);
        }
        newEntityInfo.ignoreBattle = this.ignoreBattle;
        newEntityInfo.attackPower = this.attackPower;
        newEntityInfo.attackProbability = this.attackProbability;
        newEntityInfo.attackVariance = this.attackVariance;
        newEntityInfo.attackEffect = this.attackEffect;
        newEntityInfo.attackEffectProbability = this.attackEffectProbability;
        newEntityInfo.defenseDamage = this.defenseDamage;
        newEntityInfo.defenseDamageProbability = this.defenseDamageProbability;
        newEntityInfo.evasion = this.evasion;
        newEntityInfo.speed = this.speed;
        newEntityInfo.category = this.category;
        newEntityInfo.decisionAttack = this.decisionAttack;
        newEntityInfo.decisionDefend = this.decisionDefend;
        newEntityInfo.decisionFlee = this.decisionFlee;
        return newEntityInfo;
    }

    public static enum Effect {
        SPEED,
        SLOW,
        HASTE,
        MINING_FATIGUE,
        STRENGTH,
        JUMP_BOOST,
        NAUSEA,
        REGENERATION,
        RESISTANCE,
        FIRE_RESISTANCE,
        WATER_BREATHING,
        INVISIBILITY,
        BLINDNESS,
        NIGHT_VISION,
        HUNGER,
        WEAKNESS,
        POISON,
        WITHER,
        ABSORPTION,
        SATURATION,
        GLOWING,
        LEVITATION,
        LUCK,
        UNLUCK,
        FIRE,
        UNKNOWN;


        public static Effect fromString(String c) {
            if ((c = c.toLowerCase()).equals("speed")) {
                return SPEED;
            }
            if (c.equals("slow")) {
                return SLOW;
            }
            if (c.equals("haste")) {
                return HASTE;
            }
            if (c.equals("mining_fatigue") || c.equals("fatigue")) {
                return MINING_FATIGUE;
            }
            if (c.equals("strength")) {
                return STRENGTH;
            }
            if (c.equals("jump_boost")) {
                return JUMP_BOOST;
            }
            if (c.equals("nausea")) {
                return NAUSEA;
            }
            if (c.equals("regeneration")) {
                return REGENERATION;
            }
            if (c.equals("resistance")) {
                return RESISTANCE;
            }
            if (c.equals("fire_resistance")) {
                return FIRE_RESISTANCE;
            }
            if (c.equals("water_breathing")) {
                return WATER_BREATHING;
            }
            if (c.equals("invisibility")) {
                return INVISIBILITY;
            }
            if (c.equals("blindness") || c.equals("blind")) {
                return BLINDNESS;
            }
            if (c.equals("night_vision")) {
                return NIGHT_VISION;
            }
            if (c.equals("hunger")) {
                return HUNGER;
            }
            if (c.equals("weakness")) {
                return WEAKNESS;
            }
            if (c.equals("poison")) {
                return POISON;
            }
            if (c.equals("wither")) {
                return WITHER;
            }
            if (c.equals("absorption")) {
                return ABSORPTION;
            }
            if (c.equals("saturation")) {
                return SATURATION;
            }
            if (c.equals("glowing")) {
                return GLOWING;
            }
            if (c.equals("levitation")) {
                return LEVITATION;
            }
            if (c.equals("luck")) {
                return LUCK;
            }
            if (c.equals("unluck")) {
                return UNLUCK;
            }
            if (c.equals("fire")) {
                return FIRE;
            }
            return UNKNOWN;
        }
    }

    public static enum Category {
        MONSTER,
        PASSIVE,
        ANIMAL,
        BOSS,
        UNKNOWN;


        public static Category fromString(String c) {
            if ((c = c.toLowerCase()).equals("monster")) {
                return MONSTER;
            }
            if (c.equals("passive")) {
                return PASSIVE;
            }
            if (c.equals("animal")) {
                return ANIMAL;
            }
            if (c.equals("boss")) {
                return BOSS;
            }
            return UNKNOWN;
        }
    }
}

