/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.AttackEventHandler;
import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleManager;
import com.seodisparate.TurnBasedMinecraft.common.CommonProxy;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import java.time.Duration;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="com.seodisparate.turnbasedminecraft", name="Turn Based Minecraft Mod", version="0.1", acceptedMinecraftVersions="[1.12.2]")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com.seodisparate.turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "0.1";
    public static final Duration BattleDecisionTime = Duration.ofSeconds(15L);
    public static final String CONFIG_FILENAME = "TBM_Config.xml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.xml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/TurnBasedMinecraft/TBM_Config.xml";
    private static int CONFIG_FILE_VERSION = 0;
    public static final SimpleNetworkWrapper NWINSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("seodisparate.tbmc");
    protected static Logger logger;
    protected static BattleManager battleManager;
    private static int packetHandlerID;
    protected static Entity attackingEntity;
    protected static int attackingDamage;
    protected static Config config;
    public static Battle currentBattle;
    @SidedProxy(modId="com.seodisparate.turnbasedminecraft", serverSide="com.seodisparate.TurnBasedMinecraft.common.CommonProxy", clientSide="com.seodisparate.TurnBasedMinecraft.client.ClientProxy")
    public static CommonProxy commonProxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.debug("PREINIT");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        currentBattle = null;
        battleManager = null;
        config = new Config(logger);
        NWINSTANCE.registerMessage(PacketBattleInfo.HandlerBattleInfo.class, PacketBattleInfo.class, packetHandlerID++, Side.CLIENT);
        NWINSTANCE.registerMessage(PacketBattleRequestInfo.HandlerBattleRequestInfo.class, PacketBattleRequestInfo.class, packetHandlerID++, Side.SERVER);
        NWINSTANCE.registerMessage(PacketBattleDecision.HandleBattleDecision.class, PacketBattleDecision.class, packetHandlerID++, Side.SERVER);
        NWINSTANCE.registerMessage(PacketBattleMessage.HandlerBattleMessage.class, PacketBattleMessage.class, packetHandlerID++, Side.CLIENT);
        logger.debug("INIT");
        MinecraftForge.EVENT_BUS.register((Object)new AttackEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.debug("POSTINIT");
    }

    public static BattleManager getBattleManager() {
        return battleManager;
    }

    public static void setConfigVersion(int version) {
        CONFIG_FILE_VERSION = version;
    }

    public static int getConfigVersion() {
        return CONFIG_FILE_VERSION;
    }

    static {
        packetHandlerID = 0;
        attackingDamage = 0;
        currentBattle = null;
    }
}

