/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class BattleMusic {
    private Logger logger;
    private ArrayList<File> battleMusic;
    private ArrayList<File> sillyMusic;
    private boolean initialized = false;
    private File nextBattle;
    private File nextSilly;
    private Sequencer sequencer;
    private Clip clip;
    private boolean playingIsSilly;

    public BattleMusic(Logger logger) {
        File[] sillyFiles;
        File[] battleFiles;
        this.logger = logger;
        this.battleMusic = new ArrayList();
        this.sillyMusic = new ArrayList();
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
        }
        catch (Exception e) {
            logger.error("Failed to load midi sequencer");
            return;
        }
        try {
            this.clip = AudioSystem.getClip();
        }
        catch (LineUnavailableException e) {
            logger.error("Failed to load clip (for wav)");
            return;
        }
        File battleMusicFolder = new File("config/TurnBasedMinecraft/Music/battle/");
        File sillyMusicFolder = new File("config/TurnBasedMinecraft/Music/silly/");
        if (!battleMusicFolder.exists() && !battleMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/battle/");
            return;
        }
        if (!sillyMusicFolder.exists() && !sillyMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/silly/");
            return;
        }
        for (File f : battleFiles = battleMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("mid") || ext.equals("wav");
            }
        })) {
            this.battleMusic.add(f);
        }
        for (File f : sillyFiles = sillyMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("mid") || ext.equals("wav");
            }
        })) {
            this.sillyMusic.add(f);
        }
        this.pickNextBattle();
        this.pickNextSilly();
        this.initialized = true;
    }

    private void pickNextBattle() {
        if (!this.initialized || this.battleMusic.isEmpty()) {
            this.nextBattle = null;
            return;
        }
        this.nextBattle = this.battleMusic.get((int)(Math.random() * (double)this.battleMusic.size()));
    }

    private void pickNextSilly() {
        if (!this.initialized || this.sillyMusic.isEmpty()) {
            this.nextSilly = null;
            return;
        }
        this.nextSilly = this.sillyMusic.get((int)(Math.random() * (double)this.sillyMusic.size()));
    }

    public void playBattle() {
        if (!this.initialized) {
            return;
        }
        this.play(this.nextBattle);
        this.pickNextBattle();
        this.playingIsSilly = false;
    }

    public void playSilly() {
        if (!this.initialized) {
            return;
        }
        this.play(this.nextSilly);
        this.pickNextSilly();
        this.playingIsSilly = true;
    }

    private void play(File next) {
        if (this.initialized && next != null) {
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147118_V().func_147689_b());
            String suffix = next.getName().substring(next.getName().length() - 3).toLowerCase();
            if (suffix.equals("mid")) {
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                try {
                    this.sequencer.setSequence(new BufferedInputStream(new FileInputStream(next)));
                }
                catch (Exception e) {
                    this.logger.error("Failed to play battle music (midi)");
                    return;
                }
                this.sequencer.setLoopCount(-1);
                this.sequencer.start();
            } else if (suffix.equals("wav")) {
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                try {
                    this.clip.open(AudioSystem.getAudioInputStream(next));
                }
                catch (Exception e) {
                    this.logger.error("Failed to load battle music (wav)");
                    return;
                }
                this.clip.loop(-1);
                this.clip.start();
            }
        }
    }

    public void stopMusic() {
        if (this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
        if (this.clip.isActive()) {
            this.clip.stop();
            this.clip.close();
        }
    }

    public boolean isPlayingSilly() {
        return this.playingIsSilly;
    }

    public boolean isPlaying() {
        return this.sequencer.isRunning() || this.clip.isActive();
    }
}

