/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.client;

import com.seodisparate.TurnBasedMinecraft.client.BattleGui;
import com.seodisparate.TurnBasedMinecraft.client.BattleMusic;
import com.seodisparate.TurnBasedMinecraft.common.CommonProxy;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.apache.logging.log4j.Logger;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = new BattleGui();
    private BattleMusic battleMusic = null;
    private Logger logger;
    private Config config;

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.timeRemaining.set(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Minecraft.func_71410_x().field_71462_r != this.battleGui) {
                this.battleGui.turnEnd();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.battleGui);
            }
        });
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleEnded() {
        TurnBasedMinecraftMod.currentBattle = null;
        Minecraft.func_71410_x().func_152344_a(() -> {
            Minecraft.func_71410_x().func_147108_a(null);
            Minecraft.func_71410_x().func_71381_h();
        });
    }

    @Override
    public void postInit() {
        this.battleMusic = new BattleMusic(this.logger);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void playBattleMusic() {
        this.battleMusic.playBattle();
    }

    @Override
    public void playSillyMusic() {
        this.battleMusic.playSilly();
    }

    @Override
    public void stopMusic() {
        this.battleMusic.stopMusic();
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (type == null || type.isEmpty() || this.config.isBattleMusicType(type)) {
            if (this.battleMusic.isPlaying()) {
                if (this.battleMusic.isPlayingSilly()) {
                    this.stopMusic();
                    this.playBattleMusic();
                }
            } else {
                this.playBattleMusic();
            }
        } else if (this.config.isSillyMusicType(type)) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly()) {
                    this.stopMusic();
                    this.playSillyMusic();
                }
            } else {
                this.playSillyMusic();
            }
        }
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }
}

