/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class Combatant {
    public Entity entity;
    public Battle.Decision decision;
    public int itemToUse;
    public EntityInfo entityInfo;
    public boolean recalcSpeedOnCompare;
    public int targetEntityID;
    public boolean isSideA;
    public int remainingDefenses;

    public Combatant() {
        this.decision = Battle.Decision.UNDECIDED;
        this.recalcSpeedOnCompare = false;
        this.remainingDefenses = 0;
    }

    public Combatant(Entity e, EntityInfo entityInfo) {
        this.entity = e;
        this.decision = Battle.Decision.UNDECIDED;
        this.entityInfo = entityInfo;
        this.recalcSpeedOnCompare = false;
        this.remainingDefenses = 0;
    }

    public static class CombatantComparator
    implements Comparator<Combatant> {
        @Override
        public int compare(Combatant c0, Combatant c1) {
            boolean isSlow;
            boolean isHaste;
            if (c0.entity instanceof EntityPlayer && c0.recalcSpeedOnCompare) {
                EntityLivingBase c0Entity = (EntityLivingBase)c0.entity;
                isHaste = false;
                isSlow = false;
                for (PotionEffect e : c0Entity.func_70651_bq()) {
                    if (e.func_76453_d().equals(MobEffects.field_76422_e.func_76393_a()) || e.func_76453_d().equals(MobEffects.field_76424_c.func_76393_a())) {
                        isHaste = true;
                        continue;
                    }
                    if (!e.func_76453_d().equals(MobEffects.field_76421_d.func_76393_a())) continue;
                    isSlow = true;
                }
                if (c0.entityInfo == null) {
                    c0.entityInfo = new EntityInfo();
                }
                c0.entityInfo.speed = isHaste && !isSlow ? TurnBasedMinecraftMod.config.getPlayerHasteSpeed() : (isSlow && !isHaste ? TurnBasedMinecraftMod.config.getPlayerSlowSpeed() : TurnBasedMinecraftMod.config.getPlayerSpeed());
            }
            if (c1.entity instanceof EntityPlayer && c1.recalcSpeedOnCompare) {
                EntityLivingBase c1Entity = (EntityLivingBase)c1.entity;
                isHaste = false;
                isSlow = false;
                for (PotionEffect e : c1Entity.func_70651_bq()) {
                    if (e.func_76453_d().equals(MobEffects.field_76422_e.func_76393_a())) {
                        isHaste = true;
                        continue;
                    }
                    if (!e.func_76453_d().equals(MobEffects.field_76421_d.func_76393_a())) continue;
                    isSlow = true;
                }
                if (c1.entityInfo == null) {
                    c1.entityInfo = new EntityInfo();
                }
                c1.entityInfo.speed = isHaste && !isSlow ? TurnBasedMinecraftMod.config.getPlayerHasteSpeed() : (isSlow && !isHaste ? TurnBasedMinecraftMod.config.getPlayerSlowSpeed() : TurnBasedMinecraftMod.config.getPlayerSpeed());
            }
            if (c0.entityInfo.speed > c1.entityInfo.speed) {
                return -1;
            }
            if (c0.entityInfo.speed < c1.entityInfo.speed) {
                return 1;
            }
            return 0;
        }
    }
}

