/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public class EntityInfo {
    public Class classType = null;
    public boolean ignoreBattle = false;
    public int attackPower = 0;
    public int attackProbability = 70;
    public int attackVariance = 0;
    public Effect attackEffect = Effect.UNKNOWN;
    public int attackEffectProbability = 50;
    public int defenseDamage = 0;
    public int defenseDamageProbability = 0;
    public int evasion = 15;
    public int speed = 50;
    public String category = "unknown";
    public int decisionAttack = 70;
    public int decisionDefend = 20;
    public int decisionFlee = 10;

    public EntityInfo clone() {
        EntityInfo newEntityInfo = new EntityInfo();
        newEntityInfo.classType = this.classType;
        newEntityInfo.ignoreBattle = this.ignoreBattle;
        newEntityInfo.attackPower = this.attackPower;
        newEntityInfo.attackProbability = this.attackProbability;
        newEntityInfo.attackVariance = this.attackVariance;
        newEntityInfo.attackEffect = this.attackEffect;
        newEntityInfo.attackEffectProbability = this.attackEffectProbability;
        newEntityInfo.defenseDamage = this.defenseDamage;
        newEntityInfo.defenseDamageProbability = this.defenseDamageProbability;
        newEntityInfo.evasion = this.evasion;
        newEntityInfo.speed = this.speed;
        newEntityInfo.category = this.category;
        newEntityInfo.decisionAttack = this.decisionAttack;
        newEntityInfo.decisionDefend = this.decisionDefend;
        newEntityInfo.decisionFlee = this.decisionFlee;
        return newEntityInfo;
    }

    public static enum Effect {
        SPEED,
        SLOW,
        HASTE,
        MINING_FATIGUE,
        STRENGTH,
        JUMP_BOOST,
        NAUSEA,
        REGENERATION,
        RESISTANCE,
        FIRE_RESISTANCE,
        WATER_BREATHING,
        INVISIBILITY,
        BLINDNESS,
        NIGHT_VISION,
        HUNGER,
        WEAKNESS,
        POISON,
        WITHER,
        ABSORPTION,
        SATURATION,
        GLOWING,
        LEVITATION,
        LUCK,
        UNLUCK,
        FIRE,
        UNKNOWN;


        public static Effect fromString(String c) {
            if ((c = c.toLowerCase()).equals("speed")) {
                return SPEED;
            }
            if (c.equals("slow")) {
                return SLOW;
            }
            if (c.equals("haste")) {
                return HASTE;
            }
            if (c.equals("mining_fatigue") || c.equals("fatigue")) {
                return MINING_FATIGUE;
            }
            if (c.equals("strength")) {
                return STRENGTH;
            }
            if (c.equals("jump_boost")) {
                return JUMP_BOOST;
            }
            if (c.equals("nausea")) {
                return NAUSEA;
            }
            if (c.equals("regeneration")) {
                return REGENERATION;
            }
            if (c.equals("resistance")) {
                return RESISTANCE;
            }
            if (c.equals("fire_resistance")) {
                return FIRE_RESISTANCE;
            }
            if (c.equals("water_breathing")) {
                return WATER_BREATHING;
            }
            if (c.equals("invisibility")) {
                return INVISIBILITY;
            }
            if (c.equals("blindness") || c.equals("blind")) {
                return BLINDNESS;
            }
            if (c.equals("night_vision")) {
                return NIGHT_VISION;
            }
            if (c.equals("hunger")) {
                return HUNGER;
            }
            if (c.equals("weakness")) {
                return WEAKNESS;
            }
            if (c.equals("poison")) {
                return POISON;
            }
            if (c.equals("wither")) {
                return WITHER;
            }
            if (c.equals("absorption")) {
                return ABSORPTION;
            }
            if (c.equals("saturation")) {
                return SATURATION;
            }
            if (c.equals("glowing")) {
                return GLOWING;
            }
            if (c.equals("levitation")) {
                return LEVITATION;
            }
            if (c.equals("luck")) {
                return LUCK;
            }
            if (c.equals("unluck")) {
                return UNLUCK;
            }
            if (c.equals("fire")) {
                return FIRE;
            }
            return UNKNOWN;
        }

        public PotionEffect getPotionEffect() {
            return this.getPotionEffect(140, 0);
        }

        public PotionEffect getPotionEffect(int duration, int amplifier) {
            switch (this) {
                case SPEED: {
                    return new PotionEffect(MobEffects.field_76424_c, duration, amplifier);
                }
                case SLOW: {
                    return new PotionEffect(MobEffects.field_76421_d, duration, amplifier);
                }
                case HASTE: {
                    return new PotionEffect(MobEffects.field_76422_e, duration, amplifier);
                }
                case MINING_FATIGUE: {
                    return new PotionEffect(MobEffects.field_76419_f, duration, amplifier);
                }
                case STRENGTH: {
                    return new PotionEffect(MobEffects.field_76420_g, duration, amplifier);
                }
                case JUMP_BOOST: {
                    return new PotionEffect(MobEffects.field_76430_j, duration, amplifier);
                }
                case NAUSEA: {
                    return new PotionEffect(MobEffects.field_76431_k, duration, amplifier);
                }
                case REGENERATION: {
                    return new PotionEffect(MobEffects.field_76428_l, duration, amplifier);
                }
                case RESISTANCE: {
                    return new PotionEffect(MobEffects.field_76429_m, duration, amplifier);
                }
                case FIRE_RESISTANCE: {
                    return new PotionEffect(MobEffects.field_76426_n, duration, amplifier);
                }
                case WATER_BREATHING: {
                    return new PotionEffect(MobEffects.field_76427_o, duration, amplifier);
                }
                case INVISIBILITY: {
                    return new PotionEffect(MobEffects.field_76441_p, duration, amplifier);
                }
                case BLINDNESS: {
                    return new PotionEffect(MobEffects.field_76440_q, duration, amplifier);
                }
                case NIGHT_VISION: {
                    return new PotionEffect(MobEffects.field_76439_r, duration, amplifier);
                }
                case HUNGER: {
                    return new PotionEffect(MobEffects.field_76438_s, duration, amplifier);
                }
                case WEAKNESS: {
                    return new PotionEffect(MobEffects.field_76437_t, duration, amplifier);
                }
                case POISON: {
                    return new PotionEffect(MobEffects.field_76436_u, duration, amplifier);
                }
                case WITHER: {
                    return new PotionEffect(MobEffects.field_82731_v, duration, amplifier);
                }
                case ABSORPTION: {
                    return new PotionEffect(MobEffects.field_76444_x, duration, amplifier);
                }
                case SATURATION: {
                    return new PotionEffect(MobEffects.field_76443_y, duration, amplifier);
                }
                case GLOWING: {
                    return new PotionEffect(MobEffects.field_188423_x, duration, amplifier);
                }
                case LEVITATION: {
                    return new PotionEffect(MobEffects.field_188424_y, duration, amplifier);
                }
                case LUCK: {
                    return new PotionEffect(MobEffects.field_188425_z, duration, amplifier);
                }
                case UNLUCK: {
                    return new PotionEffect(MobEffects.field_189112_A, duration, amplifier);
                }
                case FIRE: {
                    return null;
                }
            }
            return null;
        }

        public void applyEffectToEntity(EntityLivingBase entity) {
            this.applyEffectToEntity(entity, 140, 0);
        }

        public void applyEffectToEntity(EntityLivingBase entity, int duration, int amplifier) {
            if (this == FIRE) {
                entity.func_70015_d(duration / 20);
                return;
            }
            if (this != UNKNOWN) {
                entity.func_70690_d(this.getPotionEffect(duration, amplifier));
            }
        }

        public String getAffectedString() {
            switch (this) {
                case SPEED: {
                    return "made faster";
                }
                case SLOW: {
                    return "made slower";
                }
                case HASTE: {
                    return "made hastier";
                }
                case MINING_FATIGUE: {
                    return "fatigued";
                }
                case STRENGTH: {
                    return "strengthened";
                }
                case JUMP_BOOST: {
                    return "jump boosted";
                }
                case NAUSEA: {
                    return "made nauseous";
                }
                case REGENERATION: {
                    return "given regeneration";
                }
                case RESISTANCE: {
                    return "given resistance";
                }
                case FIRE_RESISTANCE: {
                    return "given fire resistance";
                }
                case WATER_BREATHING: {
                    return "made able to breathe underwater";
                }
                case INVISIBILITY: {
                    return "given invisibility";
                }
                case BLINDNESS: {
                    return "made blind";
                }
                case NIGHT_VISION: {
                    return "given night vision";
                }
                case HUNGER: {
                    return "made hungry";
                }
                case WEAKNESS: {
                    return "made weak";
                }
                case POISON: {
                    return "poisoned";
                }
                case WITHER: {
                    return "withered";
                }
                case ABSORPTION: {
                    return "given absorption";
                }
                case SATURATION: {
                    return "given saturation";
                }
                case GLOWING: {
                    return "made to glow";
                }
                case LEVITATION: {
                    return "made to levitate";
                }
                case LUCK: {
                    return "given luck";
                }
                case UNLUCK: {
                    return "made unlucky";
                }
                case FIRE: {
                    return "set on fire";
                }
            }
            return "given unknown";
        }
    }
}

