/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class BattleMusic {
    private Logger logger;
    private ArrayList<File> battleMusic;
    private ArrayList<File> sillyMusic;
    private boolean initialized = false;
    private File nextBattle;
    private File nextSilly;
    private Sequencer sequencer;
    private Clip clip;
    private boolean playingIsSilly;
    private boolean isPlaying;

    public BattleMusic(Logger logger) {
        File[] sillyFiles;
        File[] battleFiles;
        this.logger = logger;
        this.battleMusic = new ArrayList();
        this.sillyMusic = new ArrayList();
        this.isPlaying = false;
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
        }
        catch (Throwable t) {
            logger.error("Failed to load midi sequencer");
            return;
        }
        try {
            this.clip = AudioSystem.getClip();
        }
        catch (LineUnavailableException e) {
            logger.error("Failed to load clip (for wav)");
            return;
        }
        File battleMusicFolder = new File("config/TurnBasedMinecraft/Music/battle/");
        File sillyMusicFolder = new File("config/TurnBasedMinecraft/Music/silly/");
        if (!battleMusicFolder.exists() && !battleMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/battle/");
            return;
        }
        if (!sillyMusicFolder.exists() && !sillyMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/silly/");
            return;
        }
        for (File f : battleFiles = battleMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("mid") || ext.equals("wav");
            }
        })) {
            this.battleMusic.add(f);
        }
        for (File f : sillyFiles = sillyMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("mid") || ext.equals("wav");
            }
        })) {
            this.sillyMusic.add(f);
        }
        this.initialized = true;
        this.pickNextBattle();
        this.pickNextSilly();
    }

    private void pickNextBattle() {
        this.nextBattle = !this.initialized || this.battleMusic.isEmpty() ? null : this.battleMusic.get((int)(Math.random() * (double)this.battleMusic.size()));
    }

    private void pickNextSilly() {
        this.nextSilly = !this.initialized || this.sillyMusic.isEmpty() ? null : this.sillyMusic.get((int)(Math.random() * (double)this.sillyMusic.size()));
    }

    public void playBattle(float volume) {
        if (!this.initialized || volume <= 0.0f || this.battleMusic.isEmpty()) {
            return;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.play(this.nextBattle, volume);
        this.pickNextBattle();
        this.playingIsSilly = false;
        this.isPlaying = true;
    }

    public void playSilly(float volume) {
        if (!this.initialized || volume <= 0.0f || this.sillyMusic.isEmpty()) {
            return;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.play(this.nextSilly, volume);
        this.pickNextSilly();
        this.playingIsSilly = true;
        this.isPlaying = true;
    }

    private void play(File next, float volume) {
        if (this.initialized && next != null) {
            this.logger.debug("play called with file " + next.getName() + " and vol " + volume);
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147118_V().func_147689_b());
            String suffix = next.getName().substring(next.getName().length() - 3).toLowerCase();
            if (suffix.equals("mid")) {
                this.sequencer.stop();
                this.clip.stop();
                this.clip.close();
                try {
                    this.sequencer.setSequence(new BufferedInputStream(new FileInputStream(next)));
                }
                catch (Throwable t) {
                    this.logger.error("Failed to play battle music (midi)");
                    return;
                }
                this.sequencer.setLoopCount(-1);
                this.sequencer.start();
            } else if (suffix.equals("wav")) {
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                try {
                    this.clip.open(AudioSystem.getAudioInputStream(next));
                }
                catch (Throwable t) {
                    this.logger.error("Failed to load battle music (wav)");
                    return;
                }
                FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                gainControl.setValue(volume * 20.0f - 20.0f);
                this.clip.loop(-1);
                this.clip.start();
            }
        }
    }

    public void stopMusic(boolean resumeMCSounds) {
        this.sequencer.stop();
        this.clip.stop();
        this.clip.close();
        if (resumeMCSounds) {
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147118_V().func_147687_e());
        }
        this.isPlaying = false;
    }

    public boolean isPlayingSilly() {
        return this.playingIsSilly;
    }

    public boolean isPlaying() {
        return this.isPlaying || this.sequencer.isRunning() || this.clip.isActive();
    }

    public boolean hasBattleMusic() {
        return !this.battleMusic.isEmpty();
    }

    public boolean hasSillyMusic() {
        return !this.sillyMusic.isEmpty();
    }
}

