/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.client;

import com.seodisparate.TurnBasedMinecraft.client.BattleGui;
import com.seodisparate.TurnBasedMinecraft.client.BattleMusic;
import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = null;
    private BattleMusic battleMusic = null;
    private int battleMusicCount = 0;
    private int sillyMusicCount = 0;
    private Battle localBattle = null;

    @Override
    public void initialize() {
        super.initialize();
        this.battleGui = new BattleGui();
        this.battleMusic = null;
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
        this.localBattle = null;
    }

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.setTimeRemaining(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Minecraft.func_71410_x().field_71462_r != this.battleGui) {
                this.battleGui.turnEnd();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.battleGui);
            }
        });
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleStarted() {
        this.setBattleGuiAsGui();
    }

    @Override
    public void battleEnded() {
        this.localBattle = null;
        Minecraft.func_71410_x().func_152344_a(() -> {
            Minecraft.func_71410_x().func_147108_a(null);
            Minecraft.func_71410_x().func_71381_h();
        });
        this.stopMusic(true);
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
    }

    @Override
    public void postInit() {
        super.postInit();
        this.battleMusic = new BattleMusic(this.getLogger());
    }

    @Override
    public void playBattleMusic() {
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        this.battleMusic.playBattle(gs.func_186711_a(SoundCategory.MUSIC) * gs.func_186711_a(SoundCategory.MASTER));
    }

    @Override
    public void playSillyMusic() {
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        this.battleMusic.playSilly(gs.func_186711_a(SoundCategory.MUSIC) * gs.func_186711_a(SoundCategory.MASTER));
    }

    @Override
    public void stopMusic(boolean resumeMCSounds) {
        this.battleMusic.stopMusic(resumeMCSounds);
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            ++this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            ++this.sillyMusicCount;
        } else {
            ++this.battleMusicCount;
        }
        this.checkBattleTypes();
    }

    @Override
    public void typeLeftBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            --this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            --this.sillyMusicCount;
        } else {
            --this.battleMusicCount;
        }
        this.checkBattleTypes();
    }

    @Override
    public void displayString(String message) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(message));
    }

    @Override
    public Entity getEntityByID(int id) {
        return Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
    }

    private void checkBattleTypes() {
        float percentage = 0.0f;
        percentage = this.sillyMusicCount == 0 && this.battleMusicCount == 0 ? 0.0f : (this.battleMusicCount == 0 ? 100.0f : 100.0f * (float)this.sillyMusicCount / (float)(this.sillyMusicCount + this.battleMusicCount));
        if (percentage >= (float)this.getConfig().getSillyMusicThreshold()) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly() && this.battleMusic.hasSillyMusic()) {
                    this.stopMusic(false);
                    this.playSillyMusic();
                }
            } else if (this.battleMusic.hasSillyMusic()) {
                this.playSillyMusic();
            }
        } else if (this.battleMusic.isPlaying()) {
            if (this.battleMusic.isPlayingSilly() && this.battleMusic.hasBattleMusic()) {
                this.stopMusic(false);
                this.playBattleMusic();
            }
        } else if (this.battleMusic.hasBattleMusic()) {
            this.playBattleMusic();
        }
    }

    @Override
    public Battle getLocalBattle() {
        return this.localBattle;
    }

    @Override
    public void createLocalBattle(int id) {
        this.localBattle = new Battle(id, null, null, false);
    }
}

