/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.OtherModHandler;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    private Set<AttackerViaBow> attackerViaBow = null;
    private BattleManager battleManager = null;
    private Entity attackingEntity = null;
    private int attackingDamage = 0;
    private Config config = null;
    protected Logger logger = null;
    private Map<Integer, EditingInfo> editingPlayers;
    private OtherModHandler otherModHandler;

    public final void initialize() {
        this.attackerViaBow = new HashSet<AttackerViaBow>();
        this.editingPlayers = new Hashtable<Integer, EditingInfo>();
        this.initializeClient();
        this.otherModHandler = new OtherModHandler();
        this.logger.debug("Init proxy for com_burnedkirby_turnbasedminecraft");
    }

    protected void initializeClient() {
    }

    public final boolean initializeBattleManager() {
        if (this.battleManager == null) {
            this.battleManager = new BattleManager(TurnBasedMinecraftMod.logger);
            return true;
        }
        return false;
    }

    public final boolean cleanupBattleManager() {
        if (this.battleManager != null) {
            this.battleManager.cleanup();
            this.battleManager = null;
            return true;
        }
        return false;
    }

    public void setBattleGuiTime(int timeRemaining) {
    }

    public void setBattleGuiBattleChanged() {
    }

    public void setBattleGuiAsGui() {
    }

    public void battleGuiTurnBegin() {
    }

    public void battleGuiTurnEnd() {
    }

    public void battleStarted() {
    }

    public void battleEnded() {
    }

    public final void postInit() {
        this.config = new Config(this.logger);
        this.postInitClient();
        this.pamsFoodIntegrationLoading();
        this.logger.debug("postInit proxy for com_burnedkirby_turnbasedminecraft");
        this.otherModHandler.postInit();
    }

    protected void postInitClient() {
    }

    private final void pamsFoodIntegrationLoading() {
        ItemGroup foodItemGroup;
        Field itemGroupField;
        Object pamsFoodCore;
        ModList modList = ModList.get();
        Optional pamsFoodCoreContainer = modList.getModContainerById("pamhc2foodcore");
        if (pamsFoodCoreContainer.isPresent()) {
            pamsFoodCore = ((ModContainer)pamsFoodCoreContainer.get()).getMod();
            try {
                itemGroupField = pamsFoodCore.getClass().getField("ITEM_GROUP");
                foodItemGroup = (ItemGroup)itemGroupField.get(null);
                if (foodItemGroup == null) {
                    throw new NullPointerException();
                }
                BattleManager.addOtherModItemGroup(foodItemGroup);
            }
            catch (Exception e) {
                TurnBasedMinecraftMod.logger.info("Failed to get pamhc2foodcore ITEM_GROUP");
            }
        }
        if ((pamsFoodCoreContainer = (modList = ModList.get()).getModContainerById("pamhc2crops")).isPresent()) {
            pamsFoodCore = ((ModContainer)pamsFoodCoreContainer.get()).getMod();
            try {
                itemGroupField = pamsFoodCore.getClass().getField("ITEM_GROUP");
                foodItemGroup = (ItemGroup)itemGroupField.get(null);
                if (foodItemGroup == null) {
                    throw new NullPointerException();
                }
                BattleManager.addOtherModItemGroup(foodItemGroup);
            }
            catch (Exception e) {
                TurnBasedMinecraftMod.logger.info("Failed to get pamhc2crops ITEM_GROUP");
            }
        }
        if ((pamsFoodCoreContainer = (modList = ModList.get()).getModContainerById("pamhc2trees")).isPresent()) {
            pamsFoodCore = ((ModContainer)pamsFoodCoreContainer.get()).getMod();
            try {
                itemGroupField = pamsFoodCore.getClass().getField("ITEM_GROUP");
                foodItemGroup = (ItemGroup)itemGroupField.get(null);
                if (foodItemGroup == null) {
                    throw new NullPointerException();
                }
                BattleManager.addOtherModItemGroup(foodItemGroup);
            }
            catch (Exception e) {
                TurnBasedMinecraftMod.logger.info("Failed to get pamhc2trees ITEM_GROUP");
            }
        }
        if ((pamsFoodCoreContainer = (modList = ModList.get()).getModContainerById("pamhc2foodextended")).isPresent()) {
            pamsFoodCore = ((ModContainer)pamsFoodCoreContainer.get()).getMod();
            try {
                itemGroupField = pamsFoodCore.getClass().getField("ITEM_GROUP");
                foodItemGroup = (ItemGroup)itemGroupField.get(null);
                if (foodItemGroup == null) {
                    throw new NullPointerException();
                }
                BattleManager.addOtherModItemGroup(foodItemGroup);
            }
            catch (Exception e) {
                TurnBasedMinecraftMod.logger.info("Failed to get pamhc2foodextended ITEM_GROUP");
            }
        }
    }

    public final void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void playBattleMusic() {
    }

    public void playSillyMusic() {
    }

    public void stopMusic(boolean resumeMCSounds) {
    }

    public void typeEnteredBattle(String type) {
    }

    public void typeLeftBattle(String type) {
    }

    public void displayString(String message) {
    }

    public void displayTextComponent(ITextComponent textComponent) {
    }

    public final boolean isServerRunning() {
        return this.battleManager != null;
    }

    public Battle getLocalBattle() {
        return null;
    }

    public void createLocalBattle(int id) {
    }

    public final Set<AttackerViaBow> getAttackerViaBowSet() {
        return this.attackerViaBow;
    }

    public final BattleManager getBattleManager() {
        return this.battleManager;
    }

    protected final void setAttackingEntity(Entity entity) {
        this.attackingEntity = entity;
    }

    protected final Entity getAttackingEntity() {
        return this.attackingEntity;
    }

    protected final void setAttackingDamage(int damage) {
        this.attackingDamage = damage;
    }

    protected final int getAttackingDamage() {
        return this.attackingDamage;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public final Config getConfig() {
        return this.config;
    }

    protected final EditingInfo getEditingInfo(int id) {
        return this.editingPlayers.get(id);
    }

    protected final EditingInfo setEditingPlayer(PlayerEntity player) {
        return this.editingPlayers.put(player.func_145782_y(), new EditingInfo(player));
    }

    protected final EditingInfo removeEditingInfo(int id) {
        return this.editingPlayers.remove(id);
    }

    public Entity getEntity(int id, RegistryKey<World> dim) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(dim).func_73045_a(id);
    }
}

