/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketBattleMessage {
    MessageType messageType;
    int entityIDFrom;
    int entityIDTo;
    int amount;
    String custom;
    RegistryKey<World> dimension;

    public PacketBattleMessage() {
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, RegistryKey<World> dimension, int amount) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, RegistryKey<World> dimension, int amount, String custom) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = custom;
    }

    public static void encode(PacketBattleMessage pkt, PacketBuffer buf) {
        buf.writeInt(pkt.messageType.getValue());
        buf.writeInt(pkt.entityIDFrom);
        buf.writeInt(pkt.entityIDTo);
        buf.func_180714_a(Utility.serializeDimension(pkt.dimension));
        buf.writeInt(pkt.amount);
        buf.func_180714_a(pkt.custom);
    }

    public static PacketBattleMessage decode(PacketBuffer buf) {
        return new PacketBattleMessage(MessageType.valueOf(buf.readInt()), buf.readInt(), buf.readInt(), Utility.deserializeDimension(buf.func_218666_n()), buf.readInt(), buf.func_218666_n());
    }

    public static class Handler {
        public static void handle(PacketBattleMessage pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity fromEntity = TurnBasedMinecraftMod.proxy.getEntity(pkt.entityIDFrom, pkt.dimension);
                String from = "Unknown";
                if (fromEntity != null) {
                    from = fromEntity.func_145748_c_().getString();
                } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (fromEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.entityIDFrom)) != null) {
                    from = fromEntity.func_145748_c_().getString();
                }
                Entity toEntity = TurnBasedMinecraftMod.proxy.getEntity(pkt.entityIDTo, pkt.dimension);
                String to = "Unknown";
                if (toEntity != null) {
                    to = toEntity.func_145748_c_().getString();
                } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (toEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.entityIDTo)) != null) {
                    to = toEntity.func_145748_c_().getString();
                }
                switch (pkt.messageType) {
                    case ENTERED: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " entered battle!");
                        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null || TurnBasedMinecraftMod.proxy.getLocalBattle().getId() != pkt.amount) {
                            TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.amount);
                        }
                        TurnBasedMinecraftMod.proxy.battleStarted();
                        TurnBasedMinecraftMod.proxy.typeEnteredBattle(pkt.custom);
                        break;
                    }
                    case FLEE: {
                        if (pkt.amount != 0) {
                            TurnBasedMinecraftMod.proxy.displayString(from + " fled battle!");
                            TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.custom);
                            break;
                        }
                        TurnBasedMinecraftMod.proxy.displayString(from + " tried to flee battle but failed!");
                        break;
                    }
                    case DIED: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " died in battle!");
                        TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.custom);
                        break;
                    }
                    case ENDED: {
                        TurnBasedMinecraftMod.proxy.displayString("Battle has ended!");
                        TurnBasedMinecraftMod.proxy.battleEnded();
                        break;
                    }
                    case ATTACK: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " attacked " + to + " and dealt " + pkt.amount + " damage!");
                        break;
                    }
                    case DEFEND: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " blocked " + to + "'s attack!");
                        break;
                    }
                    case DEFENSE_DAMAGE: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " retaliated from " + to + "'s attack and dealt " + pkt.amount + " damage!");
                        break;
                    }
                    case MISS: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " attacked " + to + " but missed!");
                        break;
                    }
                    case DEFENDING: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " is defending!");
                        break;
                    }
                    case DID_NOTHING: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " did nothing!");
                        break;
                    }
                    case USED_ITEM: {
                        switch (UsedItemAction.valueOf(pkt.amount)) {
                            case USED_NOTHING: {
                                TurnBasedMinecraftMod.proxy.displayString(from + " tried to use nothing!");
                                break;
                            }
                            case USED_INVALID: {
                                if (pkt.custom.length() > 0) {
                                    TurnBasedMinecraftMod.proxy.displayString(from + " tried to consume " + pkt.custom + " and failed!");
                                    break;
                                }
                                TurnBasedMinecraftMod.proxy.displayString(from + " tried to consume an invalid item and failed!");
                                break;
                            }
                            case USED_FOOD: {
                                TurnBasedMinecraftMod.proxy.displayString(from + " ate a " + pkt.custom + "!");
                                break;
                            }
                            case USED_POTION: {
                                TurnBasedMinecraftMod.proxy.displayString(from + " drank a " + pkt.custom + "!");
                            }
                        }
                        break;
                    }
                    case TURN_BEGIN: {
                        TurnBasedMinecraftMod.proxy.displayString("The turn begins!");
                        TurnBasedMinecraftMod.proxy.battleGuiTurnBegin();
                        break;
                    }
                    case TURN_END: {
                        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                            if (pkt.amount == 0) {
                                TurnBasedMinecraftMod.proxy.displayString("The turn ended!");
                            } else {
                                TurnBasedMinecraftMod.proxy.displayString("The turn ended (abnormally due to internal error)!");
                            }
                        }
                        TurnBasedMinecraftMod.proxy.battleGuiTurnEnd();
                        break;
                    }
                    case SWITCHED_ITEM: {
                        if (pkt.amount != 0) {
                            TurnBasedMinecraftMod.proxy.displayString(from + " switched to a different item!");
                            break;
                        }
                        TurnBasedMinecraftMod.proxy.displayString(from + " switched to a different item but failed because it was invalid!");
                        break;
                    }
                    case WAS_AFFECTED: {
                        TurnBasedMinecraftMod.proxy.displayString(to + " was " + pkt.custom + " by " + from + "!");
                        break;
                    }
                    case BECAME_CREATIVE: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " entered creative mode and left battle!");
                        break;
                    }
                    case FIRED_ARROW: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " let loose an arrow towards " + to + "!");
                        break;
                    }
                    case ARROW_HIT: {
                        TurnBasedMinecraftMod.proxy.displayString(to + " was hit by " + from + "'s arrow!");
                        break;
                    }
                    case BOW_NO_AMMO: {
                        TurnBasedMinecraftMod.proxy.displayString(from + " tried to use their bow but ran out of ammo!");
                        break;
                    }
                    case CREEPER_WAIT: {
                        StringTextComponent prefix = new StringTextComponent("TBM: ");
                        prefix.func_230530_a_(prefix.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-16711936)).func_240713_a_(Boolean.valueOf(true)));
                        StringTextComponent message = new StringTextComponent(from + " is charging up!");
                        message.func_230530_a_(message.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-256)));
                        prefix.func_150253_a().add(message);
                        TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                        break;
                    }
                    case CREEPER_WAIT_FINAL: {
                        StringTextComponent prefix = new StringTextComponent("TBM: ");
                        prefix.func_230530_a_(prefix.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-16711936)).func_240713_a_(Boolean.valueOf(true)));
                        StringTextComponent message = new StringTextComponent(from + " is about to explode!");
                        message.func_230530_a_(message.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-44976)));
                        prefix.func_150253_a().add(message);
                        TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                        break;
                    }
                    case CREEPER_EXPLODE: {
                        StringTextComponent prefix = new StringTextComponent("TBM: ");
                        prefix.func_230530_a_(prefix.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-16711936)).func_240713_a_(Boolean.valueOf(true)));
                        StringTextComponent message = new StringTextComponent(from + " exploded!");
                        message.func_230530_a_(message.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-65536)));
                        prefix.func_150253_a().add(message);
                        TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static enum UsedItemAction {
        USED_NOTHING(0),
        USED_INVALID(1),
        USED_FOOD(2),
        USED_POTION(3);

        private int value;
        private static Map<Integer, UsedItemAction> map;

        private UsedItemAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UsedItemAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, UsedItemAction>();
            for (UsedItemAction type : UsedItemAction.values()) {
                map.put(type.getValue(), type);
            }
        }
    }

    public static enum MessageType {
        ENTERED(0),
        FLEE(1),
        DIED(2),
        ENDED(3),
        ATTACK(4),
        DEFEND(5),
        DEFENSE_DAMAGE(6),
        MISS(7),
        DEFENDING(8),
        DID_NOTHING(9),
        USED_ITEM(10),
        TURN_BEGIN(11),
        TURN_END(12),
        SWITCHED_ITEM(13),
        WAS_AFFECTED(14),
        BECAME_CREATIVE(15),
        FIRED_ARROW(16),
        ARROW_HIT(17),
        BOW_NO_AMMO(18),
        CREEPER_WAIT(19),
        CREEPER_WAIT_FINAL(20),
        CREEPER_EXPLODE(21);

        private int value;
        private static Map<Integer, MessageType> map;

        private MessageType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageType valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MessageType>();
            for (MessageType type : MessageType.values()) {
                map.put(type.getValue(), type);
            }
        }
    }
}

