/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class OtherModHandler {
    public void postInit() {
        for (int i = 0; i < 1; ++i) {
            Class<?> customNPCsAPI = null;
            try {
                customNPCsAPI = Class.forName("noppes.npcs.api.NpcAPI");
            }
            catch (ClassNotFoundException e) {
                TurnBasedMinecraftMod.logger.info("NpcAPI not found, not handling it.");
            }
            if (customNPCsAPI == null) break;
            Class<?> customNPCsPlayerHurtEvent = null;
            try {
                customNPCsPlayerHurtEvent = Class.forName("noppes.npcs.api.event.PlayerEvent$DamagedEvent");
            }
            catch (ClassNotFoundException e) {
                TurnBasedMinecraftMod.logger.info("CustomNPCs Player Hurt Event class not found, not handling it.");
            }
            if (customNPCsPlayerHurtEvent == null) break;
            Class<?> customNPCsIDamageSource = null;
            try {
                customNPCsIDamageSource = Class.forName("noppes.npcs.api.IDamageSource");
            }
            catch (ClassNotFoundException e) {
                TurnBasedMinecraftMod.logger.info("CustomNPCs IDamageSource not found, not handling it.");
            }
            if (customNPCsIDamageSource == null) break;
            Class<?> customNPCsIEntity = null;
            try {
                customNPCsIEntity = Class.forName("noppes.npcs.api.entity.IEntity");
            }
            catch (ClassNotFoundException e) {
                TurnBasedMinecraftMod.logger.info("CustomNPCs IEntity not found, not handling it.");
            }
            if (customNPCsIEntity == null) break;
            Object instance = null;
            try {
                Method instanceMethod = customNPCsAPI.getMethod("Instance", new Class[0]);
                instance = instanceMethod.invoke(null, new Object[0]);
                if (!customNPCsAPI.isInstance(instance)) {
                    instance = null;
                    TurnBasedMinecraftMod.logger.error("NpcAPI.Instance() is not NpcAPI!");
                }
            }
            catch (NoSuchMethodException e) {
                TurnBasedMinecraftMod.logger.warn("NpcAPI.Instance() does not exist!");
            }
            catch (InvocationTargetException e) {
                TurnBasedMinecraftMod.logger.error("Failed to call NpcAPI.Instance(), InvocationTargetException!");
            }
            catch (IllegalAccessException e) {
                TurnBasedMinecraftMod.logger.error("Failed to call NpcAPI.Instance(), IllegalAccessException!");
            }
            if (instance == null) break;
            Boolean isAvailable = false;
            try {
                Method isAvailableMethod = customNPCsAPI.getMethod("IsAvailable", new Class[0]);
                isAvailable = (Boolean)isAvailableMethod.invoke(instance, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                TurnBasedMinecraftMod.logger.warn("NpcAPI.IsAvailable() does not exist!");
            }
            catch (InvocationTargetException e) {
                TurnBasedMinecraftMod.logger.warn("Failed to call NpcAPI.IsAvailable(), InvocationTargetException!");
            }
            catch (IllegalAccessException e) {
                TurnBasedMinecraftMod.logger.warn("Failed to call NpcAPI.IsAvailable(), IllegalAccessException!");
            }
            catch (ClassCastException e) {
                TurnBasedMinecraftMod.logger.warn("Result of NpcAPI.IsAvailable() is not a Boolean!");
            }
            if (!isAvailable.booleanValue()) {
                TurnBasedMinecraftMod.logger.warn("NpcAPI is not available!");
                break;
            }
            TurnBasedMinecraftMod.logger.info("NpcAPI found, setting up player-not-getting-hurt workaround...");
            Method getNPCsEventBusMethod = null;
            try {
                getNPCsEventBusMethod = customNPCsAPI.getMethod("events", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                TurnBasedMinecraftMod.logger.warn("NpcAPI.events() could not be found!");
            }
            if (getNPCsEventBusMethod == null) break;
            IEventBus customNPCsEventBus = null;
            try {
                customNPCsEventBus = (IEventBus)getNPCsEventBusMethod.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException e) {
                TurnBasedMinecraftMod.logger.warn("Failed to invoke NpcAPI.events(), InvocationTargetException!");
            }
            catch (IllegalAccessException e) {
                TurnBasedMinecraftMod.logger.warn("Failed to invoke NpcAPI.events(), IllegalAccessException!");
            }
            catch (ClassCastException e) {
                TurnBasedMinecraftMod.logger.warn("Failed to cast NpcAPI.events(), ClassCastException!");
            }
            if (customNPCsEventBus == null) break;
            Class<?> finalCustomNPCsPlayerHurtEvent = customNPCsPlayerHurtEvent;
            Class<?> finalCustomNPCsIDamageSource = customNPCsIDamageSource;
            Class<?> finalCustomNPCsIEntity = customNPCsIEntity;
            customNPCsEventBus.addListener(EventPriority.LOWEST, true, event -> {
                if (finalCustomNPCsPlayerHurtEvent.isInstance(event) && TurnBasedMinecraftMod.proxy.getAttackingEntity() != null) {
                    Method getCanceledMethod;
                    String entityUUID;
                    Method getEntityUUIDMethod;
                    Object iEntityObject;
                    Method trueSourceMethod;
                    Object damageSourceObject;
                    Field damageSourceField;
                    try {
                        damageSourceField = finalCustomNPCsPlayerHurtEvent.getField("damageSource");
                    }
                    catch (NoSuchFieldException e) {
                        TurnBasedMinecraftMod.logger.error("CustomNPCs PlayerHurtEvent does not have \".damageSource\"!");
                        return;
                    }
                    try {
                        damageSourceObject = damageSourceField.get(event);
                    }
                    catch (IllegalAccessException e) {
                        TurnBasedMinecraftMod.logger.error("CustomNPCs PlayerHurtEvent failed to get \".damageSource\"!");
                        return;
                    }
                    if (!finalCustomNPCsIDamageSource.isInstance(damageSourceObject)) {
                        TurnBasedMinecraftMod.logger.error("CustomNPCs PlayerHurtEvent damageSource is not IDamageSource!");
                        return;
                    }
                    try {
                        trueSourceMethod = finalCustomNPCsIDamageSource.getMethod("getTrueSource", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        TurnBasedMinecraftMod.logger.error("CustomNPCs IDamageSource does not have \".getTrueSource()\"!");
                        return;
                    }
                    try {
                        iEntityObject = trueSourceMethod.invoke(damageSourceObject, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs IEntity from IDamageSource, IllegalAccessException!");
                        return;
                    }
                    catch (InvocationTargetException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs IEntity from IDamageSource, InvocationTargetException!");
                        return;
                    }
                    if (!finalCustomNPCsIEntity.isInstance(iEntityObject)) {
                        TurnBasedMinecraftMod.logger.error("IDamageSource.getTrueSource() is not IEntity!");
                        return;
                    }
                    try {
                        getEntityUUIDMethod = finalCustomNPCsIEntity.getMethod("getUUID", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs \".getEntityId()\"!");
                        return;
                    }
                    try {
                        entityUUID = (String)getEntityUUIDMethod.invoke(iEntityObject, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs IEntity ID, InvocationTargetException!");
                        return;
                    }
                    catch (IllegalAccessException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs IEntity ID, IllegalAccessException!");
                        return;
                    }
                    catch (ClassCastException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to get CustomNPCs IEntity ID, ClassCastException!");
                        return;
                    }
                    if (!TurnBasedMinecraftMod.proxy.getAttackingEntity().func_189512_bd().equals(entityUUID)) {
                        return;
                    }
                    try {
                        getCanceledMethod = finalCustomNPCsPlayerHurtEvent.getMethod("setCanceled", Boolean.TYPE);
                    }
                    catch (NoSuchMethodException e) {
                        TurnBasedMinecraftMod.logger.error("CustomNPCs PlayerHurtEvent does not have setCanceled(...)!");
                        return;
                    }
                    try {
                        getCanceledMethod.invoke(event, false);
                    }
                    catch (IllegalAccessException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to un-cancel Player hurt event, IllegalAccessException!");
                    }
                    catch (InvocationTargetException e) {
                        TurnBasedMinecraftMod.logger.error("Failed to un-cancel Player hurt event, InvocationTargetException!");
                    }
                }
            });
            TurnBasedMinecraftMod.logger.info("Enabled NpcAPI handling of Player damaged event");
        }
    }
}

