/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.client.ClientProxy;
import com.burnedkirby.TurnBasedMinecraft.common.AttackEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.DimensionChangedHandler;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.PlayerJoinEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="com_burnedkirby_turnbasedminecraft")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com_burnedkirby_turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "1.17.2.4";
    public static final String CONFIG_FILENAME = "TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILENAME = "TBM_Config_DEFAULT.toml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml";
    public static final String MUSIC_ROOT = "config/TurnBasedMinecraft/Music/";
    public static final String MUSIC_SILLY = "config/TurnBasedMinecraft/Music/silly/";
    public static final String MUSIC_BATTLE = "config/TurnBasedMinecraft/Music/battle/";
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final ResourceLocation HANDLER_ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "main_channel");
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HANDLER_ID).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    protected static Logger logger = LogManager.getLogger();
    public static CommonProxy proxy;

    public static ResourceLocation getNetResourceLocation() {
        return HANDLER_ID;
    }

    public static SimpleChannel getHandler() {
        return HANDLER;
    }

    public TurnBasedMinecraftMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::firstInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitServer);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void firstInit(FMLCommonSetupEvent event) {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        proxy.setLogger(logger);
        proxy.initialize();
        int packetHandlerID = 0;
        HANDLER.registerMessage(packetHandlerID++, PacketBattleInfo.class, PacketBattleInfo::encode, PacketBattleInfo::decode, PacketBattleInfo.Handler::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleRequestInfo.class, PacketBattleRequestInfo::encode, PacketBattleRequestInfo::decode, PacketBattleRequestInfo.Handler::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleDecision.class, PacketBattleDecision::encode, PacketBattleDecision::decode, PacketBattleDecision.Handler::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleMessage.class, PacketBattleMessage::encode, PacketBattleMessage::decode, PacketBattleMessage.Handler::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketGeneralMessage.class, PacketGeneralMessage::encode, PacketGeneralMessage::decode, PacketGeneralMessage.Handler::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketEditingMessage.class, PacketEditingMessage::encode, PacketEditingMessage::decode, PacketEditingMessage.Handler::handle);
        MinecraftForge.EVENT_BUS.register((Object)new AttackEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DimensionChangedHandler());
        logger.debug("Init com_burnedkirby_turnbasedminecraft");
    }

    private void secondInitClient(FMLClientSetupEvent event) {
        proxy.postInit();
    }

    private void secondInitServer(FMLDedicatedServerSetupEvent event) {
        proxy.postInit();
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        logger.debug("About to initialize BattleManager");
        if (proxy.initializeBattleManager()) {
            logger.debug("Initialized BattleManager");
        }
        proxy.getConfig().clearBattleIgnoringPlayers();
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-disable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.func_197034_c(2))).executes(c -> {
            proxy.getConfig().addBattleIgnoringPlayer(((CommandSource)c.getSource()).func_197035_h().func_145782_y());
            ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Disabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-disable-all").requires(c -> c.func_197034_c(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(true);
            for (ServerPlayerEntity player : ((CommandSource)c.getSource()).func_197028_i().func_184103_al().func_181057_v()) {
                proxy.getConfig().addBattleIgnoringPlayer(player.func_145782_y());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-enable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.func_197034_c(2))).executes(c -> {
            proxy.getConfig().removeBattleIgnoringPlayer(((CommandSource)c.getSource()).func_197035_h().func_145782_y());
            ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Enabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-enable-all").requires(c -> c.func_197034_c(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(false);
            proxy.getConfig().clearBattleIgnoringPlayers();
            for (ServerPlayerEntity player : ((CommandSource)c.getSource()).func_197028_i().func_184103_al().func_181057_v()) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-set-enable").requires(c -> c.func_197034_c(2))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(c -> {
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)c, (String)"targets")) {
                proxy.getConfig().addBattleIgnoringPlayer(player.func_145782_y());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for you"));
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Enabled turn-based-combat for " + player.func_145748_c_().getString()), true);
            }
            return 1;
        })));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-set-disable").requires(c -> c.func_197034_c(2))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(c -> {
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)c, (String)"targets")) {
                proxy.getConfig().removeBattleIgnoringPlayer(player.func_145782_y());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for you"));
                ((CommandSource)c.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Disabled turn-based-combat for " + player.func_145748_c_().getString()), true);
            }
            return 1;
        })));
        event.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tbm-edit").requires(c -> c.func_197034_c(2))).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((PlayerEntity)player);
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing TBM Entity for player \"" + player.func_145748_c_().getString() + "\" (\"" + ((CommandSource)c.getSource()).func_197019_b() + "\")");
            }
            return 1;
        })).then(Commands.func_197057_a((String)"finish").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                if (!proxy.getConfig().editEntityEntry(editingInfo.entityInfo)) {
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("An error occurred while attempting to save an entry to the config"));
                    proxy.removeEditingInfo(player.func_145782_y());
                } else {
                    proxy.removeEditingInfo(player.func_145782_y());
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Entity info saved in config and loaded."));
                }
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"cancel").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null) {
                proxy.removeEditingInfo(player.func_145782_y());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Cancelled editing entry."));
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"custom").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                LiteralMessage exceptionMessage = new LiteralMessage("Invalid action for tbm-edit");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((PlayerEntity)player);
                TurnBasedMinecraftMod.proxy.getEditingInfo((int)player.func_145782_y()).isEditingCustomName = true;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing custom TBM Entity for player \"" + player.func_145748_c_().getString() + "\" (\"" + ((CommandSource)c.getSource()).func_197019_b() + "\")");
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"edit").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"ignoreBattle").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_IGNORE_BATTLE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"ignoreBattle", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            boolean ignoreBattle = BoolArgumentType.getBool((CommandContext)c, (String)"ignoreBattle");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.ignoreBattle = ignoreBattle;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attackPower").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_POWER));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"attackPower", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int attackPower = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackPower");
            if (attackPower < 0) {
                attackPower = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackPower = attackPower;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attackProbability").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"attackProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int attackProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackProbability");
            if (attackProbability < 0) {
                attackProbability = 0;
            } else if (attackProbability > 100) {
                attackProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackProbability = attackProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attackVariance").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_VARIANCE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"attackVariance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int attackVariance = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackVariance");
            if (attackVariance < 0) {
                attackVariance = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackVariance = attackVariance;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attackEffect").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"attackEffect", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            EntityInfo.Effect effect = EntityInfo.Effect.fromString(StringArgumentType.getString((CommandContext)c, (String)"attackEffect"));
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffect = effect;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"attackEffectProbability").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"attackEffectProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int attackEffectProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackEffectProbability");
            if (attackEffectProbability < 0) {
                attackEffectProbability = 0;
            } else if (attackEffectProbability > 100) {
                attackEffectProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffectProbability = attackEffectProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"defenseDamage").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"defenseDamage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int defenseDamage = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamage");
            if (defenseDamage < 0) {
                defenseDamage = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamage = defenseDamage;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"defenseDamageProbability").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"defenseDamageProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int defenseDamageProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamageProbability");
            if (defenseDamageProbability < 0) {
                defenseDamageProbability = 0;
            } else if (defenseDamageProbability > 100) {
                defenseDamageProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamageProbability = defenseDamageProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"evasion").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_EVASION));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            if (evasion < 0) {
                evasion = 0;
            } else if (evasion > 100) {
                evasion = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.evasion = evasion;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"speed").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_SPEED));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            if (speed < 0) {
                speed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.speed = speed;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"category").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_CATEGORY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"category", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.category = category;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"decisionAttack").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_ATTACK));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"decisionAttack", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int decisionAttack = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionAttack");
            if (decisionAttack < 0) {
                decisionAttack = 0;
            } else if (decisionAttack > 100) {
                decisionAttack = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionAttack = decisionAttack;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"decisionDefend").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_DEFEND));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"decisionDefend", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int decisionDefend = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionDefend");
            if (decisionDefend < 0) {
                decisionDefend = 0;
            } else if (decisionDefend > 100) {
                decisionDefend = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionDefend = decisionDefend;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"decisionFlee").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_FLEE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.func_197056_a((String)"decisionFlee", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            EditingInfo editingInfo = proxy.getEditingInfo(player.func_145782_y());
            int decisionFlee = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionFlee");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionFlee = decisionFlee;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))));
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        logger.debug("About to cleanup BattleManager");
        if (proxy.cleanupBattleManager()) {
            logger.debug("Cleaned up BattleManager");
        }
    }
}

