/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttackerValid(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() == null) {
            return false;
        }
        if (event.getSource().func_76346_g().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            Iterator<AttackerViaBow> iter = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().iterator();
            while (iter.hasNext()) {
                AttackerViaBow attacker = iter.next();
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    iter.remove();
                    continue;
                }
                if (!event.getSource().func_76346_g().equals((Object)attacker.entity) || !event.getSource().func_76352_a()) continue;
                iter.remove();
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.func_145782_y(), event.getEntity().func_145782_y(), 0);
                }
                isValid = true;
            }
        }
        return isValid;
    }

    @SubscribeEvent
    public void entityAttacked(LivingAttackEvent event) {
        EditingInfo editingInfo;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        CommonProxy proxy = TurnBasedMinecraftMod.proxy;
        Config config = proxy.getConfig();
        BattleManager battleManager = proxy.getBattleManager();
        if (event.getSource().func_76346_g() != null && event.getEntity() != null && (editingInfo = proxy.getEditingInfo(event.getSource().func_76346_g().func_145782_y())) != null && editingInfo.isPendingEntitySelection) {
            editingInfo.isPendingEntitySelection = false;
            event.setCanceled(true);
            if (editingInfo.isEditingCustomName) {
                if (!event.getEntity().func_145818_k_()) {
                    TurnBasedMinecraftMod.logger.error("Cannot edit custom name from entity without custom name");
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)editingInfo.editor), (Object)new PacketGeneralMessage("Cannot edit custom name from entity without custom name"));
                    return;
                }
                editingInfo.entityInfo = config.getCustomEntityInfo(event.getEntity().func_200201_e().getString());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.customName = event.getEntity().func_200201_e().getString();
                }
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)editingInfo.editor), (Object)new PacketGeneralMessage("Editing custom name \"" + event.getEntity().func_200201_e().getString() + "\""));
                TurnBasedMinecraftMod.logger.info("Begin editing custom \"" + event.getEntity().func_200201_e().getString() + "\"");
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)editingInfo.editor), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else {
                editingInfo.entityInfo = config.getMatchingEntityInfo(event.getEntity());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.classType = event.getEntity().getClass();
                } else {
                    editingInfo.entityInfo = editingInfo.entityInfo.clone();
                }
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)editingInfo.editor), (Object)new PacketGeneralMessage("Editing entity \"" + editingInfo.entityInfo.classType.getName() + "\""));
                TurnBasedMinecraftMod.logger.info("Begin editing \"" + editingInfo.entityInfo.classType.getName() + "\"");
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)editingInfo.editor), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            }
            return;
        }
        if (event.getEntity() != null && event.getSource().func_76346_g() != null && (battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || battleManager.isRecentlyLeftBattle(event.getSource().func_76346_g().func_145782_y()))) {
            if (event.getSource().func_76346_g().getEntity() instanceof CreeperEntity && TurnBasedMinecraftMod.proxy.getConfig().getCreeperAlwaysAllowDamage()) {
                event.setCanceled(false);
            } else {
                event.setCanceled(true);
            }
            return;
        }
        if (!this.isAttackerValid(event) && event.getEntity() != null && event.getSource().func_76346_g() != null && event.getEntity() != event.getSource().func_76346_g() && !config.getBattleIgnoringPlayers().contains(event.getSource().func_76346_g().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && event.getEntity().field_70170_p.func_234923_W_().equals(event.getSource().func_76346_g().field_70170_p.func_234923_W_()) && battleManager.checkAttack(event)) {
            event.setCanceled(true);
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
    }

    @SubscribeEvent
    public void entityTargeted(LivingSetAttackTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().field_70170_p.field_72995_K || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || event.getTarget() != null && battleManager.isRecentlyLeftBattle(event.getTarget().func_145782_y()) || event.getEntity() != null && event.getTarget() != null && Utility.distanceBetweenEntities(event.getEntity(), (Entity)event.getTarget()) > (double)config.getAggroStartBattleDistance()) {
            return;
        }
        if (event.getEntity() != null && event.getTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getTarget().func_145782_y()) && event.getEntity().field_70170_p.func_234923_W_().equals(event.getTarget().field_70170_p.func_234923_W_())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

