/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketBattleInfo {
    private Collection<Integer> sideA;
    private Collection<Integer> sideB;
    private long decisionNanos;

    public PacketBattleInfo() {
        this.sideA = new ArrayList<Integer>();
        this.sideB = new ArrayList<Integer>();
        this.decisionNanos = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
    }

    public PacketBattleInfo(Collection<Integer> sideA, Collection<Integer> sideB, long decisionNanos) {
        this.sideA = sideA;
        this.sideB = sideB;
        this.decisionNanos = decisionNanos;
    }

    public static void encode(PacketBattleInfo pkt, PacketBuffer buf) {
        buf.writeInt(pkt.sideA.size());
        buf.writeInt(pkt.sideB.size());
        for (Integer id : pkt.sideA) {
            buf.writeInt(id.intValue());
        }
        for (Integer id : pkt.sideB) {
            buf.writeInt(id.intValue());
        }
        buf.writeLong(pkt.decisionNanos);
    }

    public static PacketBattleInfo decode(PacketBuffer buf) {
        int i;
        int sideACount = buf.readInt();
        int sideBCount = buf.readInt();
        ArrayList<Integer> sideA = new ArrayList<Integer>(sideACount);
        ArrayList<Integer> sideB = new ArrayList<Integer>(sideBCount);
        for (i = 0; i < sideACount; ++i) {
            sideA.add(buf.readInt());
        }
        for (i = 0; i < sideBCount; ++i) {
            sideB.add(buf.readInt());
        }
        long decisionNanos = buf.readLong();
        return new PacketBattleInfo(sideA, sideB, decisionNanos);
    }

    public static class Handler {
        public static void handle(PacketBattleInfo pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity e;
                if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
                    return;
                }
                TurnBasedMinecraftMod.proxy.getLocalBattle().clearCombatants();
                for (Integer id : pkt.sideA) {
                    e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideA(e);
                }
                for (Integer id : pkt.sideB) {
                    e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id.intValue());
                    if (e == null) continue;
                    TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideB(e);
                }
                TurnBasedMinecraftMod.proxy.setBattleGuiTime((int)(pkt.decisionNanos / 1000000000L));
                TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

