/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.tbm_repack.fr.delthas.javamp3;

import com.burnedkirby.tbm_repack.fr.delthas.javamp3.Decoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public final class Sound
extends FilterInputStream {
    private Decoder.SoundData soundData;
    private int index;
    private AudioFormat audioFormat;

    public Sound(InputStream in) throws IOException {
        super(Objects.requireNonNull(in, "The specified InputStream must be non-null!"));
        this.soundData = Decoder.init(in);
        if (this.soundData == null) {
            throw new IOException("No MPEG data in the specified input stream!");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.index == -1) {
            return -1;
        }
        if (this.index == this.soundData.samplesBuffer.length) {
            if (!Decoder.decodeFrame(this.soundData)) {
                this.index = -1;
                this.soundData.samplesBuffer = null;
                return -1;
            }
            this.index = 1;
            return this.soundData.samplesBuffer[0] & 0xFF;
        }
        return this.soundData.samplesBuffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.index == -1) {
            return -1;
        }
        int len_ = len;
        while (len > 0) {
            int remaining;
            if (this.index == this.soundData.samplesBuffer.length) {
                if (!Decoder.decodeFrame(this.soundData)) {
                    this.index = -1;
                    this.soundData.samplesBuffer = null;
                    return len_ == len ? -1 : len_ - len;
                }
                this.index = 0;
            }
            if ((remaining = this.soundData.samplesBuffer.length - this.index) <= 0) continue;
            if (remaining >= len) {
                System.arraycopy(this.soundData.samplesBuffer, this.index, b, off, len);
                this.index += len;
                return len_;
            }
            System.arraycopy(this.soundData.samplesBuffer, this.index, b, off, remaining);
            off += remaining;
            len -= remaining;
            this.index = this.soundData.samplesBuffer.length;
        }
        throw new IllegalStateException("Shouldn't happen (internal error)");
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.soundData.samplesBuffer == null) {
            return 0;
        }
        return this.soundData.samplesBuffer.length - this.index;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
            this.soundData.samplesBuffer = null;
        }
        this.index = -1;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int decodeFullyInto(OutputStream os) throws IOException {
        Objects.requireNonNull(os);
        if (this.index == -1) {
            return 0;
        }
        int remaining = this.soundData.samplesBuffer.length - this.index;
        if (remaining > 0) {
            os.write(this.soundData.samplesBuffer, this.index, remaining);
        }
        int read = remaining;
        while (Decoder.decodeFrame(this.soundData)) {
            os.write(this.soundData.samplesBuffer);
            read += this.soundData.samplesBuffer.length;
        }
        this.soundData.samplesBuffer = null;
        this.index = -1;
        return read;
    }

    public int getSamplingFrequency() {
        return this.soundData.frequency;
    }

    public boolean isStereo() {
        return this.soundData.stereo == 1;
    }

    public AudioFormat getAudioFormat() {
        if (this.audioFormat == null) {
            this.audioFormat = new AudioFormat(this.getSamplingFrequency(), 16, this.isStereo() ? 2 : 1, true, false);
        }
        return this.audioFormat;
    }
}

