/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.BattleGui;
import com.burnedkirby.TurnBasedMinecraft.client.BattleMusic;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import java.util.UUID;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = null;
    private BattleMusic battleMusic = null;
    private int battleMusicCount = 0;
    private int sillyMusicCount = 0;
    private Battle localBattle = null;

    @Override
    protected void initializeClient() {
        this.battleGui = new BattleGui();
        this.battleMusic = null;
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
        this.localBattle = null;
        this.logger.debug("Init client");
    }

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.setTimeRemaining(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        if (Minecraft.func_71410_x().field_71462_r != this.battleGui) {
            this.battleGui.turnEnd();
            Minecraft.func_71410_x().func_147108_a((Screen)this.battleGui);
        }
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleStarted() {
        this.setBattleGuiAsGui();
    }

    @Override
    public void battleEnded() {
        this.localBattle = null;
        Minecraft.func_71410_x().func_147108_a(null);
        this.stopMusic(true);
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
    }

    @Override
    protected void postInitClient() {
        this.battleMusic = new BattleMusic(this.getLogger());
    }

    @Override
    public void playBattleMusic() {
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        this.battleMusic.playBattle(gs.func_186711_a(SoundCategory.MUSIC) * gs.func_186711_a(SoundCategory.MASTER));
    }

    @Override
    public void playSillyMusic() {
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        this.battleMusic.playSilly(gs.func_186711_a(SoundCategory.MUSIC) * gs.func_186711_a(SoundCategory.MASTER));
    }

    @Override
    public void stopMusic(boolean resumeMCSounds) {
        this.battleMusic.stopMusic(resumeMCSounds);
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            ++this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            ++this.sillyMusicCount;
        } else {
            ++this.battleMusicCount;
        }
        this.checkBattleTypes();
    }

    @Override
    public void typeLeftBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            --this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            --this.sillyMusicCount;
        } else {
            --this.battleMusicCount;
        }
        this.checkBattleTypes();
    }

    @Override
    public void displayString(String message) {
        StringTextComponent prefix = new StringTextComponent("TBM: ");
        prefix.func_240703_c_(prefix.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-16711936)).func_240713_a_(Boolean.valueOf(true)));
        StringTextComponent text = new StringTextComponent(message);
        prefix.func_150253_a().add(text);
        text.func_240703_c_(text.func_150256_b().func_240718_a_(Color.func_240743_a_((int)-1)).func_240713_a_(Boolean.valueOf(false)));
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)prefix, UUID.randomUUID());
    }

    @Override
    public void displayTextComponent(ITextComponent text) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a(text, UUID.randomUUID());
    }

    private void checkBattleTypes() {
        float percentage = 0.0f;
        percentage = this.sillyMusicCount == 0 && this.battleMusicCount == 0 ? 0.0f : (this.battleMusicCount == 0 ? 100.0f : 100.0f * (float)this.sillyMusicCount / (float)(this.sillyMusicCount + this.battleMusicCount));
        if (percentage >= (float)this.getConfig().getSillyMusicThreshold()) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly() && this.battleMusic.hasSillyMusic()) {
                    this.stopMusic(false);
                    this.playSillyMusic();
                }
            } else if (this.battleMusic.hasSillyMusic()) {
                this.playSillyMusic();
            }
        } else if (this.battleMusic.isPlaying()) {
            if (this.battleMusic.isPlayingSilly() && this.battleMusic.hasBattleMusic()) {
                this.stopMusic(false);
                this.playBattleMusic();
            }
        } else if (this.battleMusic.hasBattleMusic()) {
            this.playBattleMusic();
        }
    }

    @Override
    public Battle getLocalBattle() {
        return this.localBattle;
    }

    @Override
    public void createLocalBattle(int id) {
        this.localBattle = new Battle(null, id, null, null, false, (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
    }

    @Override
    public Entity getEntity(int id, RegistryKey<World> dim) {
        return Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
    }
}

