/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketBattleRequestInfo {
    private int battleID;

    public PacketBattleRequestInfo() {
    }

    public PacketBattleRequestInfo(int battleID) {
        this.battleID = battleID;
    }

    public static void encode(PacketBattleRequestInfo pkt, PacketBuffer buf) {
        buf.writeInt(pkt.battleID);
    }

    public static PacketBattleRequestInfo decode(PacketBuffer buf) {
        return new PacketBattleRequestInfo(buf.readInt());
    }

    public static class Handler {
        public static void handle(PacketBattleRequestInfo pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(pkt.battleID);
                if (b == null) {
                    return;
                }
                TurnBasedMinecraftMod.getHandler().reply((Object)new PacketBattleInfo(b.getSideAIDs(), b.getSideBIDs(), b.getTimerSeconds()), (NetworkEvent.Context)ctx.get());
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

