/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.BattleGui;
import com.burnedkirby.TurnBasedMinecraft.client.BattleMusic;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = null;
    private BattleMusic battleMusic = null;
    private int battleMusicCount = 0;
    private int sillyMusicCount = 0;
    private Battle localBattle = null;

    @Override
    protected void initializeClient() {
        this.battleGui = new BattleGui();
        this.battleMusic = null;
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
        this.localBattle = null;
        this.logger.debug("Init client");
    }

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.setTimeRemaining(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        if (Minecraft.m_91087_().f_91080_ != this.battleGui) {
            this.battleGui.turnEnd();
            Minecraft.m_91087_().m_91152_((Screen)this.battleGui);
        }
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleStarted() {
        this.setBattleGuiAsGui();
    }

    @Override
    public void battleEnded() {
        this.localBattle = null;
        Minecraft.m_91087_().m_91152_(null);
        this.stopMusic(true);
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
    }

    @Override
    protected void postInitClient() {
        this.battleMusic = new BattleMusic(this.getLogger());
    }

    @Override
    public void playBattleMusic() {
        Options gs = Minecraft.m_91087_().f_91066_;
        this.battleMusic.playBattle(gs.m_92147_(SoundSource.MUSIC) * gs.m_92147_(SoundSource.MASTER));
    }

    @Override
    public void playSillyMusic() {
        Options gs = Minecraft.m_91087_().f_91066_;
        this.battleMusic.playSilly(gs.m_92147_(SoundSource.MUSIC) * gs.m_92147_(SoundSource.MASTER));
    }

    @Override
    public void stopMusic(boolean resumeMCSounds) {
        this.battleMusic.stopMusic(resumeMCSounds);
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            ++this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            ++this.sillyMusicCount;
        } else {
            ++this.battleMusicCount;
        }
        this.checkBattleTypes(false);
    }

    @Override
    public void typeLeftBattle(String type) {
        if (this.localBattle == null || this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty()) {
            this.battleMusicCount = 0;
            this.sillyMusicCount = 0;
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            --this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            --this.sillyMusicCount;
        } else {
            --this.battleMusicCount;
        }
        this.checkBattleTypes(true);
    }

    @Override
    public void displayString(String message) {
        TextComponent prefix = new TextComponent("TBM: ");
        prefix.m_130948_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
        TextComponent text = new TextComponent(message);
        prefix.m_7360_().add(text);
        text.m_130948_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
        Minecraft.m_91087_().f_91074_.m_6352_((Component)prefix, UUID.randomUUID());
    }

    @Override
    public void displayTextComponent(TextComponent text) {
        Minecraft.m_91087_().f_91074_.m_6352_((Component)text, UUID.randomUUID());
    }

    private void checkBattleTypes(boolean entityLeft) {
        if (this.localBattle == null && entityLeft && (this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty())) {
            return;
        }
        float percentage = 0.0f;
        percentage = this.sillyMusicCount == 0 && this.battleMusicCount == 0 ? 0.0f : (this.battleMusicCount == 0 ? 100.0f : 100.0f * (float)this.sillyMusicCount / (float)(this.sillyMusicCount + this.battleMusicCount));
        if (percentage >= (float)this.getConfig().getSillyMusicThreshold()) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly() && this.battleMusic.hasSillyMusic()) {
                    this.stopMusic(false);
                    this.playSillyMusic();
                }
            } else if (this.battleMusic.hasSillyMusic()) {
                this.playSillyMusic();
            }
        } else if (this.battleMusic.isPlaying()) {
            if (this.battleMusic.isPlayingSilly() && this.battleMusic.hasBattleMusic()) {
                this.stopMusic(false);
                this.playBattleMusic();
            }
        } else if (this.battleMusic.hasBattleMusic()) {
            this.playBattleMusic();
        }
    }

    @Override
    public Battle getLocalBattle() {
        return this.localBattle;
    }

    @Override
    public void createLocalBattle(int id) {
        this.localBattle = new Battle(null, id, null, null, false, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
    }

    @Override
    public Entity getEntity(int id, ResourceKey<Level> dim) {
        return Minecraft.m_91087_().f_91073_.m_6815_(id);
    }

    @Override
    public <MSG> void handlePacket(MSG msg, Supplier<NetworkEvent.Context> ctx) {
        if (msg.getClass() == PacketBattleMessage.class) {
            PacketBattleMessage pkt = (PacketBattleMessage)msg;
            Entity fromEntity = this.getEntity(pkt.getEntityIDFrom(), pkt.getDimension());
            String from = "Unknown";
            if (fromEntity != null) {
                from = fromEntity.m_5446_().getString();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (fromEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDFrom())) != null) {
                from = fromEntity.m_5446_().getString();
            }
            Entity toEntity = TurnBasedMinecraftMod.proxy.getEntity(pkt.getEntityIDTo(), pkt.getDimension());
            String to = "Unknown";
            if (toEntity != null) {
                to = toEntity.m_5446_().getString();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (toEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDTo())) != null) {
                to = toEntity.m_5446_().getString();
            }
            block0 : switch (pkt.getMessageType()) {
                case ENTERED: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " entered battle!");
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null || TurnBasedMinecraftMod.proxy.getLocalBattle().getId() != pkt.getAmount()) {
                        TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.getAmount());
                    }
                    TurnBasedMinecraftMod.proxy.battleStarted();
                    TurnBasedMinecraftMod.proxy.typeEnteredBattle(pkt.getCustom());
                    break;
                }
                case FLEE: {
                    if (pkt.getAmount() != 0) {
                        TurnBasedMinecraftMod.proxy.displayString(from + " fled battle!");
                        TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                        break;
                    }
                    TurnBasedMinecraftMod.proxy.displayString(from + " tried to flee battle but failed!");
                    break;
                }
                case DIED: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " died in battle!");
                    TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                    break;
                }
                case ENDED: {
                    TurnBasedMinecraftMod.proxy.displayString("Battle has ended!");
                    TurnBasedMinecraftMod.proxy.battleEnded();
                    break;
                }
                case ATTACK: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " attacked " + to + " and dealt " + pkt.getAmount() + " damage!");
                    break;
                }
                case DEFEND: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " blocked " + to + "'s attack!");
                    break;
                }
                case DEFENSE_DAMAGE: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " retaliated from " + to + "'s attack and dealt " + pkt.getAmount() + " damage!");
                    break;
                }
                case MISS: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " attacked " + to + " but missed!");
                    break;
                }
                case DEFENDING: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " is defending!");
                    break;
                }
                case DID_NOTHING: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " did nothing!");
                    break;
                }
                case USED_ITEM: {
                    switch (PacketBattleMessage.UsedItemAction.valueOf(pkt.getAmount())) {
                        case USED_NOTHING: {
                            TurnBasedMinecraftMod.proxy.displayString(from + " tried to use nothing!");
                            break block0;
                        }
                        case USED_INVALID: {
                            if (pkt.getCustom().length() > 0) {
                                TurnBasedMinecraftMod.proxy.displayString(from + " tried to consume " + pkt.getCustom() + " and failed!");
                                break block0;
                            }
                            TurnBasedMinecraftMod.proxy.displayString(from + " tried to consume an invalid item and failed!");
                            break block0;
                        }
                        case USED_FOOD: {
                            TurnBasedMinecraftMod.proxy.displayString(from + " ate a " + pkt.getCustom() + "!");
                            break block0;
                        }
                        case USED_POTION: {
                            TurnBasedMinecraftMod.proxy.displayString(from + " drank a " + pkt.getCustom() + "!");
                        }
                    }
                    break;
                }
                case TURN_BEGIN: {
                    TurnBasedMinecraftMod.proxy.displayString("The turn begins!");
                    TurnBasedMinecraftMod.proxy.battleGuiTurnBegin();
                    break;
                }
                case TURN_END: {
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                        if (pkt.getAmount() == 0) {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended!");
                        } else {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended (abnormally due to internal error)!");
                        }
                    }
                    TurnBasedMinecraftMod.proxy.battleGuiTurnEnd();
                    break;
                }
                case SWITCHED_ITEM: {
                    if (pkt.getAmount() != 0) {
                        TurnBasedMinecraftMod.proxy.displayString(from + " switched to a different item!");
                        break;
                    }
                    TurnBasedMinecraftMod.proxy.displayString(from + " switched to a different item but failed because it was invalid!");
                    break;
                }
                case WAS_AFFECTED: {
                    TurnBasedMinecraftMod.proxy.displayString(to + " was " + pkt.getCustom() + " by " + from + "!");
                    break;
                }
                case BECAME_CREATIVE: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " entered creative mode and left battle!");
                    break;
                }
                case FIRED_ARROW: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " let loose an arrow towards " + to + "!");
                    break;
                }
                case ARROW_HIT: {
                    TurnBasedMinecraftMod.proxy.displayString(to + " was hit by " + from + "'s arrow!");
                    break;
                }
                case BOW_NO_AMMO: {
                    TurnBasedMinecraftMod.proxy.displayString(from + " tried to use their bow but ran out of ammo!");
                    break;
                }
                case CREEPER_WAIT: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent message = new TextComponent(from + " is charging up!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-256)));
                    prefix.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case CREEPER_WAIT_FINAL: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent message = new TextComponent(from + " is about to explode!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-44976)));
                    prefix.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case CREEPER_EXPLODE: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent message = new TextComponent(from + " exploded!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                    prefix.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                }
            }
        } else if (msg.getClass() == PacketGeneralMessage.class) {
            PacketGeneralMessage pkt = (PacketGeneralMessage)msg;
            this.displayString(pkt.getMessage());
        } else if (msg.getClass() == PacketEditingMessage.class) {
            PacketEditingMessage pkt = (PacketEditingMessage)msg;
            switch (pkt.getType()) {
                case ATTACK_ENTITY: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("Attack the entity you want to edit for TurnBasedMinecraftMod. ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent cancel = new TextComponent("Cancel");
                    cancel.m_6270_(cancel.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    text.m_7360_().add(cancel);
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case PICK_EDIT: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("Edit what value? ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("IgB");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("IgnoreBattle"))));
                    TextComponent value = new TextComponent("(" + pkt.getEntityInfo().ignoreBattle + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AP");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackPower"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackPower + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("APr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AV");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackVariance"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackVariance + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AE");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackEffect"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackEffect.toString() + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AEPr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackEffectProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackEffectProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DD");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DefenseDamage"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().defenseDamage + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DDPr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DefenseDamageProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().defenseDamageProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("E");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Evasion"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().evasion + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("S");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Speed"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().speed + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("C");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Category"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().category + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecA");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionAttack"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionAttack + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecD");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionDefend"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionDefend + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecF");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionFlee"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionFlee + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("Finished Editing");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit finish")));
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" "));
                    option = new TextComponent("Cancel");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    text.m_7360_().add(option);
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_IGNORE_BATTLE: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("ignoreBattle: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("true");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle true")));
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" "));
                    option = new TextComponent("false");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle false")));
                    text.m_7360_().add(option);
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_ATTACK_POWER: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("attackPower: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 15) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackPower <integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_ATTACK_PROBABILITY: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("attackProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 10; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackProbability <percentage-integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_ATTACK_VARIANCE: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("attackVariance: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 10; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 10) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackVariance <integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_ATTACK_EFFECT: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("attackEffect: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (EntityInfo.Effect e : EntityInfo.Effect.values()) {
                        TextComponent option = new TextComponent(e.toString());
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect " + e.toString())));
                        text.m_7360_().add(option);
                        if (e == EntityInfo.Effect.UNKNOWN) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_ATTACK_EFFECT_PROBABILITY: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("attackEffectProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackEffectProbability <percentage-integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("defenseDamage: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 15) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit defenseDamage <integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE_PROBABILITY: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("defenseDamageProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit defenseDamageProbability <percentage-integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_EVASION: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("evasion: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit evasion <percentage-integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_SPEED: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("speed: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit speed <integer>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_CATEGORY: {
                    TextComponent optionInfoBool;
                    TextComponent optionInfo;
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("category: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("monster");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category monster")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("monster")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("animal");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category animal")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("animal")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("passive");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category passive")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("passive")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("boss");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category boss")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("boss")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("player");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category player")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("player")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit category <string>\")"));
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_DECISION_ATTACK: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("decisionAttack: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_DECISION_DEFEND: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("decisionDefend: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
                case EDIT_DECISION_FLEE: {
                    TextComponent prefix = new TextComponent("TBM: ");
                    prefix.m_6270_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
                    TextComponent text = new TextComponent("decisionFlee: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    prefix.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent(prefix);
                    break;
                }
            }
        }
    }
}

