/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.client.ClientProxy;
import com.burnedkirby.TurnBasedMinecraft.common.AttackEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.DimensionChangedHandler;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.PlayerJoinEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="com_burnedkirby_turnbasedminecraft")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com_burnedkirby_turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "1.18.1";
    public static final String CONFIG_FILENAME = "TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILENAME = "TBM_Config_DEFAULT.toml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml";
    public static final String MUSIC_ROOT = "config/TurnBasedMinecraft/Music/";
    public static final String MUSIC_SILLY = "config/TurnBasedMinecraft/Music/silly/";
    public static final String MUSIC_BATTLE = "config/TurnBasedMinecraft/Music/battle/";
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final ResourceLocation HANDLER_ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "main_channel");
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HANDLER_ID).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    protected static Logger logger = LogManager.getLogger();
    public static CommonProxy proxy;

    public static ResourceLocation getNetResourceLocation() {
        return HANDLER_ID;
    }

    public static SimpleChannel getHandler() {
        return HANDLER;
    }

    public TurnBasedMinecraftMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::firstInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitServer);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void firstInit(FMLCommonSetupEvent event) {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        proxy.setLogger(logger);
        proxy.initialize();
        int packetHandlerID = 0;
        HANDLER.registerMessage(packetHandlerID++, PacketBattleInfo.class, PacketBattleInfo::encode, PacketBattleInfo::decode, PacketBattleInfo::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleRequestInfo.class, PacketBattleRequestInfo::encode, PacketBattleRequestInfo::decode, PacketBattleRequestInfo::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleDecision.class, PacketBattleDecision::encode, PacketBattleDecision::decode, PacketBattleDecision::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleMessage.class, PacketBattleMessage::encode, PacketBattleMessage::decode, PacketBattleMessage::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketGeneralMessage.class, PacketGeneralMessage::encode, PacketGeneralMessage::decode, PacketGeneralMessage::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketEditingMessage.class, PacketEditingMessage::encode, PacketEditingMessage::decode, PacketEditingMessage::handle);
        MinecraftForge.EVENT_BUS.register((Object)new AttackEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DimensionChangedHandler());
        logger.debug("Init com_burnedkirby_turnbasedminecraft");
    }

    private void secondInitClient(FMLClientSetupEvent event) {
        proxy.postInit();
    }

    private void secondInitServer(FMLDedicatedServerSetupEvent event) {
        proxy.postInit();
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        logger.debug("About to initialize BattleManager");
        if (proxy.initializeBattleManager()) {
            logger.debug("Initialized BattleManager");
        }
        proxy.getConfig().clearBattleIgnoringPlayers();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-disable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.m_6761_(2))).executes(c -> {
            proxy.getConfig().addBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).m_81375_().m_142049_());
            ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Disabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-disable-all").requires(c -> c.m_6761_(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(true);
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_()) {
                proxy.getConfig().addBattleIgnoringPlayer(player.m_142049_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-enable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.m_6761_(2))).executes(c -> {
            proxy.getConfig().removeBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).m_81375_().m_142049_());
            ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Enabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-enable-all").requires(c -> c.m_6761_(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(false);
            proxy.getConfig().clearBattleIgnoringPlayers();
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_()) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-set-enable").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)c, (String)"targets")) {
                proxy.getConfig().addBattleIgnoringPlayer(player.m_142049_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for you"));
                ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Enabled turn-based-combat for " + player.m_5446_().getString()), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-set-disable").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)c, (String)"targets")) {
                proxy.getConfig().removeBattleIgnoringPlayer(player.m_142049_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for you"));
                ((CommandSourceStack)c.getSource()).m_81354_((Component)new TextComponent("Disabled turn-based-combat for " + player.m_5446_().getString()), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-edit").requires(c -> c.m_6761_(2))).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((Player)player);
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing TBM Entity for player \"" + player.m_5446_().getString() + "\" (\"" + ((CommandSourceStack)c.getSource()).m_81357_() + "\")");
            }
            return 1;
        })).then(Commands.m_82127_((String)"finish").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                if (!proxy.getConfig().editEntityEntry(editingInfo.entityInfo)) {
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("An error occurred while attempting to save an entry to the config"));
                    proxy.removeEditingInfo(player.m_142049_());
                } else {
                    proxy.removeEditingInfo(player.m_142049_());
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Entity info saved in config and loaded."));
                }
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"cancel").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null) {
                proxy.removeEditingInfo(player.m_142049_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Cancelled editing entry."));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"custom").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                LiteralMessage exceptionMessage = new LiteralMessage("Invalid action for tbm-edit");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((Player)player);
                TurnBasedMinecraftMod.proxy.getEditingInfo((int)player.m_142049_()).isEditingCustomName = true;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing custom TBM Entity for player \"" + player.m_5446_().getString() + "\" (\"" + ((CommandSourceStack)c.getSource()).m_81357_() + "\")");
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ignoreBattle").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_IGNORE_BATTLE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"ignoreBattle", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            boolean ignoreBattle = BoolArgumentType.getBool((CommandContext)c, (String)"ignoreBattle");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.ignoreBattle = ignoreBattle;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackPower").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_POWER));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackPower", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int attackPower = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackPower");
            if (attackPower < 0) {
                attackPower = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackPower = attackPower;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int attackProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackProbability");
            if (attackProbability < 0) {
                attackProbability = 0;
            } else if (attackProbability > 100) {
                attackProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackProbability = attackProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackVariance").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_VARIANCE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackVariance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int attackVariance = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackVariance");
            if (attackVariance < 0) {
                attackVariance = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackVariance = attackVariance;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackEffect").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackEffect", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            EntityInfo.Effect effect = EntityInfo.Effect.fromString(StringArgumentType.getString((CommandContext)c, (String)"attackEffect"));
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffect = effect;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackEffectProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackEffectProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int attackEffectProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackEffectProbability");
            if (attackEffectProbability < 0) {
                attackEffectProbability = 0;
            } else if (attackEffectProbability > 100) {
                attackEffectProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffectProbability = attackEffectProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defenseDamage").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"defenseDamage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int defenseDamage = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamage");
            if (defenseDamage < 0) {
                defenseDamage = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamage = defenseDamage;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defenseDamageProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"defenseDamageProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int defenseDamageProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamageProbability");
            if (defenseDamageProbability < 0) {
                defenseDamageProbability = 0;
            } else if (defenseDamageProbability > 100) {
                defenseDamageProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamageProbability = defenseDamageProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"evasion").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_EVASION));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            if (evasion < 0) {
                evasion = 0;
            } else if (evasion > 100) {
                evasion = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.evasion = evasion;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"speed").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_SPEED));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            if (speed < 0) {
                speed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.speed = speed;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"category").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_CATEGORY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"category", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.category = category;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionAttack").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_ATTACK));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionAttack", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int decisionAttack = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionAttack");
            if (decisionAttack < 0) {
                decisionAttack = 0;
            } else if (decisionAttack > 100) {
                decisionAttack = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionAttack = decisionAttack;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionDefend").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_DEFEND));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionDefend", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int decisionDefend = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionDefend");
            if (decisionDefend < 0) {
                decisionDefend = 0;
            } else if (decisionDefend > 100) {
                decisionDefend = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionDefend = decisionDefend;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionFlee").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_FLEE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionFlee", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_142049_());
            int decisionFlee = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionFlee");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionFlee = decisionFlee;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))));
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent event) {
        logger.debug("About to cleanup BattleManager");
        if (proxy.cleanupBattleManager()) {
            logger.debug("Cleaned up BattleManager");
        }
    }
}

