/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketEditingMessage {
    Type type = Type.ATTACK_ENTITY;
    EntityInfo entityInfo = new EntityInfo();

    public Type getType() {
        return this.type;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public PacketEditingMessage() {
    }

    public PacketEditingMessage(Type type) {
        this.type = type;
    }

    public PacketEditingMessage(Type type, EntityInfo entityInfo) {
        this.type = type;
        if (entityInfo != null) {
            this.entityInfo = entityInfo;
        }
    }

    public static void encode(PacketEditingMessage pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.type.getValue());
        if (pkt.entityInfo.classType != null) {
            buf.m_130070_(pkt.entityInfo.classType.getName());
        } else {
            buf.m_130070_("unknown");
        }
        buf.writeBoolean(pkt.entityInfo.ignoreBattle);
        buf.writeInt(pkt.entityInfo.attackPower);
        buf.writeInt(pkt.entityInfo.attackProbability);
        buf.writeInt(pkt.entityInfo.attackVariance);
        buf.m_130070_(pkt.entityInfo.attackEffect.toString());
        buf.writeInt(pkt.entityInfo.attackEffectProbability);
        buf.writeInt(pkt.entityInfo.defenseDamage);
        buf.writeInt(pkt.entityInfo.defenseDamageProbability);
        buf.writeInt(pkt.entityInfo.evasion);
        buf.writeInt(pkt.entityInfo.speed);
        buf.m_130070_(pkt.entityInfo.category);
        buf.writeInt(pkt.entityInfo.decisionAttack);
        buf.writeInt(pkt.entityInfo.decisionDefend);
        buf.writeInt(pkt.entityInfo.decisionFlee);
        buf.m_130070_(pkt.entityInfo.customName);
    }

    public static PacketEditingMessage decode(FriendlyByteBuf buf) {
        Type type = Type.valueOf(buf.readInt());
        EntityInfo einfo = new EntityInfo();
        try {
            einfo.classType = einfo.getClass().getClassLoader().loadClass(buf.m_130277_());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        einfo.ignoreBattle = buf.readBoolean();
        einfo.attackPower = buf.readInt();
        einfo.attackProbability = buf.readInt();
        einfo.attackVariance = buf.readInt();
        einfo.attackEffect = EntityInfo.Effect.fromString(buf.m_130277_());
        einfo.attackEffectProbability = buf.readInt();
        einfo.defenseDamage = buf.readInt();
        einfo.defenseDamageProbability = buf.readInt();
        einfo.evasion = buf.readInt();
        einfo.speed = buf.readInt();
        einfo.category = buf.m_130277_();
        einfo.decisionAttack = buf.readInt();
        einfo.decisionDefend = buf.readInt();
        einfo.decisionFlee = buf.readInt();
        einfo.customName = buf.m_130277_();
        return new PacketEditingMessage(type, einfo);
    }

    public static void handle(PacketEditingMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PacketEditingMessage.lambda$handle$1(pkt, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(PacketEditingMessage pkt, Supplier ctx) {
        return () -> PacketEditingMessage.lambda$handle$0(pkt, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(PacketEditingMessage pkt, Supplier ctx) {
        TurnBasedMinecraftMod.proxy.handlePacket(pkt, ctx);
    }

    public static enum Type {
        ATTACK_ENTITY(0),
        PICK_EDIT(1),
        EDIT_IGNORE_BATTLE(2),
        EDIT_ATTACK_POWER(3),
        EDIT_ATTACK_PROBABILITY(4),
        EDIT_ATTACK_VARIANCE(5),
        EDIT_ATTACK_EFFECT(6),
        EDIT_ATTACK_EFFECT_PROBABILITY(7),
        EDIT_DEFENSE_DAMAGE(8),
        EDIT_DEFENSE_DAMAGE_PROBABILITY(9),
        EDIT_EVASION(10),
        EDIT_SPEED(11),
        EDIT_CATEGORY(12),
        EDIT_DECISION_ATTACK(13),
        EDIT_DECISION_DEFEND(14),
        EDIT_DECISION_FLEE(15);

        private static Map<Integer, Type> map;
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, Type>();
            for (Type t : Type.values()) {
                map.put(t.value, t);
            }
        }
    }
}

