/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.EntitySelectionButton;
import com.burnedkirby.TurnBasedMinecraft.client.ItemSelectionButton;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class BattleGui
extends Screen {
    private AtomicInteger timeRemaining = new AtomicInteger(15);
    private long lastInstant = System.nanoTime();
    private long elapsedTime = 0L;
    private MenuState state = MenuState.MAIN_MENU;
    private boolean stateChanged = true;
    private String info;

    public BattleGui() {
        super((Component)new TextComponent("Battle Gui"));
    }

    private void setState(MenuState state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void turnBegin() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.ACTION);
        }
        this.setState(MenuState.WAITING);
    }

    public void turnEnd() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.DECISION);
        }
        this.timeRemaining.set(TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationSeconds());
        this.elapsedTime = 0L;
        this.lastInstant = System.nanoTime();
        this.setState(MenuState.MAIN_MENU);
    }

    public void battleChanged() {
        this.stateChanged = true;
    }

    public void updateState() {
        if (!this.stateChanged) {
            return;
        }
        this.stateChanged = false;
        this.m_169413_();
        switch (this.state) {
            case MAIN_MENU: {
                this.info = "What will you do?";
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 3 / 7 - 25, 40, 50, 20, (Component)new TextComponent("Attack"), button -> this.buttonActionEvent(button, ButtonAction.ATTACK)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 4 / 7 - 25, 40, 50, 20, (Component)new TextComponent("Defend"), button -> this.buttonActionEvent(button, ButtonAction.DEFEND)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 3 / 7 - 25, 60, 50, 20, (Component)new TextComponent("Item"), button -> this.buttonActionEvent(button, ButtonAction.ITEM)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 4 / 7 - 25, 60, 50, 20, (Component)new TextComponent("Flee"), button -> this.buttonActionEvent(button, ButtonAction.FLEE)));
                break;
            }
            case ATTACK_TARGET: {
                this.info = "Who will you attack?";
                int y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.m_142416_((GuiEventListener)new EntitySelectionButton(this.f_96543_ / 4 - 60, y, 120, 20, e.getValue().entity.m_5446_(), (int)e.getKey(), true, button -> this.buttonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.m_142416_((GuiEventListener)new EntitySelectionButton(this.f_96543_ / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), true, button -> this.buttonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.m_142416_((GuiEventListener)new EntitySelectionButton(this.f_96543_ * 3 / 4 - 60, y, 120, 20, e.getValue().entity.m_5446_(), (int)e.getKey(), false, button -> this.buttonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.m_142416_((GuiEventListener)new EntitySelectionButton(this.f_96543_ * 3 / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), false, button -> this.buttonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 30, this.f_96544_ - 120, 60, 20, (Component)new TextComponent("Cancel"), button -> this.buttonActionEvent(button, ButtonAction.CANCEL)));
                break;
            }
            case ITEM_ACTION: {
                this.info = "What will you do with an item?";
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 1 / 4 - 40, this.f_96544_ - 120, 80, 20, (Component)new TextComponent("Switch Held"), button -> this.buttonActionEvent(button, ButtonAction.SWITCH_HELD_ITEM)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 2 / 4 - 40, this.f_96544_ - 120, 80, 20, (Component)new TextComponent("Use"), button -> this.buttonActionEvent(button, ButtonAction.DECIDE_USE_ITEM)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ * 3 / 4 - 40, this.f_96544_ - 120, 80, 20, (Component)new TextComponent("Cancel"), button -> this.buttonActionEvent(button, ButtonAction.CANCEL)));
                break;
            }
            case WAITING: {
                this.info = "Waiting...";
                break;
            }
            case SWITCH_ITEM: {
                this.info = "To which item will you switch to?";
                for (int i = 0; i < 9; ++i) {
                    this.m_142416_((GuiEventListener)new ItemSelectionButton(this.f_96543_ / 2 - 88 + i * 20, this.f_96544_ - 19, 16, 16, "", i, button -> this.buttonActionEvent(button, ButtonAction.DO_ITEM_SWITCH)));
                }
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40, this.f_96544_ - 120, 80, 20, (Component)new TextComponent("Cancel"), button -> this.buttonActionEvent(button, ButtonAction.CANCEL)));
                break;
            }
            case USE_ITEM: {
                this.info = "Which item will you use?";
                for (int i = 0; i < 9; ++i) {
                    this.m_142416_((GuiEventListener)new ItemSelectionButton(this.f_96543_ / 2 - 88 + i * 20, this.f_96544_ - 19, 16, 16, "", i, button -> this.buttonActionEvent(button, ButtonAction.DO_USE_ITEM)));
                }
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40, this.f_96544_ - 120, 80, 20, (Component)new TextComponent("Cancel"), button -> this.buttonActionEvent(button, ButtonAction.CANCEL)));
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
            this.drawString(poseStack, "Waiting...", this.f_96543_ / 2 - 50, this.f_96544_ / 2, -1);
            return;
        }
        if (TurnBasedMinecraftMod.proxy.getLocalBattle().getState() == Battle.State.DECISION && this.timeRemaining.get() > 0) {
            long nextInstant = System.nanoTime();
            this.elapsedTime += nextInstant - this.lastInstant;
            this.lastInstant = nextInstant;
            while (this.elapsedTime > 1000000000L) {
                this.elapsedTime -= 1000000000L;
                this.timeRemaining.decrementAndGet();
            }
        }
        this.updateState();
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        Object timeRemainingString = "Time remaining: ";
        int timeRemainingInt = this.timeRemaining.get();
        timeRemainingString = timeRemainingInt > 8 ? (String)timeRemainingString + "\u00a7a" : (timeRemainingInt > 4 ? (String)timeRemainingString + "\u00a7e" : (String)timeRemainingString + "\u00a7c");
        timeRemainingString = (String)timeRemainingString + Integer.toString(timeRemainingInt);
        int stringWidth = this.f_96547_.m_92895_((String)timeRemainingString);
        BattleGui.m_93172_((PoseStack)poseStack, (int)(this.f_96543_ / 2 - stringWidth / 2), (int)5, (int)(this.f_96543_ / 2 + stringWidth / 2), (int)15, (int)0x70000000);
        this.drawString(poseStack, (String)timeRemainingString, this.f_96543_ / 2 - stringWidth / 2, 5, -1);
        stringWidth = this.f_96547_.m_92895_(this.info);
        BattleGui.m_93172_((PoseStack)poseStack, (int)(this.f_96543_ / 2 - stringWidth / 2), (int)20, (int)(this.f_96543_ / 2 + stringWidth / 2), (int)30, (int)0x70000000);
        this.drawString(poseStack, this.info, this.f_96543_ / 2 - stringWidth / 2, 20, -1);
    }

    protected void buttonActionEvent(Button button, ButtonAction action) {
        switch (action) {
            case ATTACK: {
                this.setState(MenuState.ATTACK_TARGET);
                break;
            }
            case DEFEND: {
                TurnBasedMinecraftMod.getHandler().sendToServer((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.DEFEND, 0));
                this.setState(MenuState.WAITING);
                break;
            }
            case ITEM: {
                this.setState(MenuState.ITEM_ACTION);
                break;
            }
            case FLEE: {
                TurnBasedMinecraftMod.getHandler().sendToServer((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.FLEE, 0));
                this.setState(MenuState.WAITING);
                break;
            }
            case ATTACK_TARGET: {
                if (button instanceof EntitySelectionButton) {
                    TurnBasedMinecraftMod.getHandler().sendToServer((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.ATTACK, ((EntitySelectionButton)button).getID()));
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case SWITCH_HELD_ITEM: {
                this.setState(MenuState.SWITCH_ITEM);
                break;
            }
            case DECIDE_USE_ITEM: {
                this.setState(MenuState.USE_ITEM);
                break;
            }
            case CANCEL: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_ITEM_SWITCH: {
                if (button instanceof ItemSelectionButton) {
                    TurnBasedMinecraftMod.getHandler().sendToServer((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.SWITCH_ITEM, ((ItemSelectionButton)button).getID()));
                    if (((ItemSelectionButton)button).getID() >= 0 && ((ItemSelectionButton)button).getID() < 9) {
                        Minecraft.m_91087_().f_91074_.m_150109_().f_35977_ = ((ItemSelectionButton)button).getID();
                    }
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_USE_ITEM: {
                if (button instanceof ItemSelectionButton) {
                    TurnBasedMinecraftMod.getHandler().sendToServer((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.USE_ITEM, ((ItemSelectionButton)button).getID()));
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int a, int b, int c) {
        if (this.getMinecraft().f_91074_.m_7500_()) {
            return super.m_7933_(a, b, c);
        }
        return false;
    }

    public boolean m_7920_(int a, int b, int c) {
        if (this.getMinecraft().f_91074_.m_7500_()) {
            return super.m_7920_(a, b, c);
        }
        return false;
    }

    public void setTimeRemaining(int remaining) {
        this.timeRemaining.set(remaining);
    }

    private void drawString(PoseStack poseStack, String string, int x, int y, int color) {
        this.f_96547_.m_92883_(poseStack, string, (float)x, (float)y, color);
    }

    private static enum MenuState {
        MAIN_MENU(0),
        ATTACK_TARGET(1),
        ITEM_ACTION(2),
        WAITING(3),
        SWITCH_ITEM(4),
        USE_ITEM(5);

        private int value;
        private static Map<Integer, MenuState> map;

        private MenuState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MenuState valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MenuState>();
            for (MenuState state : MenuState.values()) {
                map.put(state.getValue(), state);
            }
        }
    }

    private static enum ButtonAction {
        ATTACK(0),
        DEFEND(1),
        ITEM(2),
        FLEE(3),
        ATTACK_TARGET(4),
        SWITCH_HELD_ITEM(5),
        DECIDE_USE_ITEM(6),
        CANCEL(7),
        DO_ITEM_SWITCH(8),
        DO_USE_ITEM(9);

        private int value;
        private static Map<Integer, ButtonAction> map;

        private ButtonAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ButtonAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ButtonAction>();
            for (ButtonAction action : ButtonAction.values()) {
                map.put(action.getValue(), action);
            }
        }
    }
}

