/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.tbm_repack.fr.delthas.javamp3.Sound;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class BattleMusic {
    private Logger logger;
    private ArrayList<File> battleMusic;
    private ArrayList<File> sillyMusic;
    private boolean initialized = false;
    private File nextBattle;
    private File nextSilly;
    private Sequencer sequencer;
    private AudioInputStream wavInputStream;
    private Clip clip;
    private boolean playingIsSilly;
    private boolean isPlaying;
    private Thread mp3StreamThread;
    private MP3Streamer mp3StreamRunnable;

    public BattleMusic(Logger logger) {
        File[] sillyFiles;
        File[] battleFiles;
        this.logger = logger;
        this.battleMusic = new ArrayList();
        this.sillyMusic = new ArrayList();
        this.isPlaying = false;
        this.mp3StreamThread = null;
        this.mp3StreamRunnable = null;
        this.sequencer = null;
        File battleMusicFolder = new File("config/TurnBasedMinecraft/Music/battle/");
        File sillyMusicFolder = new File("config/TurnBasedMinecraft/Music/silly/");
        if (!battleMusicFolder.exists() && !battleMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/battle/");
            return;
        }
        if (!sillyMusicFolder.exists() && !sillyMusicFolder.mkdirs()) {
            logger.error("Failed to create config/TurnBasedMinecraft/Music/silly/");
            return;
        }
        for (File f : battleFiles = battleMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("wav") || ext.equals("mp3");
            }
        })) {
            this.battleMusic.add(f);
        }
        logger.info("Got " + this.battleMusic.size() + " battle music files");
        for (File f : sillyFiles = sillyMusicFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int extIndex = name.lastIndexOf(".");
                if (extIndex == -1) {
                    return false;
                }
                String ext = name.substring(extIndex + 1).toLowerCase();
                return ext.equals("wav") || ext.equals("mp3");
            }
        })) {
            this.sillyMusic.add(f);
        }
        logger.info("Got " + this.sillyMusic.size() + " silly music files");
        this.initialized = true;
        this.pickNextBattle();
        this.pickNextSilly();
    }

    private void pickNextBattle() {
        this.nextBattle = !this.initialized || this.battleMusic.isEmpty() ? null : this.battleMusic.get((int)(Math.random() * (double)this.battleMusic.size()));
    }

    private void pickNextSilly() {
        this.nextSilly = !this.initialized || this.sillyMusic.isEmpty() ? null : this.sillyMusic.get((int)(Math.random() * (double)this.sillyMusic.size()));
    }

    public void playBattle(float volume) {
        if (!this.initialized || volume <= 0.0f || this.battleMusic.isEmpty()) {
            return;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.play(this.nextBattle, volume, true);
        this.pickNextBattle();
        this.playingIsSilly = false;
        this.isPlaying = true;
    }

    public void playSilly(float volume) {
        if (!this.initialized || volume <= 0.0f || this.sillyMusic.isEmpty()) {
            return;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.play(this.nextSilly, volume, false);
        this.pickNextSilly();
        this.playingIsSilly = true;
        this.isPlaying = true;
    }

    private void play(File next, float volume, boolean isBattleType) {
        if (this.initialized && next != null) {
            this.logger.debug("play called with file " + next.getName() + " and vol " + volume);
            Minecraft.m_91087_().m_91106_().m_120391_();
            String suffix = next.getName().substring(next.getName().length() - 3).toLowerCase();
            if (suffix.equals("mid") && this.sequencer != null) {
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip != null && this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                if (this.mp3StreamThread != null && this.mp3StreamThread.isAlive()) {
                    this.mp3StreamRunnable.setKeepPlaying(false);
                    try {
                        this.mp3StreamThread.join();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    this.sequencer.setSequence(new BufferedInputStream(new FileInputStream(next)));
                }
                catch (Throwable t) {
                    this.logger.error("Failed to play battle music (midi)");
                    t.printStackTrace();
                    return;
                }
                try {
                    for (MidiChannel channel : MidiSystem.getSynthesizer().getChannels()) {
                        channel.controlChange(7, (int)(volume * 127.0f));
                    }
                }
                catch (MidiUnavailableException e) {
                    this.logger.error("Failed to set Midi volume");
                    e.printStackTrace();
                    return;
                }
                this.sequencer.setLoopCount(-1);
                this.sequencer.start();
                this.logger.info("Played music (midi) " + next.getName());
            } else if (suffix.equals("wav")) {
                if (this.sequencer != null && this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip != null && this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                if (this.mp3StreamThread != null && this.mp3StreamThread.isAlive()) {
                    this.mp3StreamRunnable.setKeepPlaying(false);
                    try {
                        this.mp3StreamThread.join();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                try {
                    if (this.wavInputStream != null) {
                        this.wavInputStream.close();
                    }
                    this.wavInputStream = AudioSystem.getAudioInputStream(next);
                    AudioFormat format = this.wavInputStream.getFormat();
                    DataLine.Info info = new DataLine.Info(Clip.class, format);
                    this.clip = (Clip)AudioSystem.getLine(info);
                    this.clip.open(this.wavInputStream);
                }
                catch (Throwable t) {
                    this.logger.error("Failed to play battle music (wav)");
                    t.printStackTrace();
                    return;
                }
                FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                gainControl.setValue(volume * 20.0f - 20.0f);
                this.clip.loop(-1);
                this.clip.start();
                this.logger.info("Playing music (wav) " + next.getName());
            } else if (suffix.equals("mp3")) {
                if (this.sequencer != null && this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.clip != null && this.clip.isActive()) {
                    this.clip.stop();
                    this.clip.close();
                }
                if (this.mp3StreamThread != null && this.mp3StreamThread.isAlive()) {
                    this.mp3StreamRunnable.setKeepPlaying(false);
                    try {
                        this.mp3StreamThread.join();
                    }
                    catch (Throwable gainControl) {
                        // empty catch block
                    }
                }
                try {
                    if (this.mp3StreamRunnable == null) {
                        this.mp3StreamRunnable = new MP3Streamer(next, this.logger, volume);
                    } else {
                        this.mp3StreamRunnable.setMp3File(next);
                        this.mp3StreamRunnable.setVolume(volume);
                    }
                    this.mp3StreamThread = new Thread(this.mp3StreamRunnable);
                    this.mp3StreamThread.start();
                    this.logger.info("Started playing mp3 " + next.getName());
                }
                catch (Throwable t) {
                    this.logger.error("Failed to play battle music (mp3)");
                    t.printStackTrace();
                    return;
                }
            }
        }
    }

    public void stopMusic(boolean resumeMCSounds) {
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
        if (this.clip != null) {
            this.clip.stop();
            this.clip.close();
        }
        if (this.mp3StreamThread != null && this.mp3StreamThread.isAlive()) {
            this.mp3StreamRunnable.setKeepPlaying(false);
            try {
                this.mp3StreamThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (resumeMCSounds) {
            Minecraft.m_91087_().m_91106_().m_120407_();
        }
        this.isPlaying = false;
    }

    public boolean isPlayingSilly() {
        return this.playingIsSilly;
    }

    public boolean isPlaying() {
        return this.isPlaying || this.sequencer != null && this.sequencer.isRunning() || this.clip != null && this.clip.isActive();
    }

    public boolean hasBattleMusic() {
        return !this.battleMusic.isEmpty();
    }

    public boolean hasSillyMusic() {
        return !this.sillyMusic.isEmpty();
    }

    private class MP3Streamer
    implements Runnable {
        private AtomicBoolean keepPlaying = new AtomicBoolean(true);
        private File mp3File;
        private Logger logger;
        private float volume;

        public MP3Streamer(File mp3File, Logger logger, float volume) {
            this.mp3File = mp3File;
            this.logger = logger;
            this.volume = volume;
            if (this.volume > 1.0f) {
                this.volume = 1.0f;
            } else if (this.volume < 0.0f) {
                this.volume = 0.0f;
            }
        }

        public void setKeepPlaying(boolean playing) {
            this.keepPlaying.set(playing);
        }

        public void setMp3File(File mp3File) {
            this.mp3File = mp3File;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        @Override
        public void run() {
            this.keepPlaying.set(true);
            DataLine sdl = null;
            try {
                Sound mp3Sound = new Sound(new FileInputStream(this.mp3File));
                AudioFormat audioFormat = mp3Sound.getAudioFormat();
                sdl = AudioSystem.getSourceDataLine(audioFormat);
                sdl.open(audioFormat);
                FloatControl volumeControl = (FloatControl)sdl.getControl(FloatControl.Type.MASTER_GAIN);
                volumeControl.setValue(this.volume * 20.0f - 20.0f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] cached = null;
                int cachedOffset = 0;
                int cachedSize = 0;
                byte[] buf = new byte[4096];
                sdl.start();
                int read = mp3Sound.read(buf, 0, 4096);
                while (this.keepPlaying.get()) {
                    if (baos != null) {
                        if (read != -1) {
                            sdl.write(buf, 0, read);
                            baos.write(buf, 0, read);
                            read = mp3Sound.read(buf, 0, 4096);
                            continue;
                        }
                        mp3Sound.close();
                        mp3Sound = null;
                        cached = baos.toByteArray();
                        baos = null;
                        continue;
                    }
                    cachedSize = cached.length - cachedOffset;
                    if (cachedSize > 4096) {
                        cachedSize = 4096;
                    }
                    sdl.write(cached, cachedOffset, cachedSize);
                    if ((cachedOffset += cachedSize) < cached.length) continue;
                    cachedOffset = 0;
                }
            }
            catch (Throwable t) {
                this.logger.error("Stream play mp3", t);
            }
            if (sdl != null) {
                sdl.stop();
                sdl.flush();
                sdl.close();
            }
        }
    }
}

