/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.BattleGui;
import com.burnedkirby.TurnBasedMinecraft.client.BattleMusic;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientProxy
extends CommonProxy {
    private BattleGui battleGui = null;
    private BattleMusic battleMusic = null;
    private int battleMusicCount = 0;
    private int sillyMusicCount = 0;
    private Battle localBattle = null;

    @Override
    protected void initializeClient() {
        this.battleGui = new BattleGui();
        this.battleMusic = null;
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
        this.localBattle = null;
        this.logger.debug("Init client");
    }

    @Override
    public void setBattleGuiTime(int timeRemaining) {
        this.battleGui.setTimeRemaining(timeRemaining);
    }

    @Override
    public void setBattleGuiBattleChanged() {
        this.battleGui.battleChanged();
    }

    @Override
    public void setBattleGuiAsGui() {
        if (Minecraft.m_91087_().f_91080_ != this.battleGui) {
            this.battleGui.turnEnd();
            Minecraft.m_91087_().m_91152_((Screen)this.battleGui);
        }
    }

    @Override
    public void battleGuiTurnBegin() {
        this.battleGui.turnBegin();
    }

    @Override
    public void battleGuiTurnEnd() {
        this.battleGui.turnEnd();
    }

    @Override
    public void battleStarted() {
        this.setBattleGuiAsGui();
    }

    @Override
    public void battleEnded() {
        this.localBattle = null;
        Minecraft.m_91087_().m_91152_(null);
        this.stopMusic(true);
        this.battleMusicCount = 0;
        this.sillyMusicCount = 0;
    }

    @Override
    protected void postInitClient() {
        this.battleMusic = new BattleMusic(this.getLogger());
    }

    @Override
    public void playBattleMusic() {
        Options gs = Minecraft.m_91087_().f_91066_;
        this.battleMusic.playBattle(gs.m_92147_(SoundSource.MUSIC) * gs.m_92147_(SoundSource.MASTER));
    }

    @Override
    public void playSillyMusic() {
        Options gs = Minecraft.m_91087_().f_91066_;
        this.battleMusic.playSilly(gs.m_92147_(SoundSource.MUSIC) * gs.m_92147_(SoundSource.MASTER));
    }

    @Override
    public void stopMusic(boolean resumeMCSounds) {
        this.battleMusic.stopMusic(resumeMCSounds);
    }

    @Override
    public void typeEnteredBattle(String type) {
        if (this.localBattle == null) {
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            ++this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            ++this.sillyMusicCount;
        } else {
            ++this.battleMusicCount;
        }
        this.checkBattleTypes(false);
    }

    @Override
    public void typeLeftBattle(String type) {
        if (this.localBattle == null || this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty()) {
            this.battleMusicCount = 0;
            this.sillyMusicCount = 0;
            return;
        }
        if (type == null || type.isEmpty() || this.getConfig().isBattleMusicType(type)) {
            --this.battleMusicCount;
        } else if (this.getConfig().isSillyMusicType(type)) {
            --this.sillyMusicCount;
        } else {
            --this.battleMusicCount;
        }
        this.checkBattleTypes(true);
    }

    @Override
    public void displayString(String message) {
        TextComponent parentComponent = new TextComponent("");
        TextComponent prefix = new TextComponent("TBM: ");
        prefix.m_130948_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
        TextComponent text = new TextComponent(message);
        text.m_130948_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
        parentComponent.m_7360_().add(prefix);
        parentComponent.m_7360_().add(text);
        Minecraft.m_91087_().f_91074_.m_6352_((Component)parentComponent, new UUID(0L, 0L));
    }

    @Override
    public void displayComponent(Component text) {
        TextComponent parentComponent = new TextComponent("");
        TextComponent prefix = new TextComponent("TBM: ");
        prefix.m_130948_(prefix.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131136_(Boolean.valueOf(true)));
        parentComponent.m_7360_().add(prefix);
        parentComponent.m_7360_().add(text);
        Minecraft.m_91087_().f_91074_.m_6352_((Component)parentComponent, new UUID(0L, 0L));
    }

    private void checkBattleTypes(boolean entityLeft) {
        if (this.localBattle == null && entityLeft && (this.localBattle.getSideA().isEmpty() || this.localBattle.getSideB().isEmpty())) {
            return;
        }
        float percentage = 0.0f;
        percentage = this.sillyMusicCount == 0 && this.battleMusicCount == 0 ? 0.0f : (this.battleMusicCount == 0 ? 100.0f : 100.0f * (float)this.sillyMusicCount / (float)(this.sillyMusicCount + this.battleMusicCount));
        if (percentage >= (float)this.getConfig().getSillyMusicThreshold()) {
            if (this.battleMusic.isPlaying()) {
                if (!this.battleMusic.isPlayingSilly() && this.battleMusic.hasSillyMusic()) {
                    this.stopMusic(false);
                    this.playSillyMusic();
                }
            } else if (this.battleMusic.hasSillyMusic()) {
                this.playSillyMusic();
            }
        } else if (this.battleMusic.isPlaying()) {
            if (this.battleMusic.isPlayingSilly() && this.battleMusic.hasBattleMusic()) {
                this.stopMusic(false);
                this.playBattleMusic();
            }
        } else if (this.battleMusic.hasBattleMusic()) {
            this.playBattleMusic();
        }
    }

    @Override
    public Battle getLocalBattle() {
        return this.localBattle;
    }

    @Override
    public void createLocalBattle(int id) {
        this.localBattle = new Battle(null, id, null, null, false, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
    }

    @Override
    public Entity getEntity(int id, ResourceKey<Level> dim) {
        return Minecraft.m_91087_().f_91073_.m_6815_(id);
    }

    @Override
    public <MSG> void handlePacket(MSG msg, Supplier<NetworkEvent.Context> ctx) {
        if (msg.getClass() == PacketBattleMessage.class) {
            PacketBattleMessage pkt = (PacketBattleMessage)msg;
            Entity fromEntity = this.getEntity(pkt.getEntityIDFrom(), pkt.getDimension());
            TextComponent from = new TextComponent("Unknown");
            if (fromEntity != null) {
                from = fromEntity.m_5446_();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (fromEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDFrom())) != null) {
                from = fromEntity.m_5446_();
            }
            Entity toEntity = TurnBasedMinecraftMod.proxy.getEntity(pkt.getEntityIDTo(), pkt.getDimension());
            TextComponent to = new TextComponent("Unknown");
            if (toEntity != null) {
                to = toEntity.m_5446_();
            } else if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null && (toEntity = TurnBasedMinecraftMod.proxy.getLocalBattle().getCombatantEntity(pkt.getEntityIDTo())) != null) {
                to = toEntity.m_5446_();
            }
            TextComponent parentComponent = new TextComponent("");
            block0 : switch (pkt.getMessageType()) {
                case ENTERED: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" entered battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null || TurnBasedMinecraftMod.proxy.getLocalBattle().getId() != pkt.getAmount()) {
                        TurnBasedMinecraftMod.proxy.createLocalBattle(pkt.getAmount());
                    }
                    TurnBasedMinecraftMod.proxy.battleStarted();
                    TurnBasedMinecraftMod.proxy.typeEnteredBattle(pkt.getCustom());
                    break;
                }
                case FLEE: {
                    if (pkt.getAmount() != 0) {
                        parentComponent.m_7360_().add(from);
                        parentComponent.m_7360_().add(new TextComponent(" fled battle!"));
                        TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                        break;
                    }
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" tried to flee battle but failed!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DIED: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" died in battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    TurnBasedMinecraftMod.proxy.typeLeftBattle(pkt.getCustom());
                    break;
                }
                case ENDED: {
                    TurnBasedMinecraftMod.proxy.displayString("Battle has ended!");
                    TurnBasedMinecraftMod.proxy.battleEnded();
                    break;
                }
                case ATTACK: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" attacked "));
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent(" and dealt "));
                    parentComponent.m_7360_().add(new TextComponent(Integer.valueOf(pkt.getAmount()).toString()));
                    parentComponent.m_7360_().add(new TextComponent(" damage!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFEND: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" blocked "));
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent("'s attack!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFENSE_DAMAGE: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" retaliated from "));
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent("'s attack and dealt "));
                    parentComponent.m_7360_().add(new TextComponent(Integer.valueOf(pkt.getAmount()).toString()));
                    parentComponent.m_7360_().add(new TextComponent(" damage!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case MISS: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" attacked "));
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent(" but missed!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DEFENDING: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" is defending!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case DID_NOTHING: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" did nothing!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case USED_ITEM: {
                    parentComponent.m_7360_().add(from);
                    switch (PacketBattleMessage.UsedItemAction.valueOf(pkt.getAmount())) {
                        case USED_NOTHING: {
                            parentComponent.m_7360_().add(new TextComponent(" tried to use nothing!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_INVALID: {
                            if (pkt.getCustom().length() > 0) {
                                parentComponent.m_7360_().add(new TextComponent(" tried to consume "));
                                parentComponent.m_7360_().add(new TextComponent(pkt.getCustom()));
                                parentComponent.m_7360_().add(new TextComponent(" and failed!"));
                                TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                                break block0;
                            }
                            parentComponent.m_7360_().add(new TextComponent(" tried to consume an invalid item and failed!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_FOOD: {
                            parentComponent.m_7360_().add(new TextComponent(" ate a "));
                            parentComponent.m_7360_().add(new TextComponent(pkt.getCustom()));
                            parentComponent.m_7360_().add(new TextComponent("!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                            break block0;
                        }
                        case USED_POTION: {
                            parentComponent.m_7360_().add(new TextComponent(" drank a "));
                            parentComponent.m_7360_().add(new TextComponent(pkt.getCustom()));
                            parentComponent.m_7360_().add(new TextComponent("!"));
                            TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        }
                    }
                    break;
                }
                case TURN_BEGIN: {
                    TurnBasedMinecraftMod.proxy.displayString("The turn begins!");
                    TurnBasedMinecraftMod.proxy.battleGuiTurnBegin();
                    break;
                }
                case TURN_END: {
                    if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
                        if (pkt.getAmount() == 0) {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended!");
                        } else {
                            TurnBasedMinecraftMod.proxy.displayString("The turn ended (abnormally due to internal error)!");
                        }
                    }
                    TurnBasedMinecraftMod.proxy.battleGuiTurnEnd();
                    break;
                }
                case SWITCHED_ITEM: {
                    if (pkt.getAmount() != 0) {
                        parentComponent.m_7360_().add(from);
                        parentComponent.m_7360_().add(new TextComponent(" switched to a different item!"));
                        TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                        break;
                    }
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" switched to a different item but failed because it was invalid!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case WAS_AFFECTED: {
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent(" was " + pkt.getCustom() + " by "));
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent("!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case BECAME_CREATIVE: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" entered creative mode and left battle!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case FIRED_ARROW: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" let loose an arrow towards "));
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent("!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case ARROW_HIT: {
                    parentComponent.m_7360_().add(to);
                    parentComponent.m_7360_().add(new TextComponent(" was hit by "));
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent("'s arrow!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case BOW_NO_AMMO: {
                    parentComponent.m_7360_().add(from);
                    parentComponent.m_7360_().add(new TextComponent(" tried to use their bow but ran out of ammo!"));
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_WAIT: {
                    parentComponent.m_7360_().add(from);
                    TextComponent message = new TextComponent(" is charging up!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-256)));
                    parentComponent.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_WAIT_FINAL: {
                    parentComponent.m_7360_().add(from);
                    TextComponent message = new TextComponent(" is about to explode!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-44976)));
                    parentComponent.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case CREEPER_EXPLODE: {
                    parentComponent.m_7360_().add(from);
                    TextComponent message = new TextComponent(" exploded!");
                    message.m_6270_(message.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                    parentComponent.m_7360_().add(message);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                }
            }
        } else if (msg.getClass() == PacketGeneralMessage.class) {
            PacketGeneralMessage pkt = (PacketGeneralMessage)msg;
            this.displayString(pkt.getMessage());
        } else if (msg.getClass() == PacketEditingMessage.class) {
            PacketEditingMessage pkt = (PacketEditingMessage)msg;
            TextComponent parentComponent = new TextComponent("");
            switch (pkt.getType()) {
                case ATTACK_ENTITY: {
                    TextComponent text = new TextComponent("Attack the entity you want to edit for TurnBasedMinecraftMod. ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent cancel = new TextComponent("Cancel");
                    cancel.m_6270_(cancel.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    parentComponent.m_7360_().add(text);
                    parentComponent.m_7360_().add(cancel);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case PICK_EDIT: {
                    TextComponent text = new TextComponent("Edit what value? ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("IgB");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("IgnoreBattle"))));
                    TextComponent value = new TextComponent("(" + pkt.getEntityInfo().ignoreBattle + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AP");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackPower"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackPower + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("APr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AV");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackVariance"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackVariance + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AE");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackEffect"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackEffect.toString() + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("AEPr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("AttackEffectProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().attackEffectProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DD");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DefenseDamage"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().defenseDamage + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DDPr");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DefenseDamageProbability"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().defenseDamageProbability + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("E");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Evasion"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().evasion + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("S");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Speed"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().speed + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("C");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Category"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().category + ") ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecA");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionAttack"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionAttack + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecD");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionDefend"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionDefend + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("DecF");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("DecisionFlee"))));
                    value = new TextComponent("(" + pkt.getEntityInfo().decisionFlee + "%) ");
                    value.m_6270_(value.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                    option.m_7360_().add(value);
                    text.m_7360_().add(option);
                    option = new TextComponent("Finished Editing");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit finish")));
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" "));
                    option = new TextComponent("Cancel");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel")));
                    text.m_7360_().add(option);
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case SERVER_EDIT: {
                    int i;
                    TextComponent parent = new TextComponent("Edit what server value? ");
                    parent.m_6270_(parent.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent sub = new TextComponent("leave_battle_cooldown ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    for (i = 1; i <= 10; ++i) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit leave_battle_cooldown " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("aggro_start_battle_max_distance ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("5 ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance 5")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("8 ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance 8")));
                    parent.m_7220_((Component)sub);
                    for (i = 10; i <= 50; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit aggro_start_battle_max_distance " + String.valueOf(i))));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("old_battle_behavior ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("If enabled, battles only start on a hit, not including mobs targeting players"))).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("true ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit old_battle_behavior true")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("false ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit old_battle_behavior false")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("anyone_can_disable_tbm_for_self ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Allows use for /tbm-disable and /tbm-enable for all"))).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("true ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit anyone_can_disable_tbm_for_self true")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("false ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit anyone_can_disable_tbm_for_self false")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("max_in_battle ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("2 ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit max_in_battle 2")));
                    parent.m_7220_((Component)sub);
                    for (i = 5; i < 30; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit max_in_battle " + String.valueOf(i))));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("freeze_battle_combatants ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("true ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit freeze_battle_combatants true")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("false ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit freeze_battle_combatants false")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("ignore_battle_types ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.DARK_GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_battle_types")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Click to show current ignored categories, or use /tbm-server-edit ignore_battle_types add/remove <category_name>"))).m_131136_(Boolean.valueOf(true)));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("player_speed ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Player default speed"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_speed " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("player_haste_speed ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Player speed when under the effects of \"Speed\""))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_haste_speed " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("player_slow_speed ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Player speed when under the effects of \"Slow\""))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_slow_speed " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("player_attack_probability ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Base Player attack probability in percentage"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = new TextComponent("1 ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_attack_probability 1")));
                        } else {
                            sub = new TextComponent(String.valueOf(i) + " ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_attack_probability " + i)));
                        }
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("player_evasion ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Base Player evasion rate in percentage"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit player_evasion " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("defense_duration ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Number of attacks that a \"Defend\" move blocks (lasts until next action)"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 5; ++i) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit defense_duration " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("flee_good_probability ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Probability of flee success when Player's speed is higher than the fastest opposing Entity"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = new TextComponent("1 ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_good_probability 1")));
                        } else {
                            sub = new TextComponent(String.valueOf(i) + " ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_good_probability " + i)));
                        }
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("flee_bad_probability ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Probability of flee success when Player's speed is lower than the fastest opposing Entity"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = new TextComponent("1 ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_bad_probability 1")));
                        } else {
                            sub = new TextComponent(String.valueOf(i) + " ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit flee_bad_probability " + i)));
                        }
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("minimum_hit_percentage ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("The minimum percentage possible when calculating hit percentage for any attacker"))));
                    parent.m_7220_((Component)sub);
                    for (i = 0; i <= 100; i += 5) {
                        if (i == 0) {
                            sub = new TextComponent("1 ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit minimum_hit_percentage 1")));
                        } else {
                            sub = new TextComponent(String.valueOf(i) + " ");
                            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit minimum_hit_percentage " + i)));
                        }
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("battle_turn_time_seconds ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("The time in seconds to wait for all Players to choose their move"))));
                    parent.m_7220_((Component)sub);
                    for (i = 5; i <= 60; i += 5) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit battle_turn_time_seconds " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("creeper_explode_turn ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("The number of turns it takes for a creeper to explode"))));
                    parent.m_7220_((Component)sub);
                    for (i = 1; i <= 10; ++i) {
                        sub = new TextComponent(String.valueOf(i) + " ");
                        sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_explode_turn " + i)));
                        parent.m_7220_((Component)sub);
                    }
                    sub = new TextComponent("creeper_stop_explode_on_leave_battle ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Stops creepers from exploding when they leave battle (during leave battle cooldown)"))));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("true ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_stop_explode_on_leave_battle true")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("false ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_stop_explode_on_leave_battle false")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("creeper_always_allow_damage ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Allows creepers to damage anyone who just left battle (in cooldown)"))));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("true ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_always_allow_damage true")));
                    parent.m_7220_((Component)sub);
                    sub = new TextComponent("false ");
                    sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit creeper_always_allow_damage false")));
                    parent.m_7220_((Component)sub);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parent);
                    break;
                }
                case EDIT_IGNORE_BATTLE: {
                    TextComponent text = new TextComponent("ignoreBattle: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("true");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle true")));
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" "));
                    option = new TextComponent("false");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle false")));
                    text.m_7360_().add(option);
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_POWER: {
                    TextComponent text = new TextComponent("attackPower: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 15) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackPower <integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_PROBABILITY: {
                    TextComponent text = new TextComponent("attackProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 10; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackProbability <percentage-integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_VARIANCE: {
                    TextComponent text = new TextComponent("attackVariance: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 10; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 10) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackVariance <integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_EFFECT: {
                    TextComponent text = new TextComponent("attackEffect: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (EntityInfo.Effect e : EntityInfo.Effect.values()) {
                        TextComponent option = new TextComponent(e.toString());
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect " + e.toString())));
                        text.m_7360_().add(option);
                        if (e == EntityInfo.Effect.UNKNOWN) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_ATTACK_EFFECT_PROBABILITY: {
                    TextComponent text = new TextComponent("attackEffectProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit attackEffectProbability <percentage-integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE: {
                    TextComponent text = new TextComponent("defenseDamage: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 15) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit defenseDamage <integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE_PROBABILITY: {
                    TextComponent text = new TextComponent("defenseDamageProbability: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit defenseDamageProbability <percentage-integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_EVASION: {
                    TextComponent text = new TextComponent("evasion: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit evasion <percentage-integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_SPEED: {
                    TextComponent text = new TextComponent("speed: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i));
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit speed <integer>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_CATEGORY: {
                    TextComponent optionInfoBool;
                    TextComponent optionInfo;
                    TextComponent text = new TextComponent("category: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    TextComponent option = new TextComponent("monster");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category monster")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("monster")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("animal");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category animal")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("animal")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("passive");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category passive")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("passive")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("boss");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category boss")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("boss")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(", "));
                    option = new TextComponent("player");
                    option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category player")));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("player")) {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("disabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-65536)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    } else {
                        optionInfo = new TextComponent("(battle-");
                        optionInfo.m_6270_(optionInfo.m_7383_().m_131148_(TextColor.m_131266_((int)-1)));
                        optionInfoBool = new TextComponent("enabled");
                        optionInfoBool.m_6270_(optionInfoBool.m_7383_().m_131148_(TextColor.m_131266_((int)-16711936)));
                        optionInfo.m_7360_().add(optionInfoBool);
                        optionInfo.m_7360_().add(new TextComponent(")"));
                        option.m_7360_().add(optionInfo);
                    }
                    text.m_7360_().add(option);
                    text.m_7360_().add(new TextComponent(" (or use command \"/tbm-edit edit category <string>\")"));
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_ATTACK: {
                    TextComponent text = new TextComponent("decisionAttack: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_DEFEND: {
                    TextComponent text = new TextComponent("decisionDefend: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
                case EDIT_DECISION_FLEE: {
                    TextComponent text = new TextComponent("decisionFlee: ");
                    text.m_6270_(text.m_7383_().m_131148_(TextColor.m_131266_((int)-1)).m_131136_(Boolean.valueOf(false)));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponent option = new TextComponent(Integer.toString(i) + "%");
                        option.m_6270_(option.m_7383_().m_131148_(TextColor.m_131266_((int)-256)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee " + Integer.toString(i))));
                        text.m_7360_().add(option);
                        if (i >= 100) continue;
                        text.m_7360_().add(new TextComponent(", "));
                    }
                    parentComponent.m_7360_().add(text);
                    TurnBasedMinecraftMod.proxy.displayComponent((Component)parentComponent);
                    break;
                }
            }
        }
    }
}

