/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.EntityIDDimPair;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class Battle {
    private final int id;
    private Map<Integer, Combatant> sideA;
    private Map<Integer, Combatant> sideB;
    private Map<Integer, Combatant> players;
    private PriorityQueue<Combatant> turnOrderQueue;
    private Queue<Combatant> sideAEntryQueue;
    private Queue<Combatant> sideBEntryQueue;
    private State state;
    private AtomicInteger playerCount;
    private AtomicInteger undecidedCount;
    private long lastInstant;
    private long timer;
    private boolean timerForever;
    private boolean isServer;
    private boolean battleEnded;
    private BattleManager battleManager;
    private Random random;
    public String debugLog;
    private ResourceKey<Level> dimension;

    public Battle(BattleManager battleManager, int id, Collection<Entity> sideA, Collection<Entity> sideB, boolean isServer, ResourceKey<Level> dimension) {
        Combatant newCombatant;
        EntityInfo entityInfo;
        this.battleManager = battleManager;
        this.isServer = isServer;
        this.id = id;
        this.sideA = new ConcurrentHashMap<Integer, Combatant>();
        this.sideB = new ConcurrentHashMap<Integer, Combatant>();
        this.players = new ConcurrentHashMap<Integer, Combatant>();
        this.turnOrderQueue = new PriorityQueue<Combatant>(new Combatant.CombatantComparator());
        this.sideAEntryQueue = new ArrayDeque<Combatant>();
        this.sideBEntryQueue = new ArrayDeque<Combatant>();
        this.playerCount = new AtomicInteger(0);
        this.undecidedCount = new AtomicInteger(0);
        this.random = new Random();
        this.dimension = dimension;
        if (sideA != null) {
            for (Entity e : sideA) {
                try {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.m_7770_().getString());
                }
                catch (NullPointerException exception) {
                    entityInfo = null;
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                }
                if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = true;
                newCombatant.battleID = this.getId();
                this.sideA.put(e.m_142049_(), newCombatant);
                if (e instanceof Player) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.m_142049_(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.m_20185_();
                newCombatant.z = e.m_20189_();
                newCombatant.yaw = e.m_146909_();
                newCombatant.pitch = e.m_146908_();
            }
        }
        if (sideB != null) {
            for (Entity e : sideB) {
                try {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.m_7770_().getString());
                }
                catch (NullPointerException exception) {
                    entityInfo = null;
                }
                if (entityInfo == null) {
                    entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                }
                if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = false;
                newCombatant.battleID = this.getId();
                this.sideB.put(e.m_142049_(), newCombatant);
                if (e instanceof Player) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.m_142049_(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.m_20185_();
                newCombatant.z = e.m_20189_();
                newCombatant.yaw = e.m_146909_();
                newCombatant.pitch = e.m_146908_();
            }
        }
        if (isServer) {
            for (Combatant c : this.sideA.values()) {
                if (c.entityInfo != null) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id, c.entityInfo.category);
                    continue;
                }
                if (c.entity instanceof Player) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id, "player");
                    continue;
                }
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id);
            }
            for (Combatant c : this.sideB.values()) {
                if (c.entityInfo != null) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id, c.entityInfo.category);
                    continue;
                }
                if (c.entity instanceof Player) {
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id, "player");
                    continue;
                }
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.m_142049_(), 0, id);
            }
        }
        this.lastInstant = System.nanoTime();
        this.state = State.DECISION;
        this.undecidedCount.set(this.playerCount.get());
        this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
        this.timerForever = TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever();
        this.battleEnded = false;
        this.notifyPlayersBattleInfo();
    }

    public int getId() {
        return this.id;
    }

    public Entity getCombatantEntity(int entityID) {
        Combatant c = this.sideA.get(entityID);
        if (c != null) {
            return c.entity;
        }
        c = this.sideB.get(entityID);
        if (c != null) {
            return c.entity;
        }
        return null;
    }

    public boolean hasCombatant(int entityID) {
        for (Combatant c : this.sideAEntryQueue) {
            if (c.entity.m_142049_() != entityID) continue;
            return true;
        }
        for (Combatant c : this.sideBEntryQueue) {
            if (c.entity.m_142049_() != entityID) continue;
            return true;
        }
        return this.sideA.containsKey(entityID) || this.sideB.containsKey(entityID);
    }

    public boolean hasCombatantInSideA(int entityID) {
        for (Combatant c : this.sideAEntryQueue) {
            if (c.entity.m_142049_() != entityID) continue;
            return true;
        }
        return this.sideA.containsKey(entityID);
    }

    public void addCombatantToSideA(Entity e) {
        EntityInfo entityInfo;
        try {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.m_7770_().getString());
        }
        catch (NullPointerException exception) {
            entityInfo = null;
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        }
        if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = true;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            this.sideAEntryQueue.add(newCombatant);
        } else {
            this.sideA.put(e.m_142049_(), newCombatant);
        }
        if (e instanceof Player) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.m_142049_(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.m_20185_();
            newCombatant.z = e.m_20189_();
            newCombatant.yaw = e.m_146909_();
            newCombatant.pitch = e.m_146908_();
        }
        if (this.isServer) {
            if (newCombatant.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id, newCombatant.entityInfo.category);
            } else if (newCombatant.entity instanceof Player) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id, "player");
            } else {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id);
            }
        }
        this.notifyPlayersBattleInfo();
    }

    public void addCombatantToSideB(Entity e) {
        EntityInfo entityInfo;
        try {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(e.m_7770_().getString());
        }
        catch (NullPointerException exception) {
            entityInfo = null;
        }
        if (entityInfo == null) {
            entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        }
        if (entityInfo == null && !(e instanceof Player) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = false;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            this.sideBEntryQueue.add(newCombatant);
        } else {
            this.sideB.put(e.m_142049_(), newCombatant);
        }
        if (e instanceof Player) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.m_142049_(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.m_20185_();
            newCombatant.z = e.m_20189_();
            newCombatant.yaw = e.m_146909_();
            newCombatant.pitch = e.m_146908_();
        }
        if (this.isServer) {
            if (newCombatant.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id, newCombatant.entityInfo.category);
            } else if (newCombatant.entity instanceof Player) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id, "player");
            } else {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.m_142049_(), 0, this.id);
            }
        }
        this.notifyPlayersBattleInfo();
    }

    public void clearCombatants() {
        this.sideA.clear();
        this.sideB.clear();
        this.sideAEntryQueue.clear();
        this.sideBEntryQueue.clear();
        this.players.clear();
        this.playerCount.set(0);
        this.undecidedCount.set(0);
    }

    public Collection<Combatant> getSideA() {
        return this.sideA.values();
    }

    public Collection<Combatant> getSideB() {
        return this.sideB.values();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideAEntrySet() {
        return this.sideA.entrySet();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideBEntrySet() {
        return this.sideB.entrySet();
    }

    public Collection<Integer> getSideAIDs() {
        ArrayList<Integer> sideAIDs = new ArrayList<Integer>(this.sideA.size());
        for (Combatant combatant : this.sideA.values()) {
            sideAIDs.add(combatant.entity.m_142049_());
        }
        return sideAIDs;
    }

    public Collection<Integer> getSideBIDs() {
        ArrayList<Integer> sideBIDs = new ArrayList<Integer>(this.sideB.size());
        for (Combatant combatant : this.sideB.values()) {
            sideBIDs.add(combatant.entity.m_142049_());
        }
        return sideBIDs;
    }

    public Combatant getCombatantByID(int entityID) {
        Combatant combatant = this.sideA.get(entityID);
        if (combatant == null) {
            combatant = this.sideB.get(entityID);
        }
        return combatant;
    }

    public void setDecision(int entityID, Decision decision, int targetIDOrItemID) {
        if (this.state != State.DECISION) {
            return;
        }
        Combatant combatant = this.players.get(entityID);
        if (combatant == null || combatant.decision != Decision.UNDECIDED) {
            return;
        }
        combatant.decision = decision;
        if (decision == Decision.ATTACK) {
            combatant.targetEntityID = targetIDOrItemID;
        } else if (decision == Decision.USE_ITEM || decision == Decision.SWITCH_ITEM) {
            combatant.itemToUse = targetIDOrItemID;
        }
        this.undecidedCount.decrementAndGet();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getTimerSeconds() {
        return this.timer / 1000000000L;
    }

    public long getTimerNanos() {
        return this.timer;
    }

    public int getSize() {
        int size = this.sideA.size() + this.sideB.size();
        size += this.sideAEntryQueue.size();
        return size += this.sideBEntryQueue.size();
    }

    protected void notifyPlayersBattleInfo() {
        if (!this.isServer) {
            return;
        }
        PacketBattleInfo infoPacket = new PacketBattleInfo(this.getSideAIDs(), this.getSideBIDs(), this.timer, TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos(), !TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever());
        for (Combatant p : this.players.values()) {
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p.entity), (Object)infoPacket);
        }
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount) {
        this.sendMessageToAllPlayers(type, from, to, amount, new String());
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount, String custom) {
        if (!this.isServer) {
            return;
        }
        PacketBattleMessage packet = new PacketBattleMessage(type, from, to, this.dimension, amount, custom);
        for (Combatant p : this.players.values()) {
            if (!p.entity.m_6084_()) continue;
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p.entity), (Object)packet);
        }
    }

    private boolean healthCheck() {
        String category;
        Map.Entry<Integer, Combatant> entry;
        boolean didRemove = false;
        Iterator<Map.Entry<Integer, Combatant>> iter = this.sideA.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue().entity.m_6084_()) continue;
            iter.remove();
            this.players.remove(entry.getKey());
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
            category = null;
            if (entry.getValue().entityInfo != null) {
                category = entry.getValue().entityInfo.category;
            } else if (entry.getValue().entity instanceof Player) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, entry.getValue().entity.m_142049_(), 0, 0, category);
        }
        iter = this.sideB.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue().entity.m_6084_()) continue;
            iter.remove();
            this.players.remove(entry.getKey());
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
            category = null;
            if (entry.getValue().entityInfo != null) {
                category = entry.getValue().entityInfo.category;
            } else if (entry.getValue().entity instanceof Player) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, entry.getValue().entity.m_142049_(), 0, 0, category);
        }
        if (this.players.isEmpty() || this.sideA.isEmpty() || this.sideB.isEmpty()) {
            this.battleEnded = true;
        } else if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private boolean isCreativeCheck() {
        boolean didRemove = false;
        Iterator<Map.Entry<Integer, Combatant>> iter = this.players.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Combatant> entry = iter.next();
            if (entry.getValue().entity == null || !((Player)entry.getValue().entity).m_7500_()) continue;
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BECAME_CREATIVE, entry.getValue().entity.m_142049_(), 0, 0);
            iter.remove();
            this.sideA.remove(entry.getKey());
            this.sideB.remove(entry.getKey());
            this.playerCount.decrementAndGet();
            this.removeCombatantPostRemove(entry.getValue());
            didRemove = true;
        }
        if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private void resetUndecidedCount() {
        if (this.state == State.DECISION) {
            this.undecidedCount.set(0);
            for (Combatant p : this.players.values()) {
                if (p.decision != Decision.UNDECIDED) continue;
                this.undecidedCount.incrementAndGet();
            }
        }
    }

    private void enforceFreezePositions() {
        for (Combatant c : this.sideA.values()) {
            c.entity.m_6034_(c.x, c.entity.m_20186_(), c.z);
            c.entity.m_5618_(c.yaw);
            c.entity.m_5616_(c.pitch);
        }
        for (Combatant c : this.sideB.values()) {
            c.entity.m_6034_(c.x, c.entity.m_20186_(), c.z);
            c.entity.m_5618_(c.yaw);
            c.entity.m_5616_(c.pitch);
        }
    }

    private void removeCombatant(Combatant c) {
        this.sideA.remove(c.entity.m_142049_());
        this.sideB.remove(c.entity.m_142049_());
        if (this.players.remove(c.entity.m_142049_()) != null) {
            this.playerCount.decrementAndGet();
        }
        this.removeCombatantPostRemove(c);
    }

    private void removeCombatantPostRemove(Combatant c) {
        if (c.entity instanceof Player) {
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)c.entity), (Object)new PacketBattleMessage(PacketBattleMessage.MessageType.ENDED, 0, 0, this.dimension, 0));
        }
        this.battleManager.addRecentlyLeftBattle(c);
    }

    public void forceRemoveCombatant(EntityIDDimPair e) {
        Combatant c;
        this.sideA.remove(e.id);
        this.sideB.remove(e.id);
        if (this.players.remove(e.id) != null) {
            this.playerCount.decrementAndGet();
        }
        Iterator iter = this.sideAEntryQueue.iterator();
        while (iter.hasNext()) {
            c = (Combatant)iter.next();
            if (c.entity.m_142049_() != e.id) continue;
            iter.remove();
            break;
        }
        iter = this.sideBEntryQueue.iterator();
        while (iter.hasNext()) {
            c = (Combatant)iter.next();
            if (c.entity.m_142049_() != e.id) continue;
            iter.remove();
            break;
        }
    }

    private void setDecisionState() {
        for (Combatant c : this.sideA.values()) {
            c.decision = Decision.UNDECIDED;
        }
        for (Combatant c : this.sideB.values()) {
            c.decision = Decision.UNDECIDED;
        }
        this.state = State.DECISION;
        this.undecidedCount.set(this.players.size());
    }

    public boolean update() {
        if (!this.isServer) {
            return false;
        }
        if (this.battleEnded) {
            ArrayList<Combatant> combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        long nextInstant = System.nanoTime();
        long dt = nextInstant - this.lastInstant;
        this.lastInstant = nextInstant;
        try {
            return this.update(dt);
        }
        catch (Throwable t) {
            TurnBasedMinecraftMod.logger.error("Update: ", t);
            this.setDecisionState();
            boolean changed = false;
            if (this.healthCheck()) {
                changed = true;
            }
            if (this.isCreativeCheck()) {
                changed = true;
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_END, 0, 0, 1);
            if (changed) {
                this.notifyPlayersBattleInfo();
            }
            return this.battleEnded;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean update(long dt) {
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        combatantsChanged = false;
        c = this.sideAEntryQueue.poll();
        while (c != null) {
            this.sideA.put(c.entity.m_142049_(), (Combatant)c);
            combatantsChanged = true;
            c = this.sideAEntryQueue.poll();
        }
        c = this.sideBEntryQueue.poll();
        while (c != null) {
            this.sideB.put(c.entity.m_142049_(), (Combatant)c);
            combatantsChanged = true;
            c = this.sideBEntryQueue.poll();
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            this.enforceFreezePositions();
        }
        this.defuseCreepers();
        switch (1.$SwitchMap$com$burnedkirby$TurnBasedMinecraft$common$Battle$State[this.state.ordinal()]) {
            case 1: {
                this.timer -= dt;
                if (!this.timerForever && this.timer <= 0L || this.undecidedCount.get() <= 0) {
                    for (Combatant c : this.sideA.values()) {
                        if (c.entity instanceof Player || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        if (c.entity instanceof Creeper) {
                            if (c.creeperTurns++ < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                                c.decision = Decision.CREEPER_WAIT;
                                continue;
                            }
                            c.decision = Decision.CREEPER_EXPLODE;
                            continue;
                        }
                        percentage = this.random.nextInt(100);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    for (Combatant c : this.sideB.values()) {
                        if (c.entity instanceof Player || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        if (c.entity instanceof Creeper) {
                            if (c.creeperTurns++ < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                                c.decision = Decision.CREEPER_WAIT;
                                continue;
                            }
                            c.decision = Decision.CREEPER_EXPLODE;
                            continue;
                        }
                        percentage = this.random.nextInt(100);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    this.state = State.ACTION;
                    this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
                    this.timerForever = TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever();
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_BEGIN, 0, 0, 0);
                    this.turnOrderQueue.clear();
                    for (Combatant c : this.sideA.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    for (Combatant c : this.sideB.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    return this.update(0L);
                }
                if (this.healthCheck()) {
                    combatantsChanged = true;
                }
                if (!this.isCreativeCheck()) break;
                combatantsChanged = true;
                break;
            }
            case 2: {
                next = this.turnOrderQueue.poll();
                if (next == null || !next.entity.m_6084_()) ** GOTO lbl411
                this.debugLog = next.entity.m_5446_().getString();
                next.remainingDefenses = 0;
                decision = next.decision;
                next.decision = Decision.UNDECIDED;
                switch (1.$SwitchMap$com$burnedkirby$TurnBasedMinecraft$common$Battle$Decision[decision.ordinal()]) {
                    case 1: {
                        this.debugLog = this.debugLog + " undecided";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DID_NOTHING, next.entity.m_142049_(), 0, 0);
                        break;
                    }
                    case 2: {
                        this.debugLog = this.debugLog + " attack";
                        target = null;
                        if (next.entity instanceof Player) {
                            this.debugLog = this.debugLog + " as player";
                            target = this.sideA.get(next.targetEntityID);
                            if (target == null) {
                                target = this.sideB.get(next.targetEntityID);
                            }
                            if (target == null || !target.entity.m_6084_() || target == next) break;
                            heldItemStack = ((Player)next.entity).m_21205_();
                            if (heldItemStack.m_41720_() instanceof BowItem) {
                                this.debugLog = this.debugLog + " with bow";
                                if (Utility.doesPlayerHaveArrows((Player)next.entity)) {
                                    nextEntity = next.entity;
                                    targetEntity = target.entity;
                                    yawDirection = Utility.yawDirection(next.entity.m_20185_(), next.entity.m_20189_(), target.entity.m_20185_(), target.entity.m_20189_());
                                    pitchDirection = Utility.pitchDirection(next.entity.m_20185_(), next.entity.m_20186_(), next.entity.m_20189_(), target.entity.m_20185_(), target.entity.m_20186_(), target.entity.m_20189_());
                                    randomTimeLeft = this.random.nextInt(heldItemStack.m_41720_().m_8105_(heldItemStack) / 3);
                                    if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                        next.yaw = yawDirection;
                                        next.pitch = pitchDirection;
                                    }
                                    ((ServerPlayer)nextEntity).f_8906_.m_9774_(nextEntity.m_20185_(), nextEntity.m_20186_(), nextEntity.m_20189_(), yawDirection, pitchDirection);
                                    itemBow = (BowItem)heldItemStack.m_41720_();
                                    TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().add(new AttackerViaBow(nextEntity, this.getId()));
                                    itemBow.m_5551_(((Player)nextEntity).m_21205_(), nextEntity.f_19853_, (LivingEntity)nextEntity, randomTimeLeft);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FIRED_ARROW, nextEntity.m_142049_(), targetEntity.m_142049_(), 0);
                                    break;
                                }
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BOW_NO_AMMO, next.entity.m_142049_(), 0, 0);
                                break;
                            }
                            this.debugLog = this.debugLog + " without bow";
                            hitChance = TurnBasedMinecraftMod.proxy.getConfig().getPlayerAttackProbability();
                            hitChance = target.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - target.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) < hitChance) {
                                if (target.remainingDefenses <= 0) {
                                    this.debugLog = this.debugLog + " hit success";
                                    nextEntity = next.entity;
                                    targetEntity = target.entity;
                                    targetEntityInfo = target.entityInfo;
                                    yawDirection = Utility.yawDirection(next.entity.m_20185_(), next.entity.m_20189_(), target.entity.m_20185_(), target.entity.m_20189_());
                                    pitchDirection = Utility.pitchDirection(next.entity.m_20185_(), next.entity.m_20186_(), next.entity.m_20189_(), target.entity.m_20185_(), target.entity.m_20186_(), target.entity.m_20189_());
                                    defenseDamageTriggered = !(targetEntity instanceof Player) && targetEntityInfo.defenseDamage > 0 && targetEntityInfo.defenseDamageProbability > 0 ? this.random.nextInt(100) < targetEntityInfo.defenseDamageProbability : false;
                                    if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                        next.yaw = yawDirection;
                                        next.pitch = pitchDirection;
                                    }
                                    ((ServerPlayer)nextEntity).f_8906_.m_9774_(nextEntity.m_20185_(), nextEntity.m_20186_(), nextEntity.m_20189_(), yawDirection, pitchDirection);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingDamage(0);
                                    ((Player)nextEntity).m_5706_(targetEntity);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.m_142049_(), targetEntity.m_142049_(), TurnBasedMinecraftMod.proxy.getAttackingDamage());
                                    if (!defenseDamageTriggered) break;
                                    defenseDamageSource = DamageSource.m_19370_((LivingEntity)((LivingEntity)targetEntity));
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
                                    nextEntity.f_19802_ = 0;
                                    nextEntity.m_6469_(defenseDamageSource, (float)targetEntityInfo.defenseDamage);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.m_142049_(), nextEntity.m_142049_(), targetEntityInfo.defenseDamage);
                                    break;
                                }
                                this.debugLog = this.debugLog + " hit blocked";
                                --target.remainingDefenses;
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.m_142049_(), next.entity.m_142049_(), 0);
                                break;
                            }
                            this.debugLog = this.debugLog + " hit missed";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.m_142049_(), target.entity.m_142049_(), 0);
                            break;
                        }
                        this.debugLog = this.debugLog + " as mob";
                        attackTarget = ((Mob)next.entity).m_5448_();
                        if (attackTarget == null || !this.hasCombatant(attackTarget.m_142049_())) ** GOTO lbl175
                        this.debugLog = this.debugLog + " to targeted";
                        target = this.getCombatantByID(attackTarget.m_142049_());
                        ** GOTO lbl191
lbl175:
                        // 1 sources

                        this.debugLog = this.debugLog + " to random other side";
                        if (!next.isSideA) ** GOTO lbl185
                        if (this.sideB.size() <= 0) ** GOTO lbl191
                        randomTargetIndex = this.random.nextInt(this.sideB.size());
                        for (Combatant c : this.sideB.values()) {
                            if (randomTargetIndex-- != 0) continue;
                            target = c;
                            ** GOTO lbl191
                        }
                        ** GOTO lbl191
lbl185:
                        // 1 sources

                        if (this.sideA.size() > 0) {
                            randomTargetIndex = this.random.nextInt(this.sideA.size());
                            for (Combatant c : this.sideA.values()) {
                                if (randomTargetIndex-- != 0) continue;
                                target = c;
                                break;
                            }
                        }
lbl191:
                        // 8 sources

                        if (target == null || !target.entity.m_6084_() || target == next) break;
                        hitChance = next.entityInfo.attackProbability;
                        hitChance = target.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - target.entityInfo.evasion) / 100;
                        if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                            hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                        }
                        if (this.random.nextInt(100) < hitChance) {
                            if (target.remainingDefenses <= 0) {
                                this.debugLog = this.debugLog + " hit success";
                                damageSource = DamageSource.m_19370_((LivingEntity)((LivingEntity)next.entity));
                                damageAmount = next.entityInfo.attackPower;
                                if (next.entityInfo.attackVariance > 0) {
                                    damageAmount += this.random.nextInt(next.entityInfo.attackVariance * 2 + 1) - next.entityInfo.attackVariance;
                                }
                                if (damageAmount < 0) {
                                    damageAmount = 0;
                                }
                                nextEntity = next.entity;
                                nextEntityInfo = next.entityInfo;
                                targetEntity = target.entity;
                                targetEntityInfo = target.entityInfo;
                                finalDamageAmount = damageAmount;
                                defenseDamageTriggered = !(targetEntity instanceof Player) && targetEntityInfo.defenseDamage > 0 && targetEntityInfo.defenseDamageProbability > 0 ? this.random.nextInt(100) < targetEntityInfo.defenseDamageProbability : false;
                                attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                                TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                                targetEntity.f_19802_ = 0;
                                targetEntity.m_6469_(damageSource, (float)finalDamageAmount);
                                TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.m_142049_(), targetEntity.m_142049_(), finalDamageAmount);
                                if (defenseDamageTriggered) {
                                    defenseDamageSource = DamageSource.m_19370_((LivingEntity)((LivingEntity)targetEntity));
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
                                    nextEntity.f_19802_ = 0;
                                    nextEntity.m_6469_(defenseDamageSource, (float)targetEntityInfo.defenseDamage);
                                    TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.m_142049_(), nextEntity.m_142049_(), targetEntityInfo.defenseDamage);
                                }
                                if (!attackEffectTriggered) break;
                                nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.m_142049_(), targetEntity.m_142049_(), 0, nextEntityInfo.attackEffect.getAffectedString());
                                break;
                            }
                            this.debugLog = this.debugLog + " hit blocked";
                            --target.remainingDefenses;
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.m_142049_(), next.entity.m_142049_(), 0);
                            break;
                        }
                        this.debugLog = this.debugLog + " hit missed";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.m_142049_(), target.entity.m_142049_(), 0);
                        break;
                    }
                    case 3: {
                        this.debugLog = this.debugLog + " defend";
                        next.remainingDefenses = TurnBasedMinecraftMod.proxy.getConfig().getDefenseDuration();
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENDING, next.entity.m_142049_(), 0, 0);
                        break;
                    }
                    case 4: {
                        this.debugLog = this.debugLog + " flee";
                        fastestEnemySpeed = 0;
                        if (next.isSideA) {
                            for (Combatant c : this.sideB.values()) {
                                if (c.entity instanceof Player) {
                                    playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    if (((Player)c.entity).m_21023_(MobEffects.f_19596_)) {
                                        playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                                    } else if (((Player)c.entity).m_21023_(MobEffects.f_19597_)) {
                                        playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                                    }
                                    if (playerSpeed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    continue;
                                }
                                if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                fastestEnemySpeed = c.entityInfo.speed;
                            }
                        } else {
                            for (Combatant c : this.sideA.values()) {
                                if (c.entity instanceof Player) {
                                    playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    if (((Player)c.entity).m_21023_(MobEffects.f_19596_)) {
                                        playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                                    } else if (((Player)c.entity).m_21023_(MobEffects.f_19597_)) {
                                        playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                                    }
                                    if (playerSpeed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                    continue;
                                }
                                if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                fastestEnemySpeed = c.entityInfo.speed;
                            }
                        }
                        fleeProbability = 0;
                        if (next.entity instanceof Player) {
                            playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                            if (((Player)next.entity).m_21023_(MobEffects.f_19596_)) {
                                playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerHasteSpeed();
                            } else if (((Player)next.entity).m_21023_(MobEffects.f_19597_)) {
                                playerSpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSlowSpeed();
                            }
                            fleeProbability = fastestEnemySpeed >= playerSpeed ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability();
                        } else {
                            fleeProbability = fastestEnemySpeed >= next.entityInfo.speed ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability();
                        }
                        if (this.random.nextInt(100) < fleeProbability) {
                            this.debugLog = this.debugLog + " success";
                            combatantsChanged = true;
                            fleeingCategory = new String();
                            if (next.entityInfo != null) {
                                fleeingCategory = next.entityInfo.category;
                            } else if (next.entity instanceof Player) {
                                fleeingCategory = "player";
                            }
                            this.removeCombatant(next);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.m_142049_(), 0, 1, fleeingCategory);
                            break;
                        }
                        this.debugLog = this.debugLog + " fail";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.m_142049_(), 0, 0);
                        break;
                    }
                    case 5: {
                        this.debugLog = this.debugLog + " use item";
                        if (next.itemToUse < 0 || next.itemToUse > 8) {
                            this.debugLog = this.debugLog + " invalid";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue());
                            break;
                        }
                        targetItemStack = ((Player)next.entity).m_150109_().m_8020_(next.itemToUse);
                        targetItem = targetItemStack.m_41720_();
                        if (targetItem == null) {
                            this.debugLog = this.debugLog + " null";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_NOTHING.getValue());
                            break;
                        }
                        if (targetItem.m_41472_()) {
                            this.debugLog = this.debugLog + " food";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_FOOD.getValue(), targetItemStack.m_41611_().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).m_150109_().m_6836_(nextItemToUse, targetItem.m_5922_(targetItemStack, nextEntity.f_19853_, (LivingEntity)nextEntity));
                            break;
                        }
                        if (targetItem.m_41471_() == CreativeModeTab.f_40755_ && targetItem.m_41472_()) {
                            this.debugLog = this.debugLog + " food";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_FOOD.getValue(), targetItemStack.m_41611_().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).m_150109_().m_6836_(nextItemToUse, targetItem.m_5922_(targetItemStack, nextEntity.f_19853_, (LivingEntity)nextEntity));
                            break;
                        }
                        if (targetItem instanceof PotionItem) {
                            this.debugLog = this.debugLog + " potion";
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_POTION.getValue(), targetItemStack.m_41611_().getString());
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            ((Player)nextEntity).m_150109_().m_6836_(nextItemToUse, targetItem.m_5922_(targetItemStack, nextEntity.f_19853_, (LivingEntity)nextEntity));
                            break;
                        }
                        this.debugLog = this.debugLog + " non-consumable";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.m_142049_(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue(), targetItemStack.m_41611_().getString());
                        break;
                    }
                    case 6: {
                        this.debugLog = this.debugLog + " switch item";
                        if (next.itemToUse < 0 || next.itemToUse > 8) {
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.m_142049_(), 0, 0);
                            break;
                        }
                        nextEntity = next.entity;
                        ((Player)nextEntity).m_150109_().f_35977_ = nextItemToUse = next.itemToUse;
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.m_142049_(), 0, 1);
                        break;
                    }
                    case 7: {
                        this.debugLog = this.debugLog + " creeper wait";
                        if (next.creeperTurns < TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_WAIT, next.entity.m_142049_(), 0, 0);
                            break;
                        }
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_WAIT_FINAL, next.entity.m_142049_(), 0, 0);
                        break;
                    }
                    case 8: {
                        this.debugLog = this.debugLog + " creeper explode";
                        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.CREEPER_EXPLODE, next.entity.m_142049_(), 0, 0);
                        nextEntity = next.entity;
                        nextEntityInfo = next.entityInfo;
                        for (Combatant c : this.sideA.values()) {
                            if (c.entity.m_142049_() == next.entity.m_142049_()) continue;
                            hitChance = next.entityInfo.attackProbability;
                            hitChance = c.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - c.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) >= hitChance) continue;
                            targetEntity = c.entity;
                            targetEntityInfo = c.entityInfo;
                            damageAmount = nextEntityInfo.attackPower;
                            if (nextEntityInfo.attackVariance > 0) {
                                damageAmount += this.random.nextInt(nextEntityInfo.attackVariance * 2 + 1) - nextEntityInfo.attackVariance;
                            }
                            if (damageAmount < 0) {
                                damageAmount = 0;
                            }
                            finalDamageAmount = damageAmount;
                            attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                            targetEntity.f_19802_ = 0;
                            targetEntity.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)nextEntity)), (float)finalDamageAmount);
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.m_142049_(), targetEntity.m_142049_(), finalDamageAmount);
                            if (!attackEffectTriggered) continue;
                            nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.m_142049_(), targetEntity.m_142049_(), 0, nextEntityInfo.attackEffect.getAffectedString());
                        }
                        for (Combatant c : this.sideB.values()) {
                            if (c.entity.m_142049_() == next.entity.m_142049_()) continue;
                            hitChance = next.entityInfo.attackProbability;
                            hitChance = c.entity instanceof Player != false ? hitChance * (100 - TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) / 100 : hitChance * (100 - c.entityInfo.evasion) / 100;
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if (this.random.nextInt(100) >= hitChance) continue;
                            targetEntity = c.entity;
                            targetEntityInfo = c.entityInfo;
                            damageAmount = nextEntityInfo.attackPower;
                            if (nextEntityInfo.attackVariance > 0) {
                                damageAmount += this.random.nextInt(nextEntityInfo.attackVariance * 2 + 1) - nextEntityInfo.attackVariance;
                            }
                            if (damageAmount < 0) {
                                damageAmount = 0;
                            }
                            finalDamageAmount = damageAmount;
                            attackEffectTriggered = nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 ? this.random.nextInt(100) < nextEntityInfo.attackEffectProbability : false;
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
                            targetEntity.f_19802_ = 0;
                            targetEntity.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)nextEntity)), (float)finalDamageAmount);
                            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.m_142049_(), targetEntity.m_142049_(), finalDamageAmount);
                            if (!attackEffectTriggered) continue;
                            nextEntityInfo.attackEffect.applyEffectToEntity((LivingEntity)targetEntity);
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.m_142049_(), targetEntity.m_142049_(), 0, nextEntityInfo.attackEffect.getAffectedString());
                        }
                        ((Creeper)nextEntity).m_32283_(1000000);
                    }
                }
lbl411:
                // 29 sources

                this.debugLog = "Action almost end";
                if (this.turnOrderQueue.isEmpty()) {
                    this.setDecisionState();
                    if (this.healthCheck()) {
                        combatantsChanged = true;
                    }
                    if (this.isCreativeCheck()) {
                        combatantsChanged = true;
                    }
                    this.debugLog = this.debugLog + ", adding task";
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_END, 0, 0, 0);
                }
                this.debugLog = "Actions end";
                break;
            }
            default: {
                this.state = State.DECISION;
            }
        }
        this.debugLog = "Update almost end";
        if (combatantsChanged) {
            this.notifyPlayersBattleInfo();
        }
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
        }
        this.debugLog = "Update end";
        return this.battleEnded;
    }

    private void defuseCreepers() {
        for (Combatant c : this.sideA.values()) {
            if (!(c.entity instanceof Creeper)) continue;
            if (c.creeperTurns <= TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                ((Creeper)c.entity).m_32283_(-10);
                continue;
            }
            ((Creeper)c.entity).m_32283_(1000000);
        }
        for (Combatant c : this.sideB.values()) {
            if (!(c.entity instanceof Creeper)) continue;
            if (c.creeperTurns <= TurnBasedMinecraftMod.proxy.getConfig().getCreeperExplodeTurn()) {
                ((Creeper)c.entity).m_32283_(-10);
                continue;
            }
            ((Creeper)c.entity).m_32283_(1000000);
        }
    }

    public static enum State {
        DECISION(0),
        ACTION(1),
        DECISION_PLAYER_READY(2);

        private int value;
        private static Map<Integer, State> map;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State valueOf(int stateType) {
            return map.get(stateType);
        }

        static {
            map = new HashMap<Integer, State>();
            for (State state : State.values()) {
                map.put(state.value, state);
            }
        }
    }

    public static enum Decision {
        UNDECIDED(0),
        ATTACK(1),
        DEFEND(2),
        FLEE(3),
        USE_ITEM(4),
        SWITCH_ITEM(5),
        CREEPER_WAIT(6),
        CREEPER_EXPLODE(7);

        private int value;
        private static Map<Integer, Decision> map;

        private Decision(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Decision valueOf(int decisionType) {
            return map.get(decisionType);
        }

        static {
            map = new HashMap<Integer, Decision>();
            for (Decision decision : Decision.values()) {
                map.put(decision.value, decision);
            }
        }
    }
}

