/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.client;

import com.seodisparate.TurnBasedMinecraft.client.EntitySelectionButton;
import com.seodisparate.TurnBasedMinecraft.client.ItemSelectionButton;
import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.Combatant;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BattleGui
extends GuiScreen {
    private AtomicInteger timeRemaining = new AtomicInteger(15);
    private long lastInstant = System.nanoTime();
    private long elapsedTime = 0L;
    private MenuState state = MenuState.MAIN_MENU;
    private boolean stateChanged = true;
    private String info;

    private void setState(MenuState state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void turnBegin() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.ACTION);
        }
        this.setState(MenuState.WAITING);
    }

    public void turnEnd() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.DECISION);
        }
        this.timeRemaining.set(TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationSeconds());
        this.elapsedTime = 0L;
        this.lastInstant = System.nanoTime();
        this.setState(MenuState.MAIN_MENU);
    }

    public void battleChanged() {
        this.stateChanged = true;
    }

    public void updateState() {
        if (!this.stateChanged) {
            return;
        }
        this.stateChanged = false;
        this.field_146292_n.clear();
        switch (this.state) {
            case MAIN_MENU: {
                this.info = "What will you do?";
                this.field_146292_n.add(new GuiButton(ButtonAction.ATTACK.getValue(), this.field_146294_l * 3 / 7 - 25, 40, 50, 20, "Attack"));
                this.field_146292_n.add(new GuiButton(ButtonAction.DEFEND.getValue(), this.field_146294_l * 4 / 7 - 25, 40, 50, 20, "Defend"));
                this.field_146292_n.add(new GuiButton(ButtonAction.ITEM.getValue(), this.field_146294_l * 3 / 7 - 25, 60, 50, 20, "Item"));
                this.field_146292_n.add(new GuiButton(ButtonAction.FLEE.getValue(), this.field_146294_l * 4 / 7 - 25, 60, 50, 20, "Flee"));
                break;
            }
            case ATTACK_TARGET: {
                this.info = "Who will you attack?";
                int y = 30;
                for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                    if (e.getValue().entity != null) {
                        this.field_146292_n.add(new EntitySelectionButton(ButtonAction.ATTACK_TARGET.getValue(), this.field_146294_l / 4 - 60, y, 120, 20, e.getValue().entity.func_70005_c_(), e.getKey(), true));
                    } else {
                        this.field_146292_n.add(new EntitySelectionButton(ButtonAction.ATTACK_TARGET.getValue(), this.field_146294_l / 4 - 60, y, 120, 20, "Unknown", e.getKey(), true));
                    }
                    y += 20;
                }
                y = 30;
                for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                    if (e.getValue().entity != null) {
                        this.field_146292_n.add(new EntitySelectionButton(ButtonAction.ATTACK_TARGET.getValue(), this.field_146294_l * 3 / 4 - 60, y, 120, 20, e.getValue().entity.func_70005_c_(), e.getKey(), false));
                    } else {
                        this.field_146292_n.add(new EntitySelectionButton(ButtonAction.ATTACK_TARGET.getValue(), this.field_146294_l * 3 / 4 - 60, y, 120, 20, "Unknown", e.getKey(), false));
                    }
                    y += 20;
                }
                this.field_146292_n.add(new GuiButton(ButtonAction.CANCEL.getValue(), this.field_146294_l / 2 - 40, this.field_146295_m - 120, 80, 20, "Cancel"));
                break;
            }
            case ITEM_ACTION: {
                this.info = "What will you do with an item?";
                this.field_146292_n.add(new GuiButton(ButtonAction.SWITCH_HELD_ITEM.getValue(), this.field_146294_l * 1 / 4 - 40, this.field_146295_m - 120, 80, 20, "Switch Held"));
                this.field_146292_n.add(new GuiButton(ButtonAction.DECIDE_USE_ITEM.getValue(), this.field_146294_l * 2 / 4 - 40, this.field_146295_m - 120, 80, 20, "Use"));
                this.field_146292_n.add(new GuiButton(ButtonAction.CANCEL.getValue(), this.field_146294_l * 3 / 4 - 40, this.field_146295_m - 120, 80, 20, "Cancel"));
                break;
            }
            case WAITING: {
                this.info = "Waiting...";
                break;
            }
            case SWITCH_ITEM: {
                this.info = "To which item will you switch to?";
                for (int i = 0; i < 9; ++i) {
                    this.field_146292_n.add(new ItemSelectionButton(ButtonAction.DO_ITEM_SWITCH.getValue(), this.field_146294_l / 2 - 88 + i * 20, this.field_146295_m - 19, 16, 16, "", i));
                }
                this.field_146292_n.add(new GuiButton(ButtonAction.CANCEL.getValue(), this.field_146294_l / 2 - 40, this.field_146295_m - 120, 80, 20, "Cancel"));
                break;
            }
            case USE_ITEM: {
                this.info = "Which item will you use?";
                for (int i = 0; i < 9; ++i) {
                    this.field_146292_n.add(new ItemSelectionButton(ButtonAction.DO_USE_ITEM.getValue(), this.field_146294_l / 2 - 88 + i * 20, this.field_146295_m - 19, 16, 16, "", i));
                }
                this.field_146292_n.add(new GuiButton(ButtonAction.CANCEL.getValue(), this.field_146294_l / 2 - 40, this.field_146295_m - 120, 80, 20, "Cancel"));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
            this.func_146279_a("Waiting...", this.field_146294_l / 2 - 50, this.field_146295_m / 2);
            return;
        }
        if (TurnBasedMinecraftMod.proxy.getLocalBattle().getState() == Battle.State.DECISION && this.timeRemaining.get() > 0) {
            long nextInstant = System.nanoTime();
            this.elapsedTime += nextInstant - this.lastInstant;
            this.lastInstant = nextInstant;
            while (this.elapsedTime > 1000000000L) {
                this.elapsedTime -= 1000000000L;
                this.timeRemaining.decrementAndGet();
            }
        }
        this.updateState();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String timeRemainingString = "Time remaining: ";
        int timeRemainingInt = this.timeRemaining.get();
        timeRemainingString = timeRemainingInt > 8 ? timeRemainingString + "\u00a7a" : (timeRemainingInt > 4 ? timeRemainingString + "\u00a7e" : timeRemainingString + "\u00a7c");
        timeRemainingString = timeRemainingString + Integer.toString(timeRemainingInt);
        int stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(timeRemainingString);
        BattleGui.func_73734_a((int)(this.field_146294_l / 2 - stringWidth / 2), (int)5, (int)(this.field_146294_l / 2 + stringWidth / 2), (int)15, (int)0x70000000);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(timeRemainingString, this.field_146294_l / 2 - stringWidth / 2, 5, -1);
        stringWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.info);
        BattleGui.func_73734_a((int)(this.field_146294_l / 2 - stringWidth / 2), (int)20, (int)(this.field_146294_l / 2 + stringWidth / 2), (int)30, (int)0x70000000);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.info, this.field_146294_l / 2 - stringWidth / 2, 20, -1);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (ButtonAction.valueOf(button.field_146127_k)) {
            case ATTACK: {
                this.setState(MenuState.ATTACK_TARGET);
                break;
            }
            case DEFEND: {
                TurnBasedMinecraftMod.NWINSTANCE.sendToServer((IMessage)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.DEFEND, 0));
                this.setState(MenuState.WAITING);
                break;
            }
            case ITEM: {
                this.setState(MenuState.ITEM_ACTION);
                break;
            }
            case FLEE: {
                TurnBasedMinecraftMod.NWINSTANCE.sendToServer((IMessage)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.FLEE, 0));
                this.setState(MenuState.WAITING);
                break;
            }
            case ATTACK_TARGET: {
                if (button instanceof EntitySelectionButton) {
                    TurnBasedMinecraftMod.NWINSTANCE.sendToServer((IMessage)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.ATTACK, ((EntitySelectionButton)button).entityID));
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case SWITCH_HELD_ITEM: {
                this.setState(MenuState.SWITCH_ITEM);
                break;
            }
            case DECIDE_USE_ITEM: {
                this.setState(MenuState.USE_ITEM);
                break;
            }
            case CANCEL: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_ITEM_SWITCH: {
                if (button instanceof ItemSelectionButton) {
                    TurnBasedMinecraftMod.NWINSTANCE.sendToServer((IMessage)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.SWITCH_ITEM, ((ItemSelectionButton)button).itemStackID));
                    if (((ItemSelectionButton)button).itemStackID >= 0 && ((ItemSelectionButton)button).itemStackID < 9) {
                        Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = ((ItemSelectionButton)button).itemStackID;
                    }
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_USE_ITEM: {
                if (button instanceof ItemSelectionButton) {
                    TurnBasedMinecraftMod.NWINSTANCE.sendToServer((IMessage)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.USE_ITEM, ((ItemSelectionButton)button).itemStackID));
                    this.setState(MenuState.WAITING);
                    break;
                }
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void setTimeRemaining(int remaining) {
        this.timeRemaining.set(remaining);
    }

    private static enum ButtonAction {
        ATTACK(0),
        DEFEND(1),
        ITEM(2),
        FLEE(3),
        ATTACK_TARGET(4),
        SWITCH_HELD_ITEM(5),
        DECIDE_USE_ITEM(6),
        CANCEL(7),
        DO_ITEM_SWITCH(8),
        DO_USE_ITEM(9);

        private int value;
        private static Map<Integer, ButtonAction> map;

        private ButtonAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ButtonAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ButtonAction>();
            for (ButtonAction action : ButtonAction.values()) {
                map.put(action.getValue(), action);
            }
        }
    }

    private static enum MenuState {
        MAIN_MENU(0),
        ATTACK_TARGET(1),
        ITEM_ACTION(2),
        WAITING(3),
        SWITCH_ITEM(4),
        USE_ITEM(5);

        private int value;
        private static Map<Integer, MenuState> map;

        private MenuState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MenuState valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MenuState>();
            for (MenuState state : MenuState.values()) {
                map.put(state.getValue(), state);
            }
        }
    }
}

