/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class EntityInfo {
    public Class classType = null;
    public boolean ignoreBattle = false;
    public int attackPower = 0;
    public int attackProbability = 70;
    public int attackVariance = 0;
    public Effect attackEffect = Effect.UNKNOWN;
    public int attackEffectProbability = 50;
    public int defenseDamage = 0;
    public int defenseDamageProbability = 0;
    public int evasion = 15;
    public int speed = 50;
    public String category = "unknown";
    public int decisionAttack = 70;
    public int decisionDefend = 20;
    public int decisionFlee = 10;
    public String customName = new String();

    public EntityInfo clone() {
        EntityInfo newEntityInfo = new EntityInfo();
        newEntityInfo.classType = this.classType;
        newEntityInfo.ignoreBattle = this.ignoreBattle;
        newEntityInfo.attackPower = this.attackPower;
        newEntityInfo.attackProbability = this.attackProbability;
        newEntityInfo.attackVariance = this.attackVariance;
        newEntityInfo.attackEffect = this.attackEffect;
        newEntityInfo.attackEffectProbability = this.attackEffectProbability;
        newEntityInfo.defenseDamage = this.defenseDamage;
        newEntityInfo.defenseDamageProbability = this.defenseDamageProbability;
        newEntityInfo.evasion = this.evasion;
        newEntityInfo.speed = this.speed;
        newEntityInfo.category = this.category;
        newEntityInfo.decisionAttack = this.decisionAttack;
        newEntityInfo.decisionDefend = this.decisionDefend;
        newEntityInfo.decisionFlee = this.decisionFlee;
        newEntityInfo.customName = new String(this.customName);
        return newEntityInfo;
    }

    public static enum Effect {
        SPEED,
        SLOW,
        HASTE,
        MINING_FATIGUE,
        STRENGTH,
        JUMP_BOOST,
        NAUSEA,
        REGENERATION,
        RESISTANCE,
        FIRE_RESISTANCE,
        WATER_BREATHING,
        INVISIBILITY,
        BLINDNESS,
        NIGHT_VISION,
        HUNGER,
        WEAKNESS,
        POISON,
        WITHER,
        HEALTH_BOOST,
        ABSORPTION,
        SATURATION,
        GLOWING,
        LEVITATION,
        LUCK,
        UNLUCK,
        SLOW_FALLING,
        CONDUIT_POWER,
        DOLPHINS_GRACE,
        BAD_OMEN,
        FIRE,
        UNKNOWN;


        public static Effect fromString(String c) {
            if ((c = c.toLowerCase()).equals("speed")) {
                return SPEED;
            }
            if (c.equals("slow")) {
                return SLOW;
            }
            if (c.equals("haste")) {
                return HASTE;
            }
            if (c.equals("mining_fatigue") || c.equals("fatigue")) {
                return MINING_FATIGUE;
            }
            if (c.equals("strength")) {
                return STRENGTH;
            }
            if (c.equals("jump_boost")) {
                return JUMP_BOOST;
            }
            if (c.equals("nausea")) {
                return NAUSEA;
            }
            if (c.equals("regeneration")) {
                return REGENERATION;
            }
            if (c.equals("resistance")) {
                return RESISTANCE;
            }
            if (c.equals("fire_resistance")) {
                return FIRE_RESISTANCE;
            }
            if (c.equals("water_breathing")) {
                return WATER_BREATHING;
            }
            if (c.equals("invisibility")) {
                return INVISIBILITY;
            }
            if (c.equals("blindness") || c.equals("blind")) {
                return BLINDNESS;
            }
            if (c.equals("night_vision")) {
                return NIGHT_VISION;
            }
            if (c.equals("hunger")) {
                return HUNGER;
            }
            if (c.equals("weakness")) {
                return WEAKNESS;
            }
            if (c.equals("poison")) {
                return POISON;
            }
            if (c.equals("wither")) {
                return WITHER;
            }
            if (c.equals("health_boost")) {
                return HEALTH_BOOST;
            }
            if (c.equals("absorption")) {
                return ABSORPTION;
            }
            if (c.equals("saturation")) {
                return SATURATION;
            }
            if (c.equals("glowing")) {
                return GLOWING;
            }
            if (c.equals("levitation")) {
                return LEVITATION;
            }
            if (c.equals("luck")) {
                return LUCK;
            }
            if (c.equals("unluck")) {
                return UNLUCK;
            }
            if (c.equals("slow_falling")) {
                return SLOW_FALLING;
            }
            if (c.equals("conduit_power")) {
                return CONDUIT_POWER;
            }
            if (c.equals("dolphins_grace")) {
                return DOLPHINS_GRACE;
            }
            if (c.equals("bad_omen")) {
                return BAD_OMEN;
            }
            if (c.equals("fire")) {
                return FIRE;
            }
            return UNKNOWN;
        }

        public String toString() {
            switch (this) {
                case SPEED: {
                    return "speed";
                }
                case SLOW: {
                    return "slow";
                }
                case HASTE: {
                    return "haste";
                }
                case MINING_FATIGUE: {
                    return "mining_fatigue";
                }
                case STRENGTH: {
                    return "strength";
                }
                case JUMP_BOOST: {
                    return "jump_boost";
                }
                case NAUSEA: {
                    return "nausea";
                }
                case REGENERATION: {
                    return "regeneration";
                }
                case RESISTANCE: {
                    return "resistance";
                }
                case FIRE_RESISTANCE: {
                    return "fire_resistance";
                }
                case WATER_BREATHING: {
                    return "water_breathing";
                }
                case INVISIBILITY: {
                    return "invisibility";
                }
                case BLINDNESS: {
                    return "blindness";
                }
                case NIGHT_VISION: {
                    return "night_vision";
                }
                case HUNGER: {
                    return "hunger";
                }
                case WEAKNESS: {
                    return "weakness";
                }
                case POISON: {
                    return "poison";
                }
                case WITHER: {
                    return "wither";
                }
                case HEALTH_BOOST: {
                    return "health_boost";
                }
                case ABSORPTION: {
                    return "absorption";
                }
                case SATURATION: {
                    return "saturation";
                }
                case GLOWING: {
                    return "glowing";
                }
                case LEVITATION: {
                    return "levitation";
                }
                case LUCK: {
                    return "luck";
                }
                case UNLUCK: {
                    return "unluck";
                }
                case SLOW_FALLING: {
                    return "slow_falling";
                }
                case CONDUIT_POWER: {
                    return "conduit_power";
                }
                case DOLPHINS_GRACE: {
                    return "dolphins_grace";
                }
                case BAD_OMEN: {
                    return "bad_omen";
                }
                case FIRE: {
                    return "fire";
                }
            }
            return "unknown";
        }

        public MobEffectInstance getPotionEffect() {
            return this.getPotionEffect(140, 0);
        }

        public MobEffectInstance getPotionEffect(int duration, int amplifier) {
            switch (this) {
                case SPEED: {
                    return new MobEffectInstance(MobEffects.f_19596_, duration, amplifier);
                }
                case SLOW: {
                    return new MobEffectInstance(MobEffects.f_19597_, duration, amplifier);
                }
                case HASTE: {
                    return new MobEffectInstance(MobEffects.f_19598_, duration, amplifier);
                }
                case MINING_FATIGUE: {
                    return new MobEffectInstance(MobEffects.f_19599_, duration, amplifier);
                }
                case STRENGTH: {
                    return new MobEffectInstance(MobEffects.f_19600_, duration, amplifier);
                }
                case JUMP_BOOST: {
                    return new MobEffectInstance(MobEffects.f_19603_, duration, amplifier);
                }
                case NAUSEA: {
                    return new MobEffectInstance(MobEffects.f_19604_, duration, amplifier);
                }
                case REGENERATION: {
                    return new MobEffectInstance(MobEffects.f_19605_, duration, amplifier);
                }
                case RESISTANCE: {
                    return new MobEffectInstance(MobEffects.f_19606_, duration, amplifier);
                }
                case FIRE_RESISTANCE: {
                    return new MobEffectInstance(MobEffects.f_19607_, duration, amplifier);
                }
                case WATER_BREATHING: {
                    return new MobEffectInstance(MobEffects.f_19608_, duration, amplifier);
                }
                case INVISIBILITY: {
                    return new MobEffectInstance(MobEffects.f_19609_, duration, amplifier);
                }
                case BLINDNESS: {
                    return new MobEffectInstance(MobEffects.f_19610_, duration, amplifier);
                }
                case NIGHT_VISION: {
                    return new MobEffectInstance(MobEffects.f_19611_, duration, amplifier);
                }
                case HUNGER: {
                    return new MobEffectInstance(MobEffects.f_19612_, duration, amplifier);
                }
                case WEAKNESS: {
                    return new MobEffectInstance(MobEffects.f_19613_, duration, amplifier);
                }
                case POISON: {
                    return new MobEffectInstance(MobEffects.f_19614_, duration, amplifier);
                }
                case WITHER: {
                    return new MobEffectInstance(MobEffects.f_19615_, duration, amplifier);
                }
                case HEALTH_BOOST: {
                    return new MobEffectInstance(MobEffects.f_19616_, duration, amplifier);
                }
                case ABSORPTION: {
                    return new MobEffectInstance(MobEffects.f_19617_, duration, amplifier);
                }
                case SATURATION: {
                    return new MobEffectInstance(MobEffects.f_19618_, duration, amplifier);
                }
                case GLOWING: {
                    return new MobEffectInstance(MobEffects.f_19619_, duration, amplifier);
                }
                case LEVITATION: {
                    return new MobEffectInstance(MobEffects.f_19620_, duration, amplifier);
                }
                case LUCK: {
                    return new MobEffectInstance(MobEffects.f_19621_, duration, amplifier);
                }
                case UNLUCK: {
                    return new MobEffectInstance(MobEffects.f_19590_, duration, amplifier);
                }
                case SLOW_FALLING: {
                    return new MobEffectInstance(MobEffects.f_19591_, duration, amplifier);
                }
                case CONDUIT_POWER: {
                    return new MobEffectInstance(MobEffects.f_19592_, duration, amplifier);
                }
                case DOLPHINS_GRACE: {
                    return new MobEffectInstance(MobEffects.f_19593_, duration, amplifier);
                }
                case BAD_OMEN: {
                    return new MobEffectInstance(MobEffects.f_19594_, duration, amplifier);
                }
                case FIRE: {
                    return null;
                }
            }
            return null;
        }

        public void applyEffectToEntity(LivingEntity entity) {
            this.applyEffectToEntity(entity, 240, 0);
        }

        public void applyEffectToEntity(LivingEntity entity, int duration, int amplifier) {
            if (this == FIRE) {
                entity.m_20254_(duration / 20);
                return;
            }
            if (this != UNKNOWN) {
                entity.m_7292_(this.getPotionEffect(duration, amplifier));
            }
        }

        public String getAffectedString() {
            switch (this) {
                case SPEED: {
                    return "made faster";
                }
                case SLOW: {
                    return "made slower";
                }
                case HASTE: {
                    return "made hastier";
                }
                case MINING_FATIGUE: {
                    return "fatigued";
                }
                case STRENGTH: {
                    return "strengthened";
                }
                case JUMP_BOOST: {
                    return "jump boosted";
                }
                case NAUSEA: {
                    return "made nauseous";
                }
                case REGENERATION: {
                    return "given regeneration";
                }
                case RESISTANCE: {
                    return "given resistance";
                }
                case FIRE_RESISTANCE: {
                    return "given fire resistance";
                }
                case WATER_BREATHING: {
                    return "made able to breathe underwater";
                }
                case INVISIBILITY: {
                    return "given invisibility";
                }
                case BLINDNESS: {
                    return "made blind";
                }
                case NIGHT_VISION: {
                    return "given night vision";
                }
                case HUNGER: {
                    return "made hungry";
                }
                case WEAKNESS: {
                    return "made weak";
                }
                case POISON: {
                    return "poisoned";
                }
                case WITHER: {
                    return "withered";
                }
                case HEALTH_BOOST: {
                    return "given more health";
                }
                case ABSORPTION: {
                    return "given absorption";
                }
                case SATURATION: {
                    return "given saturation";
                }
                case GLOWING: {
                    return "made to glow";
                }
                case LEVITATION: {
                    return "made to levitate";
                }
                case LUCK: {
                    return "given luck";
                }
                case UNLUCK: {
                    return "made unlucky";
                }
                case SLOW_FALLING: {
                    return "falls slower";
                }
                case CONDUIT_POWER: {
                    return "made able to live underwater";
                }
                case BAD_OMEN: {
                    return "feels a bad omen";
                }
                case FIRE: {
                    return "set on fire";
                }
            }
            return "given unknown";
        }
    }
}

