/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleUpdater;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EntityIDDimPair;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

public class BattleManager {
    private int IDCounter = 0;
    protected Map<Integer, Battle> battleMap;
    private Logger logger;
    private Map<Integer, Combatant> recentlyLeftBattle;
    private BattleUpdater battleUpdater;
    private Map<EntityIDDimPair, Integer> entityToBattleMap;
    private EntityIDDimPair tempIDPair;

    public BattleManager(Logger logger) {
        this.logger = logger;
        this.battleMap = new HashMap<Integer, Battle>();
        this.recentlyLeftBattle = new HashMap<Integer, Combatant>();
        this.battleUpdater = new BattleUpdater(this);
        this.entityToBattleMap = new HashMap<EntityIDDimPair, Integer>();
        MinecraftForge.EVENT_BUS.register((Object)this.battleUpdater);
        this.tempIDPair = new EntityIDDimPair();
    }

    public boolean checkAttack(LivingAttackEvent event) {
        Battle defenderBattle;
        String attackerCustomName;
        String attackerClassName;
        String receiverCustomName;
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        String receiverClassName = event.getEntity().getClass().getName();
        try {
            receiverCustomName = event.getEntity().m_7770_().getString();
        }
        catch (NullPointerException e) {
            receiverCustomName = null;
        }
        try {
            attackerClassName = event.getSource().m_7639_().getClass().getName();
        }
        catch (NullPointerException e) {
            attackerClassName = null;
        }
        try {
            attackerCustomName = event.getSource().m_7639_().m_7770_().getString();
        }
        catch (NullPointerException e) {
            attackerCustomName = null;
        }
        if ((!(event.getEntity() instanceof Player) || ((Player)event.getEntity()).m_7500_()) && config.getEntityInfoReference(receiverClassName) == null && config.getCustomEntityInfoReference(receiverCustomName) == null || (!(event.getSource().m_7639_() instanceof Player) || ((Player)event.getSource().m_7639_()).m_7500_()) && config.getEntityInfoReference(attackerClassName) == null && config.getCustomEntityInfoReference(attackerCustomName) == null || TurnBasedMinecraftMod.proxy.getConfig().isPlayerOnlyBattlesEnabled() && (!(event.getEntity() instanceof Player) || !(event.getSource().m_7639_() instanceof Player))) {
            return false;
        }
        EntityInfo entityInfo = config.getCustomEntityInfoReference(receiverCustomName);
        if (entityInfo == null) {
            entityInfo = config.getMatchingEntityInfo(event.getEntity());
        }
        if (entityInfo != null && (config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            Battle battle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair(event.getSource().m_7639_())));
            if (battle != null && battle.hasCombatant(event.getSource().m_7639_().m_19879_())) {
                this.logger.debug("Attack Canceled: attacked ignores battle but attacker in battle");
                return true;
            }
            this.logger.debug("Attack Not Canceled: attacked ignores battle");
            return false;
        }
        entityInfo = config.getCustomEntityInfoReference(attackerCustomName);
        if (entityInfo == null) {
            entityInfo = config.getMatchingEntityInfo(event.getSource().m_7639_());
        }
        if (entityInfo != null && (config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            Battle battle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair((Entity)event.getEntity())));
            if (battle != null && battle.hasCombatant(event.getEntity().m_19879_())) {
                this.logger.debug("Attack Canceled: attacker ignores battle but attacked in battle");
                return true;
            }
            this.logger.debug("Attack Not Canceled: attacker ignores battle");
            return false;
        }
        Battle attackerBattle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair(event.getSource().m_7639_())));
        if (attackerBattle != null && !attackerBattle.hasCombatant(event.getSource().m_7639_().m_19879_())) {
            attackerBattle = null;
        }
        if ((defenderBattle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair((Entity)event.getEntity())))) != null && !defenderBattle.hasCombatant(event.getEntity().m_19879_())) {
            defenderBattle = null;
        }
        if (attackerBattle != null && defenderBattle != null) {
            return true;
        }
        if (attackerBattle == null && defenderBattle == null) {
            if (event.getEntity() instanceof Player || event.getSource().m_7639_() instanceof Player) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add((Entity)event.getEntity());
                sideB.add(event.getSource().m_7639_());
                this.createBattle(sideA, sideB, (ResourceKey<Level>)event.getEntity().f_19853_.m_46472_());
                this.logger.debug("Attack Not Canceled: new battle created");
            } else {
                this.logger.debug("Attack Not Canceled: neither are in battle or players");
            }
            return false;
        }
        if (attackerBattle != null) {
            if (attackerBattle.getSize() >= config.getMaxInBattle()) {
                return true;
            }
            if (attackerBattle.hasCombatantInSideA(event.getSource().m_7639_().m_19879_())) {
                attackerBattle.addCombatantToSideB((Entity)event.getEntity());
            } else {
                attackerBattle.addCombatantToSideA((Entity)event.getEntity());
            }
            this.entityToBattleMap.put(new EntityIDDimPair((Entity)event.getEntity()), attackerBattle.getId());
        } else {
            if (defenderBattle.getSize() >= config.getMaxInBattle()) {
                return true;
            }
            if (defenderBattle.hasCombatantInSideA(event.getEntity().m_19879_())) {
                defenderBattle.addCombatantToSideB(event.getSource().m_7639_());
            } else {
                defenderBattle.addCombatantToSideA(event.getSource().m_7639_());
            }
            this.entityToBattleMap.put(new EntityIDDimPair(event.getSource().m_7639_()), defenderBattle.getId());
        }
        this.logger.debug("Attack Canceled: one is in battle");
        return true;
    }

    public void checkTargeted(LivingSetAttackTargetEvent event) {
        Battle defenderBattle;
        EntityInfo targetedInfo;
        String attackerCustomName;
        String targetedCustomName;
        if (!(!TurnBasedMinecraftMod.proxy.getConfig().isPlayerOnlyBattlesEnabled() || event.getEntity() instanceof Player && event.getTarget() instanceof Player)) {
            return;
        }
        try {
            targetedCustomName = event.getTarget().m_7770_().getString();
        }
        catch (NullPointerException e) {
            targetedCustomName = null;
        }
        try {
            attackerCustomName = event.getEntity().m_7770_().getString();
        }
        catch (NullPointerException e) {
            attackerCustomName = null;
        }
        EntityInfo attackerInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(attackerCustomName);
        if (attackerInfo == null) {
            attackerInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getEntity());
        }
        if (event.getTarget() instanceof Player) {
            targetedInfo = null;
        } else {
            targetedInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(targetedCustomName);
            if (targetedInfo == null) {
                targetedInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getTarget());
            }
        }
        if (event.getTarget() instanceof Player && ((Player)event.getTarget()).m_7500_() || attackerInfo == null || attackerInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(attackerInfo.category) || targetedInfo != null && (targetedInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(targetedInfo.category))) {
            return;
        }
        Battle attackerBattle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair((Entity)event.getEntity())));
        if (attackerBattle != null && !attackerBattle.hasCombatant(event.getEntity().m_19879_())) {
            attackerBattle = null;
        }
        if ((defenderBattle = this.battleMap.get(this.entityToBattleMap.get(new EntityIDDimPair((Entity)event.getTarget())))) != null && !defenderBattle.hasCombatant(event.getTarget().m_19879_())) {
            defenderBattle = null;
        }
        if (attackerBattle != null && defenderBattle != null) {
            return;
        }
        if (attackerBattle == null && defenderBattle == null) {
            if (event.getEntity() instanceof Player || event.getTarget() instanceof Player) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add((Entity)event.getEntity());
                sideB.add((Entity)event.getTarget());
                this.createBattle(sideA, sideB, (ResourceKey<Level>)event.getEntity().f_19853_.m_46472_());
                this.logger.debug("neither in battle, at least one is player, creating new battle");
            }
        } else if (attackerBattle != null) {
            if (attackerBattle.getSize() >= TurnBasedMinecraftMod.proxy.getConfig().getMaxInBattle()) {
                return;
            }
            if (attackerBattle.hasCombatantInSideA(event.getEntity().m_19879_())) {
                attackerBattle.addCombatantToSideB((Entity)event.getTarget());
            } else {
                attackerBattle.addCombatantToSideA((Entity)event.getTarget());
            }
            this.entityToBattleMap.put(new EntityIDDimPair((Entity)event.getTarget()), attackerBattle.getId());
        } else {
            if (defenderBattle.getSize() >= TurnBasedMinecraftMod.proxy.getConfig().getMaxInBattle()) {
                return;
            }
            if (defenderBattle.hasCombatantInSideA(event.getTarget().m_19879_())) {
                defenderBattle.addCombatantToSideB((Entity)event.getEntity());
            } else {
                defenderBattle.addCombatantToSideA((Entity)event.getEntity());
            }
            this.entityToBattleMap.put(new EntityIDDimPair((Entity)event.getEntity()), defenderBattle.getId());
        }
    }

    private Battle createBattle(Collection<Entity> sideA, Collection<Entity> sideB, ResourceKey<Level> dimension) {
        Battle newBattle = null;
        while (this.battleMap.containsKey(this.IDCounter)) {
            ++this.IDCounter;
        }
        newBattle = new Battle(this, this.IDCounter, sideA, sideB, true, dimension);
        this.battleMap.put(this.IDCounter, newBattle);
        for (Entity e : sideA) {
            this.entityToBattleMap.put(new EntityIDDimPair(e), newBattle.getId());
        }
        for (Entity e : sideB) {
            this.entityToBattleMap.put(new EntityIDDimPair(e), newBattle.getId());
        }
        newBattle.notifyPlayersBattleInfo();
        return newBattle;
    }

    public Battle getBattleByID(int id) {
        return this.battleMap.get(id);
    }

    public void cleanup() {
        this.battleUpdater.setRunning(false);
        MinecraftForge.EVENT_BUS.unregister((Object)this.battleUpdater);
        this.battleMap.clear();
        this.battleUpdater = null;
    }

    protected void addRecentlyLeftBattle(Combatant c) {
        c.time = System.nanoTime();
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        if (c.entity instanceof ServerPlayer) {
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)c.entity), (Object)new PacketGeneralMessage("You just left battle! " + config.getLeaveBattleCooldownSeconds() + " seconds until you can attack/be-attacked again!"));
        }
        this.recentlyLeftBattle.put(c.entity.m_19879_(), c);
        this.entityToBattleMap.remove(new EntityIDDimPair(c.entity));
    }

    protected void updateRecentlyLeftBattle() {
        long current = System.nanoTime();
        Iterator<Map.Entry<Integer, Combatant>> iter = this.recentlyLeftBattle.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Combatant> entry = iter.next();
            if (entry.getValue().entity instanceof Creeper && TurnBasedMinecraftMod.proxy.getConfig().getCreeperStopExplodeOnLeaveBattle()) {
                ((Creeper)entry.getValue().entity).m_32283_(-10);
            }
            if (current - entry.getValue().time <= TurnBasedMinecraftMod.proxy.getConfig().getLeaveBattleCooldownNanos()) continue;
            iter.remove();
            if (!(entry.getValue().entity instanceof ServerPlayer)) continue;
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)((Combatant)entry.getValue()).entity), (Object)new PacketGeneralMessage("Timer ended, you can now attack/be-attacked again."));
        }
    }

    public boolean isRecentlyLeftBattle(int entityID) {
        return this.recentlyLeftBattle.containsKey(entityID);
    }

    public boolean forceLeaveBattle(EntityIDDimPair entityInfo) {
        boolean result = false;
        Integer battleID = this.entityToBattleMap.get(entityInfo);
        if (battleID != null) {
            Battle battle = this.battleMap.get(battleID);
            if (battle != null && battle.hasCombatant(entityInfo.id)) {
                battle.forceRemoveCombatant(entityInfo);
                result = true;
            }
            this.entityToBattleMap.remove(entityInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInBattle(Entity entity) {
        EntityIDDimPair entityIDDimPair = this.tempIDPair;
        synchronized (entityIDDimPair) {
            this.tempIDPair.id = entity.m_19879_();
            this.tempIDPair.dim = entity.f_19853_.m_46472_();
            return this.entityToBattleMap.keySet().contains(this.tempIDPair);
        }
    }
}

