/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.client.ClientProxy;
import com.burnedkirby.TurnBasedMinecraft.common.AttackEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.DimensionChangedHandler;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.HurtEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.PlayerJoinEventHandler;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="com_burnedkirby_turnbasedminecraft")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com_burnedkirby_turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "1.21.4";
    public static final String CONFIG_FILENAME = "TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILENAME = "TBM_Config_DEFAULT.toml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.toml";
    public static final String DEFAULT_CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config_DEFAULT.toml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/com_burnedkirby_turnbasedminecraft/TBM_Config.toml";
    public static final String MUSIC_ROOT = "config/TurnBasedMinecraft/Music/";
    public static final String MUSIC_SILLY = "config/TurnBasedMinecraft/Music/silly/";
    public static final String MUSIC_BATTLE = "config/TurnBasedMinecraft/Music/battle/";
    private static final String PROTOCOL_VERSION = Integer.toString(2);
    private static final ResourceLocation HANDLER_ID = new ResourceLocation("com_burnedkirby_turnbasedminecraft", "main_channel");
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HANDLER_ID).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    protected static Logger logger = LogManager.getLogger();
    public static CommonProxy proxy;

    public static ResourceLocation getNetResourceLocation() {
        return HANDLER_ID;
    }

    public static SimpleChannel getHandler() {
        return HANDLER;
    }

    public TurnBasedMinecraftMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::firstInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::secondInitServer);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void firstInit(FMLCommonSetupEvent event) {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        proxy.setLogger(logger);
        proxy.initialize();
        int packetHandlerID = 0;
        HANDLER.registerMessage(packetHandlerID++, PacketBattleInfo.class, PacketBattleInfo::encode, PacketBattleInfo::decode, PacketBattleInfo::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleRequestInfo.class, PacketBattleRequestInfo::encode, PacketBattleRequestInfo::decode, PacketBattleRequestInfo::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleDecision.class, PacketBattleDecision::encode, PacketBattleDecision::decode, PacketBattleDecision::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketBattleMessage.class, PacketBattleMessage::encode, PacketBattleMessage::decode, PacketBattleMessage::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketGeneralMessage.class, PacketGeneralMessage::encode, PacketGeneralMessage::decode, PacketGeneralMessage::handle);
        HANDLER.registerMessage(packetHandlerID++, PacketEditingMessage.class, PacketEditingMessage::encode, PacketEditingMessage::decode, PacketEditingMessage::handle);
        MinecraftForge.EVENT_BUS.register((Object)new AttackEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DimensionChangedHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HurtEventHandler());
        logger.debug("Init com_burnedkirby_turnbasedminecraft");
    }

    private void secondInitClient(FMLClientSetupEvent event) {
        proxy.postInit();
    }

    private void secondInitServer(FMLDedicatedServerSetupEvent event) {
        proxy.postInit();
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        logger.debug("About to initialize BattleManager");
        if (proxy.initializeBattleManager()) {
            logger.debug("Initialized BattleManager");
        }
        proxy.getConfig().clearBattleIgnoringPlayers();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-disable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.m_6761_(2))).executes(c -> {
            proxy.getConfig().addBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).m_81375_().m_19879_());
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Disabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-disable-all").requires(c -> c.m_6761_(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(true);
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_()) {
                proxy.getConfig().addBattleIgnoringPlayer(player.m_19879_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-enable").requires(c -> !proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf() || c.m_6761_(2))).executes(c -> {
            proxy.getConfig().removeBattleIgnoringPlayer(((CommandSourceStack)c.getSource()).m_81375_().m_19879_());
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Enabled turn-based-combat for current player"), true);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-enable-all").requires(c -> c.m_6761_(2))).executes(c -> {
            proxy.getConfig().setBattleDisabledForAll(false);
            proxy.getConfig().clearBattleIgnoringPlayers();
            for (ServerPlayer player : ((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_()) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for everyone"));
            }
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-set-enable").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)c, (String)"targets")) {
                proxy.getConfig().addBattleIgnoringPlayer(player.m_19879_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP enabled turn-based-combat for you"));
                ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Enabled turn-based-combat for " + player.m_5446_().getString())), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-set-disable").requires(c -> c.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> {
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)c, (String)"targets")) {
                proxy.getConfig().removeBattleIgnoringPlayer(player.m_19879_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("OP disabled turn-based-combat for you"));
                ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Disabled turn-based-combat for " + player.m_5446_().getString())), true);
            }
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-edit").requires(c -> c.m_6761_(2))).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((Player)player);
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing TBM Entity for player \"" + player.m_5446_().getString() + "\" (\"" + ((CommandSourceStack)c.getSource()).m_81357_() + "\")");
            }
            return 1;
        })).then(Commands.m_82127_((String)"finish").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                if (!proxy.getConfig().editEntityEntry(editingInfo.entityInfo)) {
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("An error occurred while attempting to save an entry to the config"));
                    proxy.removeEditingInfo(player.m_19879_());
                } else {
                    proxy.removeEditingInfo(player.m_19879_());
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Entity info saved in config and loaded."));
                }
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"cancel").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null) {
                proxy.removeEditingInfo(player.m_19879_());
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketGeneralMessage("Cancelled editing entry."));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"custom").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                LiteralMessage exceptionMessage = new LiteralMessage("Invalid action for tbm-edit");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                proxy.setEditingPlayer((Player)player);
                TurnBasedMinecraftMod.proxy.getEditingInfo((int)player.m_19879_()).isEditingCustomName = true;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
                logger.info("Begin editing custom TBM Entity for player \"" + player.m_5446_().getString() + "\" (\"" + ((CommandSourceStack)c.getSource()).m_81357_() + "\")");
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ignoreBattle").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_IGNORE_BATTLE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"ignoreBattle", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            boolean ignoreBattle = BoolArgumentType.getBool((CommandContext)c, (String)"ignoreBattle");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.ignoreBattle = ignoreBattle;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackPower").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_POWER));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackPower", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int attackPower = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackPower");
            if (attackPower < 0) {
                attackPower = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackPower = attackPower;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int attackProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackProbability");
            if (attackProbability < 0) {
                attackProbability = 0;
            } else if (attackProbability > 100) {
                attackProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackProbability = attackProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackVariance").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_VARIANCE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackVariance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int attackVariance = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackVariance");
            if (attackVariance < 0) {
                attackVariance = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackVariance = attackVariance;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackEffect").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackEffect", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            EntityInfo.Effect effect = EntityInfo.Effect.fromString(StringArgumentType.getString((CommandContext)c, (String)"attackEffect"));
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffect = effect;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"attackEffectProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_ATTACK_EFFECT_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"attackEffectProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int attackEffectProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"attackEffectProbability");
            if (attackEffectProbability < 0) {
                attackEffectProbability = 0;
            } else if (attackEffectProbability > 100) {
                attackEffectProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.attackEffectProbability = attackEffectProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defenseDamage").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"defenseDamage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int defenseDamage = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamage");
            if (defenseDamage < 0) {
                defenseDamage = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamage = defenseDamage;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defenseDamageProbability").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DEFENSE_DAMAGE_PROBABILITY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"defenseDamageProbability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int defenseDamageProbability = IntegerArgumentType.getInteger((CommandContext)c, (String)"defenseDamageProbability");
            if (defenseDamageProbability < 0) {
                defenseDamageProbability = 0;
            } else if (defenseDamageProbability > 100) {
                defenseDamageProbability = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.defenseDamageProbability = defenseDamageProbability;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"evasion").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_EVASION));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            if (evasion < 0) {
                evasion = 0;
            } else if (evasion > 100) {
                evasion = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.evasion = evasion;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"speed").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_SPEED));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            if (speed < 0) {
                speed = 0;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.speed = speed;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"category").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_CATEGORY));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"category", (ArgumentType)StringArgumentType.word()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.category = category;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionAttack").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_ATTACK));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionAttack", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int decisionAttack = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionAttack");
            if (decisionAttack < 0) {
                decisionAttack = 0;
            } else if (decisionAttack > 100) {
                decisionAttack = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionAttack = decisionAttack;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionDefend").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_DEFEND));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionDefend", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int decisionDefend = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionDefend");
            if (decisionDefend < 0) {
                decisionDefend = 0;
            } else if (decisionDefend > 100) {
                decisionDefend = 100;
            }
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionDefend = decisionDefend;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decisionFlee").executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.EDIT_DECISION_FLEE));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })).then(Commands.m_82129_((String)"decisionFlee", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            EditingInfo editingInfo = proxy.getEditingInfo(player.m_19879_());
            int decisionFlee = IntegerArgumentType.getInteger((CommandContext)c, (String)"decisionFlee");
            if (editingInfo != null && !editingInfo.isPendingEntitySelection) {
                editingInfo.entityInfo.decisionFlee = decisionFlee;
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else if (editingInfo != null) {
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.ATTACK_ENTITY));
            } else {
                LiteralMessage exceptionMessage = new LiteralMessage("Cannot edit entity without starting editing (use \"/tbm-edit\").");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)exceptionMessage), (Message)exceptionMessage);
            }
            return 1;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbm-server-edit").requires(c -> c.m_6761_(2))).executes(c -> {
            ServerPlayer player = ((CommandSourceStack)c.getSource()).m_81375_();
            TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketEditingMessage(PacketEditingMessage.Type.SERVER_EDIT));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"leave_battle_cooldown").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"leave_battle_cooldown requires an integer argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"leave_battle_cooldown is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(proxy.getConfig().getLeaveBattleCooldownSeconds()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"cooldown_seconds", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int cooldown = IntegerArgumentType.getInteger((CommandContext)c, (String)"cooldown_seconds");
            proxy.getConfig().setLeaveBattleCooldownSeconds(cooldown);
            cooldown = proxy.getConfig().getLeaveBattleCooldownSeconds();
            if (!proxy.getConfig().updateConfig("server_config.leave_battle_cooldown", cooldown)) {
                logger.warn("Failed to set \"server_config.leave_battle_cooldown\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set leave_battle_cooldown to \"" + cooldown + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set leave_battle_cooldown to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(cooldown));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"aggro_start_battle_max_distance").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"aggro_start_battle_max_distance requires an integer argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"aggro_start_battle_max_distance is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(proxy.getConfig().getAggroStartBattleDistance()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"aggro_distance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int distance = IntegerArgumentType.getInteger((CommandContext)c, (String)"aggro_distance");
            proxy.getConfig().setAggroStartBattleDistance(distance);
            distance = proxy.getConfig().getAggroStartBattleDistance();
            if (!proxy.getConfig().updateConfig("server_config.aggro_start_battle_max_distance", distance)) {
                logger.warn("Failed to set \"server_config.aggro_start_battle_max_distance\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set aggro_start_battle_max_distance to \"" + distance + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set aggro_start_battle_max_distance to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(distance));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"old_battle_behavior").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"old_battle_behavior requires a boolean argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"old_battle_behavior is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(proxy.getConfig().isOldBattleBehaviorEnabled()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"old_battle_behavior_enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"old_battle_behavior_enabled");
            proxy.getConfig().setOldBattleBehavior(enabled);
            if (!proxy.getConfig().updateConfig("server_config.old_battle_behavior", enabled)) {
                logger.warn("Failed to set \"server_config.old_battle_behavior\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set old_battle_behavior to \"" + enabled + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set old_battle_behavior to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(enabled));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"anyone_can_disable_tbm_for_self").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"anyone_can_disable_tbm_for_self requires a boolean argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"anyone_can_disable_tbm_for_self is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(!proxy.getConfig().getIfOnlyOPsCanDisableTurnBasedForSelf()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"enabled_for_all", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled_for_all = BoolArgumentType.getBool((CommandContext)c, (String)"enabled_for_all");
            proxy.getConfig().setIfOnlyOPsCanDisableTurnBasedForSelf(!enabled_for_all);
            if (!proxy.getConfig().updateConfig("server_config.anyone_can_disable_tbm_for_self", enabled_for_all)) {
                logger.warn("Failed to set \"server_config.anyone_can_disable_tbm_for_self\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set anyone_can_disable_tbm_for_self to \"" + enabled_for_all + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set anyone_can_disable_tbm_for_self to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(enabled_for_all));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"max_in_battle").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"max_in_battle requires an integer argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"max_in_battle is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(proxy.getConfig().getMaxInBattle()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"max_amount", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int max_amount = IntegerArgumentType.getInteger((CommandContext)c, (String)"max_amount");
            proxy.getConfig().setMaxInBattle(max_amount);
            max_amount = proxy.getConfig().getMaxInBattle();
            if (!proxy.getConfig().updateConfig("server_config.max_in_battle", max_amount)) {
                logger.warn("Failed to set \"server_config.max_in_battle\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set max_in_battle to \"" + max_amount + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set max_in_battle to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(max_amount));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"freeze_battle_combatants").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"freeze_battle_combatants requires a boolean argument. ");
            MutableComponent subResponse = Component.m_237113_((String)"freeze_battle_combatants is currently: ");
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)String.valueOf(!proxy.getConfig().isFreezeCombatantsEnabled()));
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
            response.m_7360_().add(subResponse);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(Commands.m_82129_((String)"freeze_enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"freeze_enabled");
            proxy.getConfig().setFreezeCombatantsInBattle(enabled);
            if (!proxy.getConfig().updateConfig("server_config.freeze_battle_combatants", enabled)) {
                logger.warn("Failed to set \"server_config.freeze_battle_combatants\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set freeze_battle_combatants to \"" + enabled + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set freeze_battle_combatants to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(enabled));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ignore_battle_types").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"Use ");
            MutableComponent subResponse = Component.m_237113_((String)"/tbm-server-edit ignore_battle_types add/remove <category> ");
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.YELLOW));
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)"ignore_battle_types is currently: [");
            response.m_7360_().add(subResponse);
            boolean isFirst = true;
            for (String category : proxy.getConfig().getIgnoreBattleTypes()) {
                if (!isFirst) {
                    response.m_7360_().add(Component.m_237113_((String)", "));
                }
                subResponse = Component.m_237113_((String)category);
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_battle_types remove " + category)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to remove category"))));
                response.m_7360_().add(subResponse);
                isFirst = false;
            }
            response.m_7360_().add(Component.m_237113_((String)"] "));
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"/tbm-server-edit ignore_battle_types add <category>"));
            return 1;
        })).then(Commands.m_82129_((String)"category", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (proxy.getConfig().addIgnoreBattleType(category) && proxy.getConfig().updateConfigAppendToStringArray("server_config.ignore_battle_types", category)) {
                MutableComponent response = Component.m_237113_((String)"Successfully appended category \"");
                MutableComponent sub = Component.m_237113_((String)category);
                sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(sub);
                sub = Component.m_237113_((String)"\" to ignore_battle_types");
                response.m_7360_().add(sub);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to append category \"" + category + "\" to ignore_battle_types")));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"/tbm-server-edit ignore_battle_types remove <category>"));
            return 1;
        })).then(Commands.m_82129_((String)"category", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String category = StringArgumentType.getString((CommandContext)c, (String)"category");
            if (proxy.getConfig().removeIgnoreBattleType(category) && proxy.getConfig().updateConfigRemoveFromStringArray("server_config.ignore_battle_types", category)) {
                MutableComponent response = Component.m_237113_((String)"Successfully removed category \"");
                MutableComponent sub = Component.m_237113_((String)category);
                sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(sub);
                sub = Component.m_237113_((String)"\" from ignore_battle_types");
                response.m_7360_().add(sub);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to remove category \"" + category + "\" from ignore_battle_types")));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_speed").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_speed <0-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"speed");
            proxy.getConfig().setPlayerSpeed(speed);
            speed = proxy.getConfig().getPlayerSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_speed", speed)) {
                logger.warn("Failed to set \"server_config.player_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_speed to \"" + speed + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_speed to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(speed));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_haste_speed").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_haste_speed <0-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"haste_speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int haste_speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"haste_speed");
            proxy.getConfig().setPlayerHasteSpeed(haste_speed);
            haste_speed = proxy.getConfig().getPlayerHasteSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_haste_speed", haste_speed)) {
                logger.warn("Failed to set \"server_config.player_haste_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_haste_speed to \"" + haste_speed + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_haste_speed to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(haste_speed));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_slow_speed").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_slow_speed <0-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"slow_speed", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int slow_speed = IntegerArgumentType.getInteger((CommandContext)c, (String)"slow_speed");
            proxy.getConfig().setPlayerSlowSpeed(slow_speed);
            slow_speed = proxy.getConfig().getPlayerSlowSpeed();
            if (!proxy.getConfig().updateConfig("server_config.player_slow_speed", slow_speed)) {
                logger.warn("Failed to set \"server_config.player_slow_speed\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_slow_speed to \"" + slow_speed + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_slow_speed to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(slow_speed));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_attack_probability").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_attack_probability <1-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setPlayerAttackProbability(probability);
            probability = proxy.getConfig().getPlayerAttackProbability();
            if (!proxy.getConfig().updateConfig("server_config.player_attack_probability", probability)) {
                logger.warn("Failed to set \"server_config.player_attack_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_attack_probability to \"" + probability + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_attack_probability to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(probability));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_evasion").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_evasion <0-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"evasion", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int evasion = IntegerArgumentType.getInteger((CommandContext)c, (String)"evasion");
            proxy.getConfig().setPlayerEvasion(evasion);
            evasion = proxy.getConfig().getPlayerEvasion();
            if (!proxy.getConfig().updateConfig("server_config.player_evasion", evasion)) {
                logger.warn("Failed to set \"server_config.player_evasion\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_evasion to \"" + evasion + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_evasion to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(evasion));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defense_duration").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit defense_duration <0-5>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"defends", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int defends = IntegerArgumentType.getInteger((CommandContext)c, (String)"defends");
            proxy.getConfig().setDefenseDuration(defends);
            defends = proxy.getConfig().getDefenseDuration();
            if (!proxy.getConfig().updateConfig("server_config.defense_duration", defends)) {
                logger.warn("Failed to set \"server_config.defense_duration\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set defense_druation to \"" + defends + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set defense_duration to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(defends));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"flee_good_probability").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit flee_good_probability <1-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setFleeGoodProbability(probability);
            probability = proxy.getConfig().getFleeGoodProbability();
            if (!proxy.getConfig().updateConfig("server_config.flee_good_probability", probability)) {
                logger.warn("Failed to set \"server_config.flee_good_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set flee_good_probability to \"" + probability + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set flee_good_probability to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(probability));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"flee_bad_probability").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit flee_bad_probability <1-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"probability", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int probability = IntegerArgumentType.getInteger((CommandContext)c, (String)"probability");
            proxy.getConfig().setFleeBadProbability(probability);
            probability = proxy.getConfig().getFleeBadProbability();
            if (!proxy.getConfig().updateConfig("server_config.flee_bad_probability", probability)) {
                logger.warn("Failed to set \"server_config.flee_bad_probability\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set flee_bad_probability to \"" + probability + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set flee_bad_probability to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(probability));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"minimum_hit_percentage").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit minimum_hit_percentage <1-100>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"percentage", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int percentage = IntegerArgumentType.getInteger((CommandContext)c, (String)"percentage");
            proxy.getConfig().setMinimumHitPercentage(percentage);
            percentage = proxy.getConfig().getMinimumHitPercentage();
            if (!proxy.getConfig().updateConfig("server_config.minimum_hit_percentage", percentage)) {
                logger.warn("Failed to set \"server_config.minimum_hit_percentage\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set minimum_hit_percentage to \"" + percentage + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set minimum_hit_percentage to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(percentage));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"battle_turn_wait_forever").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit battle_turn_wait_forever <true/false>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)c, (String)"enabled");
            proxy.getConfig().setBattleDecisionDurationForever(enabled);
            if (!proxy.getConfig().updateConfig("server_config.battle_turn_wait_forever", enabled)) {
                logger.warn("Failed to set \"server_config.battle_turn_wait_forever\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set battle_turn_wait_forever to \"" + (enabled ? "true" : "false") + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set battle_turn_wait_forever to: ");
                MutableComponent subResponse = Component.m_237113_((String)(enabled ? "true" : "false"));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"battle_turn_time_seconds").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit battle_turn_time_seconds <5-60>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int seconds = IntegerArgumentType.getInteger((CommandContext)c, (String)"seconds");
            proxy.getConfig().setDecisionDurationSeconds(seconds);
            seconds = proxy.getConfig().getDecisionDurationSeconds();
            if (!proxy.getConfig().updateConfig("server_config.battle_turn_time_seconds", seconds)) {
                logger.warn("Failed to set \"server_config.battle_turn_time_seconds\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set battle_turn_time_seconds to \"" + seconds + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set battle_turn_time_seconds to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(seconds));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"creeper_explode_turn").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit creeper_explode_turn <1-10>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"turns", (ArgumentType)IntegerArgumentType.integer()).executes(c -> {
            int turns = IntegerArgumentType.getInteger((CommandContext)c, (String)"turns");
            proxy.getConfig().setCreeperExplodeTurn(turns);
            turns = proxy.getConfig().getCreeperExplodeTurn();
            if (!proxy.getConfig().updateConfig("server_config.creeper_explode_turn", turns)) {
                logger.warn("Failed to set \"server_config.creeper_explode_turn\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set creeper_explode_turn to \"" + turns + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set creeper_explode_turn to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(turns));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"creeper_stop_explode_on_leave_battle").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit creeper_stop_explode_on_leave_battle <true/false>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"stop_explode_on_leave", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean stop_explode_on_leave = BoolArgumentType.getBool((CommandContext)c, (String)"stop_explode_on_leave");
            proxy.getConfig().setCreeperStopExplodeOnLeaveBattle(stop_explode_on_leave);
            if (!proxy.getConfig().updateConfig("server_config.creeper_stop_explode_on_leave_battle", stop_explode_on_leave)) {
                logger.warn("Failed to set \"server_config.creeper_stop_explode_on_leave_battle\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set creeper_stop_explode_on_leave_battle to \"" + stop_explode_on_leave + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set creeper_stop_explode_on_leave_battle to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(stop_explode_on_leave));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"creeper_always_allow_damage").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit creeper_always_allow_damage <true/false>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"allow_damage", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean allow_damage = BoolArgumentType.getBool((CommandContext)c, (String)"allow_damage");
            proxy.getConfig().setCreeperAlwaysAllowDamage(allow_damage);
            if (!proxy.getConfig().updateConfig("server_config.creeper_always_allow_damage", allow_damage)) {
                logger.warn("Failed to set \"server_config.creeper_always_allow_damage\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set creeper_always_allow_damage to \"" + allow_damage + "\" in config file!")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set creeper_always_allow_damage to: ");
                MutableComponent subResponse = Component.m_237113_((String)String.valueOf(allow_damage));
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(subResponse);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ignore_damage_sources").executes(c -> {
            MutableComponent response = Component.m_237113_((String)"Use ");
            MutableComponent subResponse = Component.m_237113_((String)"/tbm-server-edit ignore_damage_sources add/remove <type> ");
            subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.YELLOW));
            response.m_7360_().add(subResponse);
            subResponse = Component.m_237113_((String)"ignore_damage_sources is currently: [");
            response.m_7360_().add(subResponse);
            boolean isFirst = true;
            for (String type : proxy.getConfig().getIgnoreHurtDamageSources()) {
                if (!isFirst) {
                    response.m_7360_().add(Component.m_237113_((String)", "));
                }
                subResponse = Component.m_237113_((String)type);
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_damage_sources remove " + type)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to remove type"))));
                response.m_7360_().add(subResponse);
                isFirst = false;
            }
            response.m_7360_().add(Component.m_237113_((String)"] "));
            subResponse = Component.m_237113_((String)"Possible Damage Sources: [");
            response.m_7360_().add(subResponse);
            isFirst = true;
            for (String type : proxy.getConfig().getPossibleIgnoreHurtDamageSources()) {
                if (!isFirst) {
                    response.m_7360_().add(Component.m_237113_((String)", "));
                }
                subResponse = Component.m_237113_((String)type);
                subResponse.m_6270_(subResponse.m_7383_().m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-server-edit ignore_damage_sources add " + type)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to add type"))));
                response.m_7360_().add(subResponse);
                isFirst = false;
            }
            response.m_7360_().add(Component.m_237113_((String)"] "));
            ((CommandSourceStack)c.getSource()).m_81354_((Component)response, false);
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"/tbm-server-edit ignore_damage_sources add <type>"));
            return 1;
        })).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String type = StringArgumentType.getString((CommandContext)c, (String)"type");
            if (proxy.getConfig().addIgnoreHurtDamageSource(type) && proxy.getConfig().updateConfigAppendToStringArray("server_config.ignore_damage_sources", type)) {
                MutableComponent response = Component.m_237113_((String)"Successfully appended Damage Source type \"");
                MutableComponent sub = Component.m_237113_((String)type);
                sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(sub);
                sub = Component.m_237113_((String)"\" to ignore_damage_sources");
                response.m_7360_().add(sub);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to append type \"" + type + "\" to ignore_damage_sources")));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)"/tbm-server-edit ignore_damage_sources remove <type>"));
            return 1;
        })).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
            String type = StringArgumentType.getString((CommandContext)c, (String)"type");
            if (proxy.getConfig().removeIgnoreHurtDamageSource(type) && proxy.getConfig().updateConfigRemoveFromStringArray("server_config.ignore_damage_sources", type)) {
                MutableComponent response = Component.m_237113_((String)"Successfully removed category \"");
                MutableComponent sub = Component.m_237113_((String)type);
                sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(sub);
                sub = Component.m_237113_((String)"\" from ignore_damage_sources");
                response.m_7360_().add(sub);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
                return 1;
            }
            ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to remove type \"" + type + "\" from ignore_damage_sources")));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"player_only_battles").executes(c -> {
            MutableComponent parent = Component.m_237113_((String)"Use ");
            MutableComponent sub = Component.m_237113_((String)"/tbm-server-edit player_only_battles <true/false>");
            sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.YELLOW));
            parent.m_7360_().add(sub);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)parent, false);
            return 1;
        })).then(Commands.m_82129_((String)"player_only_battles", (ArgumentType)BoolArgumentType.bool()).executes(c -> {
            boolean player_only_battles = BoolArgumentType.getBool((CommandContext)c, (String)"player_only_battles");
            proxy.getConfig().setIsPlayerOnlyBattles(player_only_battles);
            if (!proxy.getConfig().updateConfig("server_config.player_only_battles", player_only_battles)) {
                logger.warn("Failed to set \"server_config.player_only_battles\" in config file!");
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to set player_only_battles to \"" + player_only_battles + "\" in config file")));
            } else {
                MutableComponent response = Component.m_237113_((String)"Successfully set player_only_battles to: ");
                MutableComponent sub = Component.m_237113_((String)String.valueOf(player_only_battles));
                sub.m_6270_(sub.m_7383_().m_131140_(ChatFormatting.GREEN));
                response.m_7360_().add(sub);
                ((CommandSourceStack)c.getSource()).m_81354_((Component)response, true);
            }
            return 1;
        }))));
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent ignoredEvent) {
        logger.debug("About to cleanup BattleManager");
        if (proxy.cleanupBattleManager()) {
            logger.debug("Cleaned up BattleManager");
        }
    }
}

