/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketBattleMessage {
    MessageType messageType;
    int entityIDFrom;
    int entityIDTo;
    int amount;
    String custom;
    ResourceKey<Level> dimension;

    public MessageType getMessageType() {
        return this.messageType;
    }

    public int getEntityIDFrom() {
        return this.entityIDFrom;
    }

    public int getEntityIDTo() {
        return this.entityIDTo;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getCustom() {
        return this.custom;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public PacketBattleMessage() {
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, ResourceKey<Level> dimension, int amount) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = new String();
    }

    public PacketBattleMessage(MessageType messageType, int entityIDFrom, int entityIDTo, ResourceKey<Level> dimension, int amount, String custom) {
        this.messageType = messageType;
        this.entityIDFrom = entityIDFrom;
        this.entityIDTo = entityIDTo;
        this.dimension = dimension;
        this.amount = amount;
        this.custom = custom;
    }

    public static void encode(PacketBattleMessage pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.messageType.getValue());
        buf.writeInt(pkt.entityIDFrom);
        buf.writeInt(pkt.entityIDTo);
        buf.m_130070_(Utility.serializeDimension(pkt.dimension));
        buf.writeInt(pkt.amount);
        buf.m_130070_(pkt.custom);
    }

    public static PacketBattleMessage decode(FriendlyByteBuf buf) {
        return new PacketBattleMessage(MessageType.valueOf(buf.readInt()), buf.readInt(), buf.readInt(), Utility.deserializeDimension(buf.m_130277_()), buf.readInt(), buf.m_130277_());
    }

    public static void handle(PacketBattleMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PacketBattleMessage.lambda$handle$1(pkt, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(PacketBattleMessage pkt, Supplier ctx) {
        return () -> PacketBattleMessage.lambda$handle$0(pkt, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(PacketBattleMessage pkt, Supplier ctx) {
        TurnBasedMinecraftMod.proxy.handlePacket(pkt, ctx);
    }

    public static enum MessageType {
        ENTERED(0),
        FLEE(1),
        DIED(2),
        ENDED(3),
        ATTACK(4),
        DEFEND(5),
        DEFENSE_DAMAGE(6),
        MISS(7),
        DEFENDING(8),
        DID_NOTHING(9),
        USED_ITEM(10),
        TURN_BEGIN(11),
        TURN_END(12),
        SWITCHED_ITEM(13),
        WAS_AFFECTED(14),
        BECAME_CREATIVE(15),
        FIRED_ARROW(16),
        ARROW_HIT(17),
        BOW_NO_AMMO(18),
        CREEPER_WAIT(19),
        CREEPER_WAIT_FINAL(20),
        CREEPER_EXPLODE(21);

        private int value;
        private static Map<Integer, MessageType> map;

        private MessageType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageType valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MessageType>();
            for (MessageType type : MessageType.values()) {
                map.put(type.getValue(), type);
            }
        }
    }

    public static enum UsedItemAction {
        USED_NOTHING(0),
        USED_INVALID(1),
        USED_FOOD(2),
        USED_POTION(3);

        private int value;
        private static Map<Integer, UsedItemAction> map;

        private UsedItemAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UsedItemAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, UsedItemAction>();
            for (UsedItemAction type : UsedItemAction.values()) {
                map.put(type.getValue(), type);
            }
        }
    }
}

