/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import com.burnedkirby.TurnBasedMinecraft.common.AttackerViaBow;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.BattleManager;
import com.burnedkirby.TurnBasedMinecraft.common.CommonProxy;
import com.burnedkirby.TurnBasedMinecraft.common.Config;
import com.burnedkirby.TurnBasedMinecraft.common.EditingInfo;
import com.burnedkirby.TurnBasedMinecraft.common.EntityInfo;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.Utility;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttackerValid(LivingAttackEvent event) {
        if (event.getSource().m_7639_() == null) {
            return false;
        }
        if (event.getSource().m_7639_().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            Iterator<AttackerViaBow> iter = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().iterator();
            while (iter.hasNext()) {
                AttackerViaBow attacker = iter.next();
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    iter.remove();
                    continue;
                }
                if (!event.getSource().m_7639_().equals((Object)attacker.entity) || !event.getSource().m_19360_()) continue;
                iter.remove();
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.m_19879_(), event.getEntity().m_19879_(), 0);
                }
                isValid = true;
            }
        }
        return isValid;
    }

    @SubscribeEvent
    public void entityAttacked(LivingAttackEvent event) {
        EditingInfo editingInfo;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        CommonProxy proxy = TurnBasedMinecraftMod.proxy;
        Config config = proxy.getConfig();
        BattleManager battleManager = proxy.getBattleManager();
        if (event.getSource().m_7639_() != null && event.getEntity() != null && (editingInfo = proxy.getEditingInfo(event.getSource().m_7639_().m_19879_())) != null && editingInfo.isPendingEntitySelection) {
            editingInfo.isPendingEntitySelection = false;
            event.setCanceled(true);
            if (editingInfo.isEditingCustomName) {
                if (!event.getEntity().m_8077_()) {
                    TurnBasedMinecraftMod.logger.error("Cannot edit custom name from entity without custom name");
                    TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)editingInfo.editor), (Object)new PacketGeneralMessage("Cannot edit custom name from entity without custom name"));
                    return;
                }
                editingInfo.entityInfo = config.getCustomEntityInfo(event.getEntity().m_7770_().getString());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.customName = event.getEntity().m_7770_().getString();
                }
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)editingInfo.editor), (Object)new PacketGeneralMessage("Editing custom name \"" + event.getEntity().m_7770_().getString() + "\""));
                TurnBasedMinecraftMod.logger.info("Begin editing custom \"" + event.getEntity().m_7770_().getString() + "\"");
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)editingInfo.editor), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            } else {
                editingInfo.entityInfo = config.getMatchingEntityInfo(event.getEntity());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.classType = event.getEntity().getClass();
                } else {
                    editingInfo.entityInfo = editingInfo.entityInfo.clone();
                }
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)editingInfo.editor), (Object)new PacketGeneralMessage("Editing entity \"" + editingInfo.entityInfo.classType.getName() + "\""));
                TurnBasedMinecraftMod.logger.info("Begin editing \"" + editingInfo.entityInfo.classType.getName() + "\"");
                TurnBasedMinecraftMod.getHandler().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)editingInfo.editor), (Object)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo));
            }
            return;
        }
        if (event.getEntity() != null && event.getSource().m_7639_() != null && (battleManager.isRecentlyLeftBattle(event.getEntity().m_19879_()) || battleManager.isRecentlyLeftBattle(event.getSource().m_7639_().m_19879_()))) {
            if (event.getSource().m_7639_() instanceof Creeper && TurnBasedMinecraftMod.proxy.getConfig().getCreeperAlwaysAllowDamage()) {
                event.setCanceled(false);
            } else {
                event.setCanceled(true);
            }
            return;
        }
        if (!this.isAttackerValid(event) && event.getEntity() != null && event.getSource().m_7639_() != null && event.getEntity() != event.getSource().m_7639_() && !config.getBattleIgnoringPlayers().contains(event.getSource().m_7639_().m_19879_()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().m_19879_()) && event.getEntity().f_19853_.m_46472_().equals((Object)event.getSource().m_7639_().f_19853_.m_46472_()) && battleManager.checkAttack(event)) {
            event.setCanceled(true);
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
    }

    @SubscribeEvent
    public void entityTargeted(LivingChangeTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().f_19853_.f_46443_ || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().m_19879_()) || event.getNewTarget() != null && battleManager.isRecentlyLeftBattle(event.getNewTarget().m_19879_()) || event.getEntity() != null && event.getNewTarget() != null && Utility.distanceBetweenEntities((Entity)event.getEntity(), (Entity)event.getNewTarget()) > (double)config.getAggroStartBattleDistance()) {
            return;
        }
        if (event.getEntity() != null && event.getNewTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().m_19879_()) && !config.getBattleIgnoringPlayers().contains(event.getNewTarget().m_19879_()) && event.getEntity().f_19853_.m_46472_().equals((Object)event.getNewTarget().f_19853_.m_46472_())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

