/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.level.Level;

public class Utility {
    public static float yawDirection(double posX, double posZ, double targetX, double targetZ) {
        double radians = Math.atan2(targetZ - posZ, targetX - posX);
        if ((radians -= 1.5707963267948966) < 0.0) {
            radians += Math.PI * 2;
        }
        return (float)(radians * 180.0 / Math.PI);
    }

    public static float pitchDirection(double posX, double posY, double posZ, double targetX, double targetY, double targetZ) {
        double diffX = targetX - posX;
        double diffY = targetY - posY;
        double diffZ = targetZ - posZ;
        double distance = Math.sqrt(diffX * diffX + diffZ * diffZ);
        if (Math.abs(diffY) < 0.1) {
            return 0.0f;
        }
        return (float)(-Math.atan(diffY / distance) * 180.0 / Math.PI);
    }

    public static boolean doesPlayerHaveArrows(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof ArrowItem)) continue;
            return true;
        }
        return false;
    }

    public static double distanceBetweenEntities(Entity a, Entity b) {
        return Math.sqrt(Math.pow(a.m_20185_() - b.m_20185_(), 2.0) + Math.pow(a.m_20186_() - b.m_20186_(), 2.0) + Math.pow(a.m_20189_() - b.m_20189_(), 2.0));
    }

    public static String serializeDimension(ResourceKey<Level> dimObject) {
        return dimObject.m_211136_().toString();
    }

    public static ResourceKey<Level> deserializeDimension(String dimString) {
        ResourceLocation dimRes = new ResourceLocation(dimString);
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimRes);
    }
}

