/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.AttackerViaBow;
import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleManager;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import java.util.ArrayDeque;
import java.util.Set;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttackerValid(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() == null) {
            return false;
        }
        if (event.getSource().func_76346_g().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        ArrayDeque<AttackerViaBow> removeQueue = new ArrayDeque<AttackerViaBow>();
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            for (AttackerViaBow attacker : TurnBasedMinecraftMod.proxy.getAttackerViaBowSet()) {
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    removeQueue.add(attacker);
                    continue;
                }
                if (!event.getSource().func_76346_g().equals((Object)attacker.entity) || !event.getSource().func_76352_a()) continue;
                removeQueue.add(attacker);
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.func_145782_y(), event.getEntity().func_145782_y(), 0);
                }
                isValid = true;
            }
            AttackerViaBow next = (AttackerViaBow)removeQueue.poll();
            while (next != null) {
                TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().remove(next);
                next = (AttackerViaBow)removeQueue.poll();
            }
        }
        return isValid;
    }

    @SubscribeEvent
    public void entityAttacked(LivingAttackEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || event.getSource().func_76346_g() != null && battleManager.isRecentlyLeftBattle(event.getSource().func_76346_g().func_145782_y())) {
            event.setCanceled(true);
            return;
        }
        if (!this.isAttackerValid(event) && event.getEntity() != null && event.getSource().func_76346_g() != null && !config.getBattleIgnoringPlayers().contains(event.getSource().func_76346_g().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && battleManager.checkAttack(event)) {
            event.setCanceled(true);
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
    }

    @SubscribeEvent
    public void entityTargeted(LivingSetAttackTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().field_70170_p.field_72995_K || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || event.getTarget() != null && battleManager.isRecentlyLeftBattle(event.getTarget().func_145782_y())) {
            return;
        }
        if (event.getEntity() != null && event.getTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getTarget().func_145782_y())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

