/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.AttackerViaBow;
import com.seodisparate.TurnBasedMinecraft.common.BattleManager;
import com.seodisparate.TurnBasedMinecraft.common.Combatant;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.Utility;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Battle {
    private final int id;
    private Map<Integer, Combatant> sideA;
    private Map<Integer, Combatant> sideB;
    private Map<Integer, Combatant> players;
    private PriorityQueue<Combatant> turnOrderQueue;
    private Queue<Combatant> sideAEntryQueue;
    private Queue<Combatant> sideBEntryQueue;
    private State state;
    private AtomicInteger playerCount;
    private AtomicInteger undecidedCount;
    private long lastInstant;
    private long timer;
    private boolean isServer;
    private boolean battleEnded;
    private BattleManager battleManager;

    public Battle(BattleManager battleManager, int id, Collection<Entity> sideA, Collection<Entity> sideB, boolean isServer) {
        Combatant newCombatant;
        EntityInfo entityInfo;
        this.battleManager = battleManager;
        this.isServer = isServer;
        this.id = id;
        this.sideA = new Hashtable<Integer, Combatant>();
        this.sideB = new Hashtable<Integer, Combatant>();
        this.players = new Hashtable<Integer, Combatant>();
        this.turnOrderQueue = new PriorityQueue<Combatant>(new Combatant.CombatantComparator());
        this.sideAEntryQueue = new ArrayDeque<Combatant>();
        this.sideBEntryQueue = new ArrayDeque<Combatant>();
        this.playerCount = new AtomicInteger(0);
        this.undecidedCount = new AtomicInteger(0);
        if (sideA != null) {
            for (Entity e : sideA) {
                entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                if (entityInfo == null && !(e instanceof EntityPlayer) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = true;
                newCombatant.battleID = this.getId();
                this.sideA.put(e.func_145782_y(), newCombatant);
                if (e instanceof EntityPlayer) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.func_145782_y(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.field_70165_t;
                newCombatant.z = e.field_70161_v;
                newCombatant.yaw = e.field_70177_z;
                newCombatant.pitch = e.field_70125_A;
            }
        }
        if (sideB != null) {
            for (Entity e : sideB) {
                entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
                if (entityInfo == null && !(e instanceof EntityPlayer) && TurnBasedMinecraftMod.proxy.isServerRunning()) continue;
                newCombatant = new Combatant(e, entityInfo);
                newCombatant.isSideA = false;
                newCombatant.battleID = this.getId();
                this.sideB.put(e.func_145782_y(), newCombatant);
                if (e instanceof EntityPlayer) {
                    newCombatant.recalcSpeedOnCompare = true;
                    this.playerCount.incrementAndGet();
                    this.players.put(e.func_145782_y(), newCombatant);
                }
                if (!TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) continue;
                newCombatant.x = e.field_70165_t;
                newCombatant.z = e.field_70161_v;
                newCombatant.yaw = e.field_70177_z;
                newCombatant.pitch = e.field_70125_A;
            }
        }
        for (Combatant c : this.sideA.values()) {
            if (c.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id, c.entityInfo.category);
                continue;
            }
            if (c.entity instanceof EntityPlayer) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id, "player");
                continue;
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id);
        }
        for (Combatant c : this.sideB.values()) {
            if (c.entityInfo != null) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id, c.entityInfo.category);
                continue;
            }
            if (c.entity instanceof EntityPlayer) {
                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id, "player");
                continue;
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, c.entity.func_145782_y(), 0, id);
        }
        this.lastInstant = System.nanoTime();
        this.state = State.DECISION;
        this.undecidedCount.set(this.playerCount.get());
        this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
        this.battleEnded = false;
        this.notifyPlayersBattleInfo();
    }

    public int getId() {
        return this.id;
    }

    public Entity getCombatantEntity(int entityID) {
        Combatant c = this.sideA.get(entityID);
        if (c != null) {
            return c.entity;
        }
        c = this.sideB.get(entityID);
        if (c != null) {
            return c.entity;
        }
        return null;
    }

    public boolean hasCombatant(int entityID) {
        return this.sideA.containsKey(entityID) || this.sideB.containsKey(entityID);
    }

    public boolean hasCombatantInSideA(int entityID) {
        return this.sideA.containsKey(entityID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCombatantToSideA(Entity e) {
        EntityInfo entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        if (entityInfo == null && !(e instanceof EntityPlayer) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = true;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            Queue<Combatant> queue = this.sideAEntryQueue;
            synchronized (queue) {
                this.sideAEntryQueue.add(newCombatant);
            }
        } else {
            this.sideA.put(e.func_145782_y(), newCombatant);
        }
        if (e instanceof EntityPlayer) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.func_145782_y(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.field_70165_t;
            newCombatant.z = e.field_70161_v;
            newCombatant.yaw = e.field_70177_z;
            newCombatant.pitch = e.field_70125_A;
        }
        if (newCombatant.entityInfo != null) {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id, newCombatant.entityInfo.category);
        } else if (newCombatant.entity instanceof EntityPlayer) {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id, "player");
        } else {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id);
        }
        this.notifyPlayersBattleInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCombatantToSideB(Entity e) {
        EntityInfo entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(e);
        if (entityInfo == null && !(e instanceof EntityPlayer) && TurnBasedMinecraftMod.proxy.isServerRunning()) {
            return;
        }
        Combatant newCombatant = new Combatant(e, entityInfo);
        newCombatant.isSideA = false;
        newCombatant.battleID = this.getId();
        if (this.isServer) {
            Queue<Combatant> queue = this.sideBEntryQueue;
            synchronized (queue) {
                this.sideBEntryQueue.add(newCombatant);
            }
        } else {
            this.sideB.put(e.func_145782_y(), newCombatant);
        }
        if (e instanceof EntityPlayer) {
            newCombatant.recalcSpeedOnCompare = true;
            this.playerCount.incrementAndGet();
            this.players.put(e.func_145782_y(), newCombatant);
            if (this.state == State.DECISION) {
                this.undecidedCount.incrementAndGet();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            newCombatant.x = e.field_70165_t;
            newCombatant.z = e.field_70161_v;
            newCombatant.yaw = e.field_70177_z;
            newCombatant.pitch = e.field_70125_A;
        }
        if (newCombatant.entityInfo != null) {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id, newCombatant.entityInfo.category);
        } else if (newCombatant.entity instanceof EntityPlayer) {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id, "player");
        } else {
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENTERED, newCombatant.entity.func_145782_y(), 0, this.id);
        }
        this.notifyPlayersBattleInfo();
    }

    public void clearCombatants() {
        this.sideA.clear();
        this.sideB.clear();
        this.sideAEntryQueue.clear();
        this.sideBEntryQueue.clear();
        this.players.clear();
        this.playerCount.set(0);
        this.undecidedCount.set(0);
    }

    public Collection<Combatant> getSideA() {
        return this.sideA.values();
    }

    public Collection<Combatant> getSideB() {
        return this.sideB.values();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideAEntrySet() {
        return this.sideA.entrySet();
    }

    public Set<Map.Entry<Integer, Combatant>> getSideBEntrySet() {
        return this.sideB.entrySet();
    }

    public Collection<Integer> getSideAIDs() {
        ArrayList<Integer> sideAIDs = new ArrayList<Integer>(this.sideA.size());
        for (Combatant combatant : this.sideA.values()) {
            sideAIDs.add(combatant.entity.func_145782_y());
        }
        return sideAIDs;
    }

    public Collection<Integer> getSideBIDs() {
        ArrayList<Integer> sideBIDs = new ArrayList<Integer>(this.sideB.size());
        for (Combatant combatant : this.sideB.values()) {
            sideBIDs.add(combatant.entity.func_145782_y());
        }
        return sideBIDs;
    }

    public Combatant getCombatantByID(int entityID) {
        Combatant combatant = this.sideA.get(entityID);
        if (combatant == null) {
            combatant = this.sideB.get(entityID);
        }
        return combatant;
    }

    public void setDecision(int entityID, Decision decision, int targetIDOrItemID) {
        if (this.state != State.DECISION) {
            return;
        }
        Combatant combatant = this.players.get(entityID);
        if (combatant == null || combatant.decision != Decision.UNDECIDED) {
            return;
        }
        combatant.decision = decision;
        if (decision == Decision.ATTACK) {
            combatant.targetEntityID = targetIDOrItemID;
        } else if (decision == Decision.USE_ITEM || decision == Decision.SWITCH_ITEM) {
            combatant.itemToUse = targetIDOrItemID;
        }
        this.undecidedCount.decrementAndGet();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getTimerSeconds() {
        return this.timer / 1000000000L;
    }

    public int getSize() {
        return this.sideA.size() + this.sideB.size();
    }

    protected void notifyPlayersBattleInfo() {
        if (!this.isServer) {
            return;
        }
        PacketBattleInfo infoPacket = new PacketBattleInfo(this.getSideAIDs(), this.getSideBIDs(), this.timer);
        for (Combatant p : this.players.values()) {
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)infoPacket, (EntityPlayerMP)p.entity);
        }
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount) {
        if (!this.isServer) {
            return;
        }
        for (Combatant p : this.players.values()) {
            if (!p.entity.func_70089_S()) continue;
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketBattleMessage(type, from, to, amount), (EntityPlayerMP)p.entity);
        }
    }

    protected void sendMessageToAllPlayers(PacketBattleMessage.MessageType type, int from, int to, int amount, String custom) {
        if (!this.isServer) {
            return;
        }
        for (Combatant p : this.players.values()) {
            if (!p.entity.func_70089_S()) continue;
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketBattleMessage(type, from, to, amount, custom), (EntityPlayerMP)p.entity);
        }
    }

    private boolean healthCheck() {
        String category;
        ArrayDeque<Combatant> removeQueue = new ArrayDeque<Combatant>();
        for (Combatant c : this.sideA.values()) {
            if (c.entity.func_70089_S()) continue;
            removeQueue.add(c);
            category = new String();
            if (c.entityInfo != null) {
                category = c.entityInfo.category;
            } else if (c.entity instanceof EntityPlayer) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, c.entity.func_145782_y(), 0, 0, category);
        }
        for (Combatant c : this.sideB.values()) {
            if (c.entity.func_70089_S()) continue;
            removeQueue.add(c);
            category = new String();
            if (c.entityInfo != null) {
                category = c.entityInfo.category;
            } else if (c.entity instanceof EntityPlayer) {
                category = "player";
            }
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DIED, c.entity.func_145782_y(), 0, 0, category);
        }
        boolean didRemove = !removeQueue.isEmpty();
        Combatant toRemove = (Combatant)removeQueue.poll();
        while (toRemove != null) {
            this.removeCombatant(toRemove);
            toRemove = (Combatant)removeQueue.poll();
        }
        if (this.players.isEmpty() || this.sideA.isEmpty() || this.sideB.isEmpty()) {
            this.battleEnded = true;
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ENDED, 0, 0, 0);
        } else if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private boolean isCreativeCheck() {
        ArrayDeque<Combatant> removeQueue = new ArrayDeque<Combatant>();
        for (Combatant c : this.players.values()) {
            if (c.entity == null || !((EntityPlayer)c.entity).func_184812_l_()) continue;
            removeQueue.add(c);
        }
        boolean didRemove = false;
        Combatant toRemove = (Combatant)removeQueue.poll();
        while (toRemove != null) {
            didRemove = true;
            this.removeCombatant(toRemove);
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BECAME_CREATIVE, toRemove.entity.func_145782_y(), 0, 0);
            toRemove = (Combatant)removeQueue.poll();
        }
        if (didRemove) {
            this.resetUndecidedCount();
        }
        return didRemove;
    }

    private void resetUndecidedCount() {
        if (this.state == State.DECISION) {
            this.undecidedCount.set(0);
            for (Combatant p : this.players.values()) {
                if (p.decision != Decision.UNDECIDED) continue;
                this.undecidedCount.incrementAndGet();
            }
        }
    }

    private void enforceFreezePositions() {
        for (Combatant c : this.sideA.values()) {
            c.entity.func_70080_a(c.x, c.entity.field_70163_u, c.z, c.yaw, c.pitch);
        }
        for (Combatant c : this.sideB.values()) {
            c.entity.func_70080_a(c.x, c.entity.field_70163_u, c.z, c.yaw, c.pitch);
        }
    }

    private void removeCombatant(Combatant c) {
        this.sideA.remove(c.entity.func_145782_y());
        this.sideB.remove(c.entity.func_145782_y());
        if (this.players.remove(c.entity.func_145782_y()) != null) {
            this.playerCount.decrementAndGet();
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketBattleMessage(PacketBattleMessage.MessageType.ENDED, 0, 0, 0), (EntityPlayerMP)c.entity);
        }
        this.battleManager.addRecentlyLeftBattle(c);
    }

    public boolean update() {
        if (!this.isServer) {
            return false;
        }
        if (this.battleEnded) {
            ArrayList<Combatant> combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        long nextInstant = System.nanoTime();
        long dt = nextInstant - this.lastInstant;
        this.lastInstant = nextInstant;
        return this.update(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean update(long dt) {
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
            return true;
        }
        combatantsChanged = false;
        var4_5 = this.sideAEntryQueue;
        synchronized (var4_5) {
            c = this.sideAEntryQueue.poll();
            while (c != null) {
                this.sideA.put(c.entity.func_145782_y(), c);
                combatantsChanged = true;
                c = this.sideAEntryQueue.poll();
            }
        }
        var4_5 = this.sideBEntryQueue;
        synchronized (var4_5) {
            c = this.sideBEntryQueue.poll();
            while (c != null) {
                this.sideB.put(c.entity.func_145782_y(), c);
                combatantsChanged = true;
                c = this.sideBEntryQueue.poll();
            }
        }
        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
            this.enforceFreezePositions();
        }
        switch (1.$SwitchMap$com$seodisparate$TurnBasedMinecraft$common$Battle$State[this.state.ordinal()]) {
            case 1: {
                this.timer -= dt;
                if (this.timer <= 0L || this.undecidedCount.get() <= 0) {
                    for (Combatant c : this.sideA.values()) {
                        if (c.entity instanceof EntityPlayer || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        percentage = (int)(Math.random() * 100.0);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    for (Combatant c : this.sideB.values()) {
                        if (c.entity instanceof EntityPlayer || c.decision != Decision.UNDECIDED || c.entityInfo == null) continue;
                        percentage = (int)(Math.random() * 100.0);
                        if (percentage < c.entityInfo.decisionAttack) {
                            c.decision = Decision.ATTACK;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack < c.entityInfo.decisionDefend) {
                            c.decision = Decision.DEFEND;
                            continue;
                        }
                        if (percentage - c.entityInfo.decisionAttack - c.entityInfo.decisionDefend >= c.entityInfo.decisionFlee) continue;
                        c.decision = Decision.FLEE;
                    }
                    this.state = State.ACTION;
                    this.timer = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_BEGIN, 0, 0, 0);
                    this.turnOrderQueue.clear();
                    for (Combatant c : this.sideA.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    for (Combatant c : this.sideB.values()) {
                        this.turnOrderQueue.add(c);
                    }
                    this.update(0L);
                    break;
                }
                if (this.healthCheck()) {
                    combatantsChanged = true;
                }
                if (!this.isCreativeCheck()) break;
                combatantsChanged = true;
                break;
            }
            case 2: {
                next = this.turnOrderQueue.poll();
                while (next != null) {
                    if (!next.entity.func_70089_S()) ** GOTO lbl251
                    next.remainingDefenses = 0;
                    switch (1.$SwitchMap$com$seodisparate$TurnBasedMinecraft$common$Battle$Decision[next.decision.ordinal()]) {
                        case 1: {
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DID_NOTHING, next.entity.func_145782_y(), 0, 0);
                            break;
                        }
                        case 2: {
                            target = null;
                            if (next.entity instanceof EntityPlayer) {
                                target = next.isSideA != false ? this.sideB.get(next.targetEntityID) : this.sideA.get(next.targetEntityID);
                                if (target == null || !target.entity.func_70089_S()) break;
                                heldItemStack = ((EntityPlayer)next.entity).func_184614_ca();
                                if (heldItemStack.func_77973_b() instanceof ItemBow) {
                                    if (Utility.doesPlayerHaveArrows((EntityPlayer)next.entity)) {
                                        nextEntity = next.entity;
                                        targetEntity = target.entity;
                                        yawDirection = Utility.yawDirection(next.entity.field_70165_t, next.entity.field_70161_v, target.entity.field_70165_t, target.entity.field_70161_v);
                                        pitchDirection = Utility.pitchDirection(next.entity.field_70165_t, next.entity.field_70163_u, next.entity.field_70161_v, target.entity.field_70165_t, target.entity.field_70163_u, target.entity.field_70161_v);
                                        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                            next.yaw = yawDirection;
                                            next.pitch = pitchDirection;
                                        }
                                        next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$0(net.minecraft.entity.Entity float float net.minecraft.item.ItemStack net.minecraft.entity.Entity ), ()V)((Battle)this, (Entity)nextEntity, (float)yawDirection, (float)pitchDirection, (ItemStack)heldItemStack, (Entity)targetEntity));
                                        break;
                                    }
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.BOW_NO_AMMO, next.entity.func_145782_y(), 0, 0);
                                    break;
                                }
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getPlayerAttackProbability();
                                hitChance = target.entity instanceof EntityPlayer ? (hitChance -= TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) : (hitChance -= target.entityInfo.evasion);
                                if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                    hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                                }
                                if ((int)(Math.random() * 100.0) < hitChance) {
                                    if (target.remainingDefenses <= 0) {
                                        nextEntity = next.entity;
                                        targetEntity = target.entity;
                                        targetEntityInfo = target.entityInfo;
                                        yawDirection = Utility.yawDirection(next.entity.field_70165_t, next.entity.field_70161_v, target.entity.field_70165_t, target.entity.field_70161_v);
                                        pitchDirection = Utility.pitchDirection(next.entity.field_70165_t, next.entity.field_70163_u, next.entity.field_70161_v, target.entity.field_70165_t, target.entity.field_70163_u, target.entity.field_70161_v);
                                        if (TurnBasedMinecraftMod.proxy.getConfig().isFreezeCombatantsEnabled()) {
                                            next.yaw = yawDirection;
                                            next.pitch = pitchDirection;
                                        }
                                        next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$1(net.minecraft.entity.Entity float float net.minecraft.entity.Entity com.seodisparate.TurnBasedMinecraft.common.EntityInfo ), ()V)((Battle)this, (Entity)nextEntity, (float)yawDirection, (float)pitchDirection, (Entity)targetEntity, (EntityInfo)targetEntityInfo));
                                        break;
                                    }
                                    --target.remainingDefenses;
                                    this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.func_145782_y(), next.entity.func_145782_y(), 0);
                                    break;
                                }
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.func_145782_y(), target.entity.func_145782_y(), 0);
                                break;
                            }
                            attackTarget = ((EntityLiving)next.entity).func_70638_az();
                            if (attackTarget == null || !this.hasCombatant(attackTarget.func_145782_y())) ** GOTO lbl143
                            target = this.getCombatantByID(attackTarget.func_145782_y());
                            ** GOTO lbl155
lbl143:
                            // 1 sources

                            if (!next.isSideA) ** GOTO lbl150
                            randomTargetIndex = (int)(Math.random() * (double)this.sideB.size());
                            for (Combatant c : this.sideB.values()) {
                                if (randomTargetIndex-- != 0) continue;
                                target = c;
                                ** GOTO lbl155
                            }
                            ** GOTO lbl155
lbl150:
                            // 1 sources

                            randomTargetIndex = (int)(Math.random() * (double)this.sideA.size());
                            for (Combatant c : this.sideA.values()) {
                                if (randomTargetIndex-- != 0) continue;
                                target = c;
                                break;
                            }
lbl155:
                            // 5 sources

                            if (target == null || !target.entity.func_70089_S()) break;
                            hitChance = next.entityInfo.attackProbability;
                            hitChance = target.entity instanceof EntityPlayer ? (hitChance -= TurnBasedMinecraftMod.proxy.getConfig().getPlayerEvasion()) : (hitChance -= target.entityInfo.evasion);
                            if (hitChance < TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage()) {
                                hitChance = TurnBasedMinecraftMod.proxy.getConfig().getMinimumHitPercentage();
                            }
                            if ((int)(Math.random() * 100.0) < hitChance) {
                                if (target.remainingDefenses <= 0) {
                                    damageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)next.entity));
                                    damageAmount = next.entityInfo.attackPower;
                                    if (next.entityInfo.attackVariance > 0) {
                                        damageAmount += (int)(Math.random() * (double)(next.entityInfo.attackVariance * 2 + 1)) - next.entityInfo.attackVariance;
                                    }
                                    nextEntity = next.entity;
                                    nextEntityInfo = next.entityInfo;
                                    targetEntity = target.entity;
                                    targetEntityInfo = target.entityInfo;
                                    finalDamageAmount = damageAmount;
                                    next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$2(net.minecraft.entity.Entity net.minecraft.entity.Entity net.minecraft.util.DamageSource int com.seodisparate.TurnBasedMinecraft.common.EntityInfo com.seodisparate.TurnBasedMinecraft.common.EntityInfo ), ()V)((Battle)this, (Entity)nextEntity, (Entity)targetEntity, (DamageSource)damageSource, (int)finalDamageAmount, (EntityInfo)targetEntityInfo, (EntityInfo)nextEntityInfo));
                                    break;
                                }
                                --target.remainingDefenses;
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFEND, target.entity.func_145782_y(), next.entity.func_145782_y(), 0);
                                break;
                            }
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.MISS, next.entity.func_145782_y(), target.entity.func_145782_y(), 0);
                            break;
                        }
                        case 3: {
                            next.remainingDefenses = TurnBasedMinecraftMod.proxy.getConfig().getDefenseDuration();
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENDING, next.entity.func_145782_y(), 0, 0);
                            break;
                        }
                        case 4: {
                            fastestEnemySpeed = 0;
                            if (next.isSideA) {
                                for (Combatant c : this.sideB.values()) {
                                    if (c.entity instanceof EntityPlayer) {
                                        if (TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed() <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                        continue;
                                    }
                                    if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = c.entityInfo.speed;
                                }
                            } else {
                                for (Combatant c : this.sideA.values()) {
                                    if (c.entity instanceof EntityPlayer) {
                                        if (TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed() <= fastestEnemySpeed) continue;
                                        fastestEnemySpeed = TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed();
                                        continue;
                                    }
                                    if (c.entityInfo.speed <= fastestEnemySpeed) continue;
                                    fastestEnemySpeed = c.entityInfo.speed;
                                }
                            }
                            fleeProbability = 0;
                            fleeProbability = next.entity instanceof EntityPlayer ? (fastestEnemySpeed >= TurnBasedMinecraftMod.proxy.getConfig().getPlayerSpeed() ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability()) : (fastestEnemySpeed >= next.entityInfo.speed ? TurnBasedMinecraftMod.proxy.getConfig().getFleeBadProbability() : TurnBasedMinecraftMod.proxy.getConfig().getFleeGoodProbability());
                            if ((int)(Math.random() * 100.0) < fleeProbability) {
                                combatantsChanged = true;
                                fleeingCategory = new String();
                                if (next.entityInfo != null) {
                                    fleeingCategory = next.entityInfo.category;
                                } else if (next.entity instanceof EntityPlayer) {
                                    fleeingCategory = "player";
                                }
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.func_145782_y(), 0, 1, fleeingCategory);
                                this.removeCombatant((Combatant)next);
                                break;
                            }
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FLEE, next.entity.func_145782_y(), 0, 0);
                            break;
                        }
                        case 5: {
                            if (next.itemToUse < 0 || next.itemToUse > 8) {
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.func_145782_y(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue());
                                break;
                            }
                            targetItemStack = ((EntityPlayer)next.entity).field_71071_by.func_70301_a(next.itemToUse);
                            targetItem = targetItemStack.func_77973_b();
                            if (targetItem == null) {
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.func_145782_y(), 0, PacketBattleMessage.UsedItemAction.USED_NOTHING.getValue());
                                break;
                            }
                            if (targetItem instanceof ItemFood) {
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.func_145782_y(), 0, PacketBattleMessage.UsedItemAction.USED_FOOD.getValue(), targetItemStack.func_82833_r());
                                nextEntity = next.entity;
                                next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$3(net.minecraft.item.Item net.minecraft.item.ItemStack net.minecraft.entity.Entity ), ()V)((Item)targetItem, (ItemStack)targetItemStack, (Entity)nextEntity));
                                break;
                            }
                            if (targetItem instanceof ItemPotion && !(targetItem instanceof ItemSplashPotion) && !(targetItem instanceof ItemLingeringPotion)) {
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.func_145782_y(), 0, PacketBattleMessage.UsedItemAction.USED_POTION.getValue(), targetItemStack.func_82833_r());
                                nextEntity = next.entity;
                                nextItemToUse = next.itemToUse;
                                next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$4(net.minecraft.item.Item net.minecraft.item.ItemStack net.minecraft.entity.Entity int ), ()V)((Item)targetItem, (ItemStack)targetItemStack, (Entity)nextEntity, (int)nextItemToUse));
                                break;
                            }
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.USED_ITEM, next.entity.func_145782_y(), 0, PacketBattleMessage.UsedItemAction.USED_INVALID.getValue(), targetItemStack.func_82833_r());
                            break;
                        }
                        case 6: {
                            if (next.itemToUse < 0 || next.itemToUse > 8) {
                                this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.func_145782_y(), 0, 0);
                                break;
                            }
                            nextEntity = next.entity;
                            nextItemToUse = next.itemToUse;
                            next.entity.func_184102_h().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$5(net.minecraft.entity.Entity int ), ()V)((Entity)nextEntity, (int)nextItemToUse));
                            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.SWITCHED_ITEM, next.entity.func_145782_y(), 0, 1);
                        }
                    }
lbl251:
                    // 23 sources

                    next = this.turnOrderQueue.poll();
                }
                for (Combatant c : this.sideA.values()) {
                    c.decision = Decision.UNDECIDED;
                }
                for (Combatant c : this.sideB.values()) {
                    c.decision = Decision.UNDECIDED;
                }
                this.state = State.DECISION;
                this.undecidedCount.set(this.players.size());
                if (this.healthCheck()) {
                    combatantsChanged = true;
                }
                if (this.isCreativeCheck()) {
                    combatantsChanged = true;
                }
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$update$6(), ()V)((Battle)this));
                break;
            }
            default: {
                this.state = State.DECISION;
            }
        }
        if (combatantsChanged) {
            this.notifyPlayersBattleInfo();
        }
        if (this.battleEnded) {
            combatants = new ArrayList<Combatant>();
            combatants.addAll(this.sideA.values());
            combatants.addAll(this.sideB.values());
            for (Combatant c : combatants) {
                this.removeCombatant(c);
            }
        }
        return this.battleEnded;
    }

    private /* synthetic */ void lambda$update$6() {
        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.TURN_END, 0, 0, 0);
    }

    private static /* synthetic */ void lambda$update$5(Entity nextEntity, int nextItemToUse) {
        ((EntityPlayer)nextEntity).field_71071_by.field_70461_c = nextItemToUse;
    }

    private static /* synthetic */ void lambda$update$4(Item targetItem, ItemStack targetItemStack, Entity nextEntity, int nextItemToUse) {
        ((ItemPotion)targetItem).func_77654_b(targetItemStack, nextEntity.field_70170_p, (EntityLivingBase)nextEntity);
        ((EntityPlayer)nextEntity).field_71071_by.func_70299_a(nextItemToUse, new ItemStack(Items.field_151069_bo));
    }

    private static /* synthetic */ void lambda$update$3(Item targetItem, ItemStack targetItemStack, Entity nextEntity) {
        ((ItemFood)targetItem).func_77654_b(targetItemStack, nextEntity.field_70170_p, (EntityLivingBase)nextEntity);
    }

    private /* synthetic */ void lambda$update$2(Entity nextEntity, Entity targetEntity, DamageSource damageSource, int finalDamageAmount, EntityInfo targetEntityInfo, EntityInfo nextEntityInfo) {
        int effectChance;
        TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
        targetEntity.func_70097_a(damageSource, (float)finalDamageAmount);
        TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.func_145782_y(), targetEntity.func_145782_y(), finalDamageAmount);
        if (!(targetEntity instanceof EntityPlayer) && targetEntityInfo.defenseDamage > 0 && (int)(Math.random() * 100.0) < targetEntityInfo.defenseDamageProbability) {
            DamageSource defenseDamageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)targetEntity));
            TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
            nextEntity.func_70097_a(defenseDamageSource, (float)targetEntityInfo.defenseDamage);
            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.func_145782_y(), nextEntity.func_145782_y(), targetEntityInfo.defenseDamage);
        }
        if (nextEntityInfo.attackEffect != EntityInfo.Effect.UNKNOWN && nextEntityInfo.attackEffectProbability > 0 && (effectChance = (int)(Math.random() * 100.0)) < nextEntityInfo.attackEffectProbability) {
            nextEntityInfo.attackEffect.applyEffectToEntity((EntityLivingBase)targetEntity);
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.WAS_AFFECTED, nextEntity.func_145782_y(), targetEntity.func_145782_y(), 0, nextEntityInfo.attackEffect.getAffectedString());
        }
    }

    private /* synthetic */ void lambda$update$1(Entity nextEntity, float yawDirection, float pitchDirection, Entity targetEntity, EntityInfo targetEntityInfo) {
        ((EntityPlayerMP)nextEntity).field_71135_a.func_147364_a(nextEntity.field_70165_t, nextEntity.field_70163_u, nextEntity.field_70161_v, yawDirection, pitchDirection);
        TurnBasedMinecraftMod.proxy.setAttackingEntity(nextEntity);
        TurnBasedMinecraftMod.proxy.setAttackingDamage(0);
        ((EntityPlayer)nextEntity).func_71059_n(targetEntity);
        TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ATTACK, nextEntity.func_145782_y(), targetEntity.func_145782_y(), TurnBasedMinecraftMod.proxy.getAttackingDamage());
        if (!(targetEntity instanceof EntityPlayer) && targetEntityInfo.defenseDamage > 0 && (int)(Math.random() * 100.0) < targetEntityInfo.defenseDamageProbability) {
            DamageSource defenseDamageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)targetEntity));
            TurnBasedMinecraftMod.proxy.setAttackingEntity(targetEntity);
            nextEntity.func_70097_a(defenseDamageSource, (float)targetEntityInfo.defenseDamage);
            TurnBasedMinecraftMod.proxy.setAttackingEntity(null);
            this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.DEFENSE_DAMAGE, targetEntity.func_145782_y(), nextEntity.func_145782_y(), targetEntityInfo.defenseDamage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$update$0(Entity nextEntity, float yawDirection, float pitchDirection, ItemStack heldItemStack, Entity targetEntity) {
        ((EntityPlayerMP)nextEntity).field_71135_a.func_147364_a(nextEntity.field_70165_t, nextEntity.field_70163_u, nextEntity.field_70161_v, yawDirection, pitchDirection);
        ItemBow itemBow = (ItemBow)heldItemStack.func_77973_b();
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().add(new AttackerViaBow(nextEntity, this.getId()));
        }
        itemBow.func_77615_a(((EntityPlayer)nextEntity).func_184614_ca(), nextEntity.func_130014_f_(), (EntityLivingBase)nextEntity, (int)(Math.random() * (double)itemBow.func_77626_a(heldItemStack) / 3.0));
        this.sendMessageToAllPlayers(PacketBattleMessage.MessageType.FIRED_ARROW, nextEntity.func_145782_y(), targetEntity.func_145782_y(), 0);
    }

    public static enum Decision {
        UNDECIDED(0),
        ATTACK(1),
        DEFEND(2),
        FLEE(3),
        USE_ITEM(4),
        SWITCH_ITEM(5);

        private int value;
        private static Map<Integer, Decision> map;

        private Decision(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Decision valueOf(int decisionType) {
            return map.get(decisionType);
        }

        static {
            map = new HashMap<Integer, Decision>();
            for (Decision decision : Decision.values()) {
                map.put(decision.value, decision);
            }
        }
    }

    public static enum State {
        DECISION(0),
        ACTION(1),
        DECISION_PLAYER_READY(2);

        private int value;
        private static Map<Integer, State> map;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State valueOf(int stateType) {
            return map.get(stateType);
        }

        static {
            map = new HashMap<Integer, State>();
            for (State state : State.values()) {
                map.put(state.value, state);
            }
        }
    }
}

