/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleUpdater;
import com.seodisparate.TurnBasedMinecraft.common.Combatant;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Logger;

public class BattleManager {
    private int IDCounter = 0;
    protected Map<Integer, Battle> battleMap;
    private Thread updaterThread;
    private BattleUpdater battleUpdater;
    private Logger logger;
    private Map<Integer, Combatant> recentlyLeftBattle;

    public BattleManager(Logger logger) {
        this.logger = logger;
        this.battleMap = new Hashtable<Integer, Battle>();
        this.battleUpdater = new BattleUpdater(this);
        this.updaterThread = new Thread(this.battleUpdater);
        this.updaterThread.start();
        this.recentlyLeftBattle = new HashMap<Integer, Combatant>();
    }

    public boolean checkAttack(LivingAttackEvent event) {
        if ((!(event.getEntity() instanceof EntityPlayer) || ((EntityPlayer)event.getEntity()).func_184812_l_()) && TurnBasedMinecraftMod.proxy.getConfig().getEntityInfoReference(event.getEntity().getClass().getName()) == null || (!(event.getSource().func_76346_g() instanceof EntityPlayer) || ((EntityPlayer)event.getSource().func_76346_g()).func_184812_l_()) && TurnBasedMinecraftMod.proxy.getConfig().getEntityInfoReference(event.getSource().func_76346_g().getClass().getName()) == null) {
            return false;
        }
        EntityInfo entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getEntity());
        if (entityInfo != null && (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            for (Battle b : this.battleMap.values()) {
                if (!b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) continue;
                return true;
            }
            return false;
        }
        entityInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getSource().func_76346_g());
        if (entityInfo != null && (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            for (Battle b : this.battleMap.values()) {
                if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
                return true;
            }
            return false;
        }
        Entity inBattle = null;
        Entity notInBattle = null;
        Battle battle = null;
        for (Battle b : this.battleMap.values()) {
            if (b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) {
                if (inBattle != null) {
                    return true;
                }
                inBattle = event.getSource().func_76346_g();
                notInBattle = event.getEntity();
                battle = b;
            }
            if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
            if (inBattle != null) {
                return true;
            }
            inBattle = event.getEntity();
            notInBattle = event.getSource().func_76346_g();
            battle = b;
        }
        if (inBattle == null) {
            if (event.getEntity() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof EntityPlayer) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add(event.getEntity());
                sideB.add(event.getSource().func_76346_g());
                this.createBattle(sideA, sideB);
            }
            return false;
        }
        if (battle.getSize() >= TurnBasedMinecraftMod.proxy.getConfig().getMaxInBattle()) {
            return true;
        }
        if (battle.hasCombatantInSideA(inBattle.func_145782_y())) {
            battle.addCombatantToSideB(notInBattle);
        } else {
            battle.addCombatantToSideA(notInBattle);
        }
        return true;
    }

    public void checkTargeted(LivingSetAttackTargetEvent event) {
        EntityInfo targetedInfo;
        EntityInfo attackerInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getEntity());
        EntityInfo entityInfo = targetedInfo = event.getTarget() instanceof EntityPlayer ? null : TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getTarget());
        if (event.getTarget() instanceof EntityPlayer && ((EntityPlayer)event.getTarget()).func_184812_l_() || attackerInfo == null || attackerInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(attackerInfo.category) || targetedInfo != null && (targetedInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(targetedInfo.category))) {
            return;
        }
        Entity inBattle = null;
        EntityLivingBase notInBattle = null;
        Battle battle = null;
        for (Battle b : this.battleMap.values()) {
            if (b.hasCombatant(event.getEntity().func_145782_y())) {
                if (inBattle != null) {
                    return;
                }
                inBattle = event.getEntity();
                notInBattle = event.getTarget();
                battle = b;
            }
            if (!b.hasCombatant(event.getTarget().func_145782_y())) continue;
            if (inBattle != null) {
                return;
            }
            inBattle = event.getTarget();
            notInBattle = event.getEntity();
            battle = b;
        }
        if (battle == null) {
            if (event.getEntity() instanceof EntityPlayer || event.getTarget() instanceof EntityPlayer) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add(event.getEntity());
                sideB.add((Entity)event.getTarget());
                this.createBattle(sideA, sideB);
            }
        } else {
            if (battle.getSize() >= TurnBasedMinecraftMod.proxy.getConfig().getMaxInBattle()) {
                return;
            }
            if (battle.hasCombatantInSideA(inBattle.func_145782_y())) {
                battle.addCombatantToSideB((Entity)notInBattle);
            } else {
                battle.addCombatantToSideA((Entity)notInBattle);
            }
        }
    }

    private Battle createBattle(Collection<Entity> sideA, Collection<Entity> sideB) {
        while (this.battleMap.containsKey(this.IDCounter)) {
            ++this.IDCounter;
        }
        Battle newBattle = new Battle(this, this.IDCounter, sideA, sideB, true);
        this.battleMap.put(this.IDCounter, newBattle);
        newBattle.notifyPlayersBattleInfo();
        return newBattle;
    }

    public Battle getBattleByID(int id) {
        return this.battleMap.get(id);
    }

    public void cleanup() {
        this.battleUpdater.setIsRunning(false);
        this.battleUpdater = null;
        this.updaterThread = null;
        this.battleMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecentlyLeftBattle(Combatant c) {
        c.time = System.nanoTime();
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        if (c.entity instanceof EntityPlayerMP) {
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("You just left battle! " + config.getLeaveBattleCooldownSeconds() + " seconds until you can attack/be-attacked again!"), (EntityPlayerMP)c.entity);
        }
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            this.recentlyLeftBattle.put(c.entity.func_145782_y(), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecentlyLeftBattle() {
        long current = System.nanoTime();
        ArrayDeque<Combatant> removeQueue = new ArrayDeque<Combatant>();
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            for (Combatant c : this.recentlyLeftBattle.values()) {
                if (current - c.time <= TurnBasedMinecraftMod.proxy.getConfig().getLeaveBattleCooldownNanos()) continue;
                removeQueue.add(c);
            }
            Combatant c = (Combatant)removeQueue.poll();
            while (c != null) {
                if (c.entity instanceof EntityPlayerMP) {
                    TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("Timer ended, you can now attack/be-attacked again."), (EntityPlayerMP)c.entity);
                }
                this.recentlyLeftBattle.remove(c.entity.func_145782_y());
                c = (Combatant)removeQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecentlyLeftBattle(int entityID) {
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            return this.recentlyLeftBattle.containsKey(entityID);
        }
    }
}

