/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleManager;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class BattleUpdater
implements Runnable {
    private BattleManager manager;
    private AtomicBoolean isRunning;

    public BattleUpdater(BattleManager manager) {
        this.manager = manager;
        this.isRunning = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning.get()) {
            Map<Integer, Battle> map = this.manager.battleMap;
            synchronized (map) {
                Iterator<Map.Entry<Integer, Battle>> iter = this.manager.battleMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Integer, Battle> entry = iter.next();
                    UpdateRunnable updateRunnable = new UpdateRunnable(entry.getValue());
                    Thread updateThread = new Thread(updateRunnable);
                    updateThread.start();
                    try {
                        updateThread.join(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!updateRunnable.isFinished()) {
                        TurnBasedMinecraftMod.logger.error("Battle (" + entry.getValue().getId() + "; " + entry.getValue().debugLog + ") update timed out!");
                        updateThread.stop();
                        continue;
                    }
                    if (!updateRunnable.isBattleFinished()) continue;
                    iter.remove();
                }
            }
            this.manager.updateRecentlyLeftBattle();
            try {
                Thread.sleep(250L);
            }
            catch (Throwable throwable) {}
        }
    }

    public void setIsRunning(boolean isRunning) {
        this.isRunning.set(isRunning);
    }

    private class UpdateRunnable
    implements Runnable {
        private Battle battle;
        private AtomicBoolean finished = new AtomicBoolean(false);
        private AtomicBoolean battleFinished = new AtomicBoolean(false);

        public UpdateRunnable(Battle battle) {
            this.battle = battle;
        }

        public boolean isFinished() {
            return this.finished.get();
        }

        public boolean isBattleFinished() {
            return this.battleFinished.get();
        }

        @Override
        public void run() {
            this.battleFinished.set(this.battle.update());
            this.finished.set(true);
        }
    }
}

