/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.AttackerViaBow;
import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleManager;
import com.seodisparate.TurnBasedMinecraft.common.CommonProxy;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.EditingInfo;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.Utility;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AttackEventHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAttackerValid(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() == null) {
            return false;
        }
        if (event.getSource().func_76346_g().equals((Object)TurnBasedMinecraftMod.proxy.getAttackingEntity())) {
            return true;
        }
        long now = System.nanoTime();
        boolean isValid = false;
        Set<AttackerViaBow> set = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet();
        synchronized (set) {
            Iterator<AttackerViaBow> iter = TurnBasedMinecraftMod.proxy.getAttackerViaBowSet().iterator();
            while (iter.hasNext()) {
                AttackerViaBow attacker = iter.next();
                if (now - attacker.attackTime >= AttackerViaBow.ATTACK_TIMEOUT) {
                    iter.remove();
                    continue;
                }
                if (!event.getSource().func_76346_g().equals((Object)attacker.entity) || !event.getSource().func_76352_a()) continue;
                iter.remove();
                if (isValid) continue;
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(attacker.battleID);
                if (b != null) {
                    b.sendMessageToAllPlayers(PacketBattleMessage.MessageType.ARROW_HIT, attacker.entity.func_145782_y(), event.getEntity().func_145782_y(), 0);
                }
                isValid = true;
            }
        }
        return isValid;
    }

    @SubscribeEvent
    public void entityAttacked(LivingAttackEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        CommonProxy proxy = TurnBasedMinecraftMod.proxy;
        Config config = proxy.getConfig();
        BattleManager battleManager = proxy.getBattleManager();
        EditingInfo editingInfo = null;
        if (event.getSource().func_76346_g() != null && event.getEntity() != null && (editingInfo = proxy.getEditingInfo(event.getSource().func_76346_g().func_145782_y())) != null && editingInfo.isPendingEntitySelection) {
            editingInfo.isPendingEntitySelection = false;
            event.setCanceled(true);
            if (editingInfo.isEditingCustomName) {
                if (event.getEntity().func_95999_t().isEmpty()) {
                    TurnBasedMinecraftMod.logger.error("Cannot edit custom name from entity without custom name");
                    TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("Cannot edit custom name from entity without custom name"), (EntityPlayerMP)editingInfo.editor);
                    return;
                }
                editingInfo.entityInfo = config.getCustomEntityInfo(event.getEntity().func_95999_t());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.customName = event.getEntity().func_95999_t();
                }
                TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("Editing custom name \"" + event.getEntity().func_95999_t() + "\""), (EntityPlayerMP)editingInfo.editor);
                TurnBasedMinecraftMod.logger.info("Begin editing custom \"" + event.getEntity().func_95999_t() + "\"");
                TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (EntityPlayerMP)editingInfo.editor);
            } else {
                editingInfo.entityInfo = config.getMatchingEntityInfo(event.getEntity());
                if (editingInfo.entityInfo == null) {
                    editingInfo.entityInfo = new EntityInfo();
                    editingInfo.entityInfo.classType = event.getEntity().getClass();
                } else {
                    editingInfo.entityInfo = editingInfo.entityInfo.clone();
                }
                TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("Editing entity \"" + editingInfo.entityInfo.classType.getName() + "\""), (EntityPlayerMP)editingInfo.editor);
                TurnBasedMinecraftMod.logger.info("Begin editing \"" + editingInfo.entityInfo.classType.getName() + "\"");
                TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketEditingMessage(PacketEditingMessage.Type.PICK_EDIT, editingInfo.entityInfo), (EntityPlayerMP)editingInfo.editor);
            }
            return;
        }
        if (event.getEntity() != null && event.getSource().func_76346_g() != null && (battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || battleManager.isRecentlyLeftBattle(event.getSource().func_76346_g().func_145782_y()))) {
            event.setCanceled(true);
            return;
        }
        if (!this.isAttackerValid(event) && event.getEntity() != null && event.getSource().func_76346_g() != null && event.getEntity() != event.getSource().func_76346_g() && !config.getBattleIgnoringPlayers().contains(event.getSource().func_76346_g().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && battleManager.checkAttack(event)) {
            event.setCanceled(true);
        }
        if (TurnBasedMinecraftMod.proxy.getAttackingDamage() < (int)event.getAmount()) {
            TurnBasedMinecraftMod.proxy.setAttackingDamage((int)event.getAmount());
        }
    }

    @SubscribeEvent
    public void entityTargeted(LivingSetAttackTargetEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        BattleManager battleManager = TurnBasedMinecraftMod.proxy.getBattleManager();
        if (event.getEntity().field_70170_p.field_72995_K || config.isOldBattleBehaviorEnabled() || event.getEntity() != null && battleManager.isRecentlyLeftBattle(event.getEntity().func_145782_y()) || event.getTarget() != null && battleManager.isRecentlyLeftBattle(event.getTarget().func_145782_y()) || event.getEntity() != null && event.getTarget() != null && Utility.distanceBetweenEntities(event.getEntity(), (Entity)event.getTarget()) > (double)config.getAggroStartBattleDistance()) {
            return;
        }
        if (event.getEntity() != null && event.getTarget() != null && !config.getBattleIgnoringPlayers().contains(event.getEntity().func_145782_y()) && !config.getBattleIgnoringPlayers().contains(event.getTarget().func_145782_y())) {
            TurnBasedMinecraftMod.proxy.getBattleManager().checkTargeted(event);
        }
    }
}

