/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.Battle;
import com.seodisparate.TurnBasedMinecraft.common.BattleUpdater;
import com.seodisparate.TurnBasedMinecraft.common.Combatant;
import com.seodisparate.TurnBasedMinecraft.common.Config;
import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Logger;

public class BattleManager {
    private int IDCounter = 0;
    protected Map<Integer, Battle> battleMap;
    private Thread updaterThread;
    private BattleUpdater battleUpdater;
    private Logger logger;
    private Map<Integer, Combatant> recentlyLeftBattle;

    public BattleManager(Logger logger) {
        this.logger = logger;
        this.battleMap = new HashMap<Integer, Battle>();
        this.battleUpdater = new BattleUpdater(this);
        this.updaterThread = new Thread(this.battleUpdater);
        this.updaterThread.start();
        this.recentlyLeftBattle = new HashMap<Integer, Combatant>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAttack(LivingAttackEvent event) {
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        if ((!(event.getEntity() instanceof EntityPlayer) || ((EntityPlayer)event.getEntity()).func_184812_l_()) && config.getEntityInfoReference(event.getEntity().getClass().getName()) == null && config.getCustomEntityInfoReference(event.getEntity().func_95999_t()) == null || (!(event.getSource().func_76346_g() instanceof EntityPlayer) || ((EntityPlayer)event.getSource().func_76346_g()).func_184812_l_()) && config.getEntityInfoReference(event.getSource().func_76346_g().getClass().getName()) == null && config.getCustomEntityInfoReference(event.getSource().func_76346_g().func_95999_t()) == null) {
            return false;
        }
        EntityInfo entityInfo = config.getCustomEntityInfoReference(event.getEntity().func_95999_t());
        if (entityInfo == null) {
            entityInfo = config.getMatchingEntityInfo(event.getEntity());
        }
        if (entityInfo != null && (config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            Map<Integer, Battle> map = this.battleMap;
            synchronized (map) {
                for (Battle b : this.battleMap.values()) {
                    if (!b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) continue;
                    this.logger.debug("Attack Canceled: attacked ignores battle but attacker in battle");
                    return true;
                }
            }
            this.logger.debug("Attack Not Canceled: attacked ignores battle");
            return false;
        }
        entityInfo = config.getCustomEntityInfoReference(event.getSource().func_76346_g().func_95999_t());
        if (entityInfo == null) {
            entityInfo = config.getMatchingEntityInfo(event.getSource().func_76346_g());
        }
        if (entityInfo != null && (config.isIgnoreBattleType(entityInfo.category) || entityInfo.ignoreBattle)) {
            Map<Integer, Battle> map = this.battleMap;
            synchronized (map) {
                for (Battle b : this.battleMap.values()) {
                    if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
                    this.logger.debug("Attack Canceled: attacker ignores battle but attacked in battle");
                    return true;
                }
            }
            this.logger.debug("Attack Not Canceled: attacker ignores battle");
            return false;
        }
        Entity inBattle = null;
        Entity notInBattle = null;
        Battle battle = null;
        Map<Integer, Battle> map = this.battleMap;
        synchronized (map) {
            for (Battle b : this.battleMap.values()) {
                if (b.hasCombatant(event.getSource().func_76346_g().func_145782_y())) {
                    if (inBattle != null) {
                        this.logger.debug("Attack Canceled: both are in battle");
                        return true;
                    }
                    inBattle = event.getSource().func_76346_g();
                    notInBattle = event.getEntity();
                    battle = b;
                }
                if (!b.hasCombatant(event.getEntity().func_145782_y())) continue;
                if (inBattle != null) {
                    this.logger.debug("Attack Canceled: both are in battle");
                    return true;
                }
                inBattle = event.getEntity();
                notInBattle = event.getSource().func_76346_g();
                battle = b;
            }
        }
        if (inBattle == null) {
            if (event.getEntity() instanceof EntityPlayer || event.getSource().func_76346_g() instanceof EntityPlayer) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add(event.getEntity());
                sideB.add(event.getSource().func_76346_g());
                this.createBattle(sideA, sideB);
                this.logger.debug("Attack Not Canceled: new battle created");
            } else {
                this.logger.debug("Attack Not Canceled: neither are in battle or players");
            }
            return false;
        }
        if (battle.getSize() >= config.getMaxInBattle()) {
            return true;
        }
        if (battle.hasCombatantInSideA(inBattle.func_145782_y())) {
            battle.addCombatantToSideB(notInBattle);
        } else {
            battle.addCombatantToSideA(notInBattle);
        }
        this.logger.debug("Attack Canceled: one is in battle");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTargeted(LivingSetAttackTargetEvent event) {
        EntityInfo targetedInfo;
        EntityInfo attackerInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(event.getEntity().func_95999_t());
        if (attackerInfo == null) {
            attackerInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getEntity());
        }
        if (event.getTarget() instanceof EntityPlayer) {
            targetedInfo = null;
        } else {
            targetedInfo = TurnBasedMinecraftMod.proxy.getConfig().getCustomEntityInfoReference(event.getTarget().func_95999_t());
            if (targetedInfo == null) {
                targetedInfo = TurnBasedMinecraftMod.proxy.getConfig().getMatchingEntityInfo(event.getTarget());
            }
        }
        if (event.getTarget() instanceof EntityPlayer && ((EntityPlayer)event.getTarget()).func_184812_l_() || attackerInfo == null || attackerInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(attackerInfo.category) || targetedInfo != null && (targetedInfo.ignoreBattle || TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType(targetedInfo.category))) {
            return;
        }
        Entity inBattle = null;
        EntityLivingBase notInBattle = null;
        Battle battle = null;
        Map<Integer, Battle> map = this.battleMap;
        synchronized (map) {
            for (Battle b : this.battleMap.values()) {
                if (b.hasCombatant(event.getEntity().func_145782_y())) {
                    if (inBattle != null) {
                        return;
                    }
                    inBattle = event.getEntity();
                    notInBattle = event.getTarget();
                    battle = b;
                }
                if (!b.hasCombatant(event.getTarget().func_145782_y())) continue;
                if (inBattle != null) {
                    return;
                }
                inBattle = event.getTarget();
                notInBattle = event.getEntity();
                battle = b;
            }
        }
        if (battle == null) {
            if (event.getEntity() instanceof EntityPlayer || event.getTarget() instanceof EntityPlayer) {
                ArrayList<Entity> sideA = new ArrayList<Entity>(1);
                ArrayList<Entity> sideB = new ArrayList<Entity>(1);
                sideA.add(event.getEntity());
                sideB.add((Entity)event.getTarget());
                this.createBattle(sideA, sideB);
            }
        } else {
            if (battle.getSize() >= TurnBasedMinecraftMod.proxy.getConfig().getMaxInBattle()) {
                return;
            }
            if (battle.hasCombatantInSideA(inBattle.func_145782_y())) {
                battle.addCombatantToSideB((Entity)notInBattle);
            } else {
                battle.addCombatantToSideA((Entity)notInBattle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Battle createBattle(Collection<Entity> sideA, Collection<Entity> sideB) {
        Battle newBattle = null;
        Map<Integer, Battle> map = this.battleMap;
        synchronized (map) {
            while (this.battleMap.containsKey(this.IDCounter)) {
                ++this.IDCounter;
            }
            newBattle = new Battle(this, this.IDCounter, sideA, sideB, true);
            this.battleMap.put(this.IDCounter, newBattle);
        }
        newBattle.notifyPlayersBattleInfo();
        return newBattle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Battle getBattleByID(int id) {
        Map<Integer, Battle> map = this.battleMap;
        synchronized (map) {
            return this.battleMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.battleUpdater.setIsRunning(false);
        this.battleUpdater = null;
        this.updaterThread = null;
        Map<Integer, Battle> map = this.battleMap;
        synchronized (map) {
            this.battleMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecentlyLeftBattle(Combatant c) {
        c.time = System.nanoTime();
        Config config = TurnBasedMinecraftMod.proxy.getConfig();
        if (c.entity instanceof EntityPlayerMP) {
            TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("You just left battle! " + config.getLeaveBattleCooldownSeconds() + " seconds until you can attack/be-attacked again!"), (EntityPlayerMP)c.entity);
        }
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            this.recentlyLeftBattle.put(c.entity.func_145782_y(), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecentlyLeftBattle() {
        long current = System.nanoTime();
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            Iterator<Map.Entry<Integer, Combatant>> iter = this.recentlyLeftBattle.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, Combatant> entry = iter.next();
                if (current - entry.getValue().time <= TurnBasedMinecraftMod.proxy.getConfig().getLeaveBattleCooldownNanos()) continue;
                iter.remove();
                if (!(entry.getValue().entity instanceof EntityPlayerMP)) continue;
                TurnBasedMinecraftMod.NWINSTANCE.sendTo((IMessage)new PacketGeneralMessage("Timer ended, you can now attack/be-attacked again."), (EntityPlayerMP)entry.getValue().entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecentlyLeftBattle(int entityID) {
        Map<Integer, Combatant> map = this.recentlyLeftBattle;
        synchronized (map) {
            return this.recentlyLeftBattle.containsKey(entityID);
        }
    }
}

