/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import shadow.turnbasedmc.net.consensys.cava.toml.Toml;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlArray;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlParseResult;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlTable;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlVersion;

public class Config {
    public static final long BATTLE_DECISION_DURATION_NANO_MIN = 5000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_MAX = 60000000000L;
    public static final long BATTLE_DECISION_DURATION_NANO_DEFAULT = 15000000000L;
    private long battleDecisionDurationNanos = 15000000000L;
    private Map<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>();
    private Map<String, EntityInfo> customEntityInfoMap = new HashMap<String, EntityInfo>();
    private Set<String> ignoreBattleTypes = new HashSet<String>();
    private Logger logger;
    private int playerSpeed = 50;
    private int playerHasteSpeed = 80;
    private int playerSlowSpeed = 20;
    private int playerAttackProbability = 100;
    private int playerEvasion = 10;
    private int defenseDuration = 1;
    private int fleeGoodProbability = 90;
    private int fleeBadProbability = 35;
    private int minimumHitPercentage = 4;
    private int maxInBattle = 8;
    private Set<String> musicBattleTypes;
    private Set<String> musicSillyTypes;
    private boolean freezeCombatantsInBattle = false;
    private int sillyMusicThreshold = 40;
    private int configVersion = 0;
    private Set<Integer> battleIgnoringPlayers = null;
    private boolean onlyOPsSelfDisableTB = true;
    private boolean battleDisabledForAll = false;
    private boolean oldBattleBehaviorEnabled = false;
    private int leaveBattleCooldownSeconds = 5;
    private int aggroStartBattleDistance = 8;

    public Config(Logger logger) {
        this.logger = logger;
        this.musicBattleTypes = new HashSet<String>();
        this.musicSillyTypes = new HashSet<String>();
        this.battleIgnoringPlayers = new HashSet<Integer>();
        int internalVersion = this.getConfigFileVersion(this.getClass().getResourceAsStream("/assets/TurnBasedMinecraft/TBM_Config.toml"));
        if (internalVersion == 0) {
            logger.error("Failed to check version of internal config file");
        } else {
            this.configVersion = internalVersion;
        }
        try {
            File testLoad = new File("config/TurnBasedMinecraft/TBM_Config.toml");
            if (!testLoad.exists()) {
                this.writeConfig();
            }
        }
        catch (Throwable t) {
            logger.error("Failed to check/create-new config file");
        }
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (!configFile.exists() || !configFile.canRead()) {
            logger.error("Failed to read/parse config file config/TurnBasedMinecraft/TBM_Config.toml");
            return;
        }
        int configVersion = this.getConfigFileVersion(configFile);
        if (configVersion < this.configVersion) {
            logger.warn("Config file TBM_Config.toml is older version, renaming...");
            this.moveOldConfig();
            try {
                this.writeConfig();
            }
            catch (Throwable t) {
                logger.error("Failed to write config file!");
            }
        }
        try {
            this.parseConfig(configFile);
        }
        catch (Throwable t) {
            logger.error("Failed to parse config file!");
        }
    }

    private void writeConfig() throws IOException {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        File dirs = configFile.getParentFile();
        dirs.mkdirs();
        InputStream configStream = this.getClass().getResourceAsStream("/assets/TurnBasedMinecraft/TBM_Config.toml");
        FileOutputStream configOutput = new FileOutputStream(configFile);
        byte[] buf = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = configStream.read(buf);
            if (read <= 0) continue;
            configOutput.write(buf, 0, read);
        }
        configStream.close();
        configOutput.close();
    }

    private void moveOldConfig() {
        File configFile = new File("config/TurnBasedMinecraft/TBM_Config.toml");
        if (configFile.exists()) {
            configFile.renameTo(new File("config/TurnBasedMinecraft/TBM_Config_" + DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + ".toml"));
        }
    }

    private boolean parseConfig(File configFile) throws IOException {
        int i;
        TomlParseResult parseResult = Toml.parse(configFile.toPath(), TomlVersion.V0_5_0);
        TomlArray battleMusicCategories = parseResult.getArray("client_config.battle_music");
        if (battleMusicCategories != null) {
            for (i = 0; i < battleMusicCategories.size(); ++i) {
                this.musicBattleTypes.add(battleMusicCategories.getString(i));
            }
        } else {
            this.musicBattleTypes.add("monster");
            this.musicBattleTypes.add("animal");
            this.musicBattleTypes.add("boss");
            this.musicBattleTypes.add("player");
            this.logNotFound("client_config.battle_music");
        }
        TomlArray sillyMusicCategories = parseResult.getArray("client_config.silly_music");
        if (sillyMusicCategories != null) {
            for (i = 0; i < sillyMusicCategories.size(); ++i) {
                this.musicSillyTypes.add(sillyMusicCategories.getString(i));
            }
        } else {
            this.musicSillyTypes.add("passive");
            this.logNotFound("client_config.silly_music");
        }
        try {
            this.sillyMusicThreshold = parseResult.getLong("client_config.silly_music_threshold").intValue();
        }
        catch (NullPointerException e) {
            this.sillyMusicThreshold = 40;
            this.logNotFound("client_config.silly_music_threshold", "40");
        }
        try {
            this.leaveBattleCooldownSeconds = parseResult.getLong("server_config.leave_battle_cooldown").intValue();
            if (this.leaveBattleCooldownSeconds < 1) {
                this.leaveBattleCooldownSeconds = 1;
            } else if (this.leaveBattleCooldownSeconds > 10) {
                this.leaveBattleCooldownSeconds = 10;
            }
        }
        catch (NullPointerException e) {
            this.leaveBattleCooldownSeconds = 5;
            this.logNotFound("server_config.leave_battle_cooldown", "5");
        }
        try {
            this.aggroStartBattleDistance = parseResult.getLong("server_config.aggro_start_battle_max_distance").intValue();
            if (this.aggroStartBattleDistance < 5) {
                this.aggroStartBattleDistance = 5;
            } else if (this.aggroStartBattleDistance > 50) {
                this.aggroStartBattleDistance = 50;
            }
        }
        catch (NullPointerException e) {
            this.aggroStartBattleDistance = 8;
            this.logNotFound("server_config.aggro_start_battle_max_distance", "8");
        }
        try {
            this.oldBattleBehaviorEnabled = parseResult.getBoolean("server_config.old_battle_behavior");
        }
        catch (NullPointerException e) {
            this.oldBattleBehaviorEnabled = false;
            this.logNotFound("server_config.old_battle_behavior", "false");
        }
        try {
            this.onlyOPsSelfDisableTB = parseResult.getBoolean("server_config.anyone_can_disable_tbm_for_self") == false;
        }
        catch (NullPointerException e) {
            this.onlyOPsSelfDisableTB = true;
            this.logNotFound("server_config.anyone_can_disable_tbm_for_self", "false");
        }
        try {
            this.maxInBattle = parseResult.getLong("server_config.max_in_battle").intValue();
            if (this.maxInBattle < 2) {
                this.maxInBattle = 2;
            }
        }
        catch (NullPointerException e) {
            this.maxInBattle = 8;
            this.logNotFound("server_config.max_in_battle", "8");
        }
        try {
            this.freezeCombatantsInBattle = parseResult.getBoolean("server_config.freeze_battle_combatants");
        }
        catch (NullPointerException e) {
            this.freezeCombatantsInBattle = false;
            this.logNotFound("server_config.freeze_battle_combatants", "false");
        }
        try {
            TomlArray ignoreTypes = parseResult.getArray("server_config.ignore_battle_types");
            for (i = 0; i < ignoreTypes.size(); ++i) {
                this.ignoreBattleTypes.add(ignoreTypes.getString(i));
            }
        }
        catch (NullPointerException e) {
            this.ignoreBattleTypes.add("passive");
            this.ignoreBattleTypes.add("boss");
            this.logNotFound("server_config.ignore_battle_types");
        }
        try {
            this.playerSpeed = parseResult.getLong("server_config.player_speed").intValue();
        }
        catch (NullPointerException e) {
            this.playerSpeed = 50;
            this.logNotFound("server_config.player_speed", "50");
        }
        try {
            this.playerHasteSpeed = parseResult.getLong("server_config.player_haste_speed").intValue();
        }
        catch (NullPointerException e) {
            this.playerHasteSpeed = 80;
            this.logNotFound("server_config.player_haste_speed", "80");
        }
        try {
            this.playerSlowSpeed = parseResult.getLong("server_config.player_slow_speed").intValue();
        }
        catch (NullPointerException e) {
            this.playerSlowSpeed = 20;
            this.logNotFound("server_config.player_slow_speed", "20");
        }
        try {
            this.playerAttackProbability = parseResult.getLong("server_config.player_attack_probability").intValue();
        }
        catch (NullPointerException e) {
            this.playerAttackProbability = 90;
            this.logNotFound("server_config.player_attack_probability", "90");
        }
        try {
            this.playerEvasion = parseResult.getLong("server_config.player_evasion").intValue();
        }
        catch (NullPointerException e) {
            this.playerEvasion = 10;
            this.logNotFound("server_config.player_evasion", "10");
        }
        try {
            this.defenseDuration = parseResult.getLong("server_config.defense_duration").intValue();
        }
        catch (NullPointerException e) {
            this.defenseDuration = 1;
            this.logNotFound("server_config.defense_duration", "1");
        }
        try {
            this.fleeGoodProbability = parseResult.getLong("server_config.flee_good_probability").intValue();
        }
        catch (NullPointerException e) {
            this.fleeGoodProbability = 90;
            this.logNotFound("server_config.flee_good_probability", "90");
        }
        try {
            this.fleeBadProbability = parseResult.getLong("server_config.flee_bad_probability").intValue();
        }
        catch (NullPointerException e) {
            this.fleeBadProbability = 35;
            this.logNotFound("server_config.flee_bad_probability", "35");
        }
        try {
            this.minimumHitPercentage = parseResult.getLong("server_config.minimum_hit_percentage").intValue();
            if (this.minimumHitPercentage < 1) {
                this.minimumHitPercentage = 1;
            }
        }
        catch (NullPointerException e) {
            this.minimumHitPercentage = 4;
            this.logNotFound("server_config.minimum_hit_percentage", "4");
        }
        try {
            this.battleDecisionDurationNanos = parseResult.getLong("server_config.battle_turn_time_seconds") * 1000000000L;
            if (this.battleDecisionDurationNanos < 5000000000L) {
                this.battleDecisionDurationNanos = 5000000000L;
                this.logger.warn("Config \"server_config.battle_turn_time_seconds\" too low, defaulting to minimum \"5\"");
            } else if (this.battleDecisionDurationNanos > 60000000000L) {
                this.battleDecisionDurationNanos = 60000000000L;
                this.logger.warn("Config \"server_config.battle_turn_time_seconds\" too high, defaulting to maximum \"60\"");
            }
        }
        catch (NullPointerException e) {
            this.battleDecisionDurationNanos = 15000000000L;
            this.logNotFound("server_config.battle_turn_time_seconds", "15");
        }
        TomlArray entityArray = parseResult.getArray("server_config.entity");
        if (entityArray != null) {
            for (i = 0; i < entityArray.size(); ++i) {
                String name;
                EntityInfo eInfo;
                TomlTable entity;
                block96: {
                    block95: {
                        block94: {
                            block93: {
                                entity = entityArray.getTable(i);
                                eInfo = new EntityInfo();
                                name = null;
                                if (entity.contains("name") && entity.contains("custom_name")) {
                                    this.logger.error("Entity cannot have both \"name\" and \"custom_name\" entries");
                                    continue;
                                }
                                if (entity.contains("name")) {
                                    try {
                                        eInfo.classType = Class.forName(entity.getString("name"));
                                        name = eInfo.classType.getName();
                                        break block93;
                                    }
                                    catch (ClassNotFoundException e) {
                                        this.logger.error("Entity with class name \"" + entity.getString("name") + "\" not found, skipping...");
                                        continue;
                                    }
                                }
                                if (entity.contains("custom_name")) {
                                    name = eInfo.customName = entity.getString("custom_name");
                                } else {
                                    this.logger.error("Entity must have \"name\" or \"custom_name\" entry");
                                    continue;
                                }
                            }
                            try {
                                eInfo.attackPower = entity.getLong("attack_power").intValue();
                                if (eInfo.attackPower >= 0) break block94;
                                eInfo.attackPower = 0;
                                this.logEntityInvalidValue("attack_power", name, "0");
                            }
                            catch (NullPointerException e) {
                                this.logEntityMissingRequiredValue("attack_power", name);
                                continue;
                            }
                        }
                        try {
                            eInfo.attackProbability = entity.getLong("attack_probability").intValue();
                            if (eInfo.attackProbability >= 0 && eInfo.attackProbability <= 100) break block95;
                            eInfo.attackProbability = 35;
                            this.logEntityInvalidValue("attack_probability", name, "35");
                        }
                        catch (NullPointerException e) {
                            this.logEntityMissingRequiredValue("attack_probability", name);
                            continue;
                        }
                    }
                    try {
                        eInfo.attackEffect = EntityInfo.Effect.fromString(entity.getString("attack_effect"));
                        if (eInfo.attackEffect != EntityInfo.Effect.UNKNOWN) {
                            eInfo.attackEffectProbability = entity.getLong("attack_effect_probability").intValue();
                            if (eInfo.attackEffectProbability < 0 || eInfo.attackEffectProbability > 100) {
                                eInfo.attackEffectProbability = 35;
                                this.logEntityInvalidValue("attack_effect", name, "35");
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        eInfo.attackEffect = EntityInfo.Effect.UNKNOWN;
                        this.logEntityMissingOptionalValue("attack_effect", name, "unknown");
                    }
                    try {
                        eInfo.attackVariance = entity.getLong("attack_variance").intValue();
                        if (eInfo.attackVariance < 0) {
                            eInfo.attackVariance = 0;
                            this.logEntityInvalidValue("attack_variance", name, "0");
                        }
                    }
                    catch (NullPointerException e) {
                        eInfo.attackVariance = 0;
                        this.logEntityMissingOptionalValue("attack_variance", name, "0");
                    }
                    try {
                        eInfo.defenseDamage = entity.getLong("defense_damage").intValue();
                        if (eInfo.defenseDamage < 0) {
                            eInfo.defenseDamage = 0;
                            this.logEntityInvalidValue("defense_damage", name, "0");
                        } else {
                            eInfo.defenseDamageProbability = entity.getLong("defense_damage_probability").intValue();
                            if (eInfo.defenseDamageProbability < 0 || eInfo.defenseDamageProbability > 100) {
                                eInfo.defenseDamageProbability = 35;
                                this.logEntityInvalidValue("defense_damage_probability", name, "35");
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        eInfo.defenseDamage = 0;
                        this.logEntityMissingOptionalValue("defense_damage", name, "0");
                    }
                    try {
                        eInfo.evasion = entity.getLong("evasion").intValue();
                        if (eInfo.evasion >= 0 && eInfo.evasion <= 100) break block96;
                        eInfo.evasion = 20;
                        this.logEntityInvalidValue("evasion", name, "20");
                    }
                    catch (NullPointerException e) {
                        this.logEntityMissingRequiredValue("evasion", name);
                        continue;
                    }
                }
                try {
                    eInfo.speed = entity.getLong("speed").intValue();
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("speed", name);
                    continue;
                }
                try {
                    eInfo.ignoreBattle = entity.getBoolean("ignore_battle");
                }
                catch (NullPointerException e) {
                    eInfo.ignoreBattle = false;
                    this.logEntityMissingOptionalValue("ignore_battle", name, "false");
                }
                eInfo.category = entity.getString("category");
                if (eInfo.category == null) {
                    this.logEntityMissingRequiredValue("category", name);
                    continue;
                }
                try {
                    eInfo.decisionAttack = entity.getLong("decision_attack_probability").intValue();
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_attack_probability", name);
                    continue;
                }
                try {
                    eInfo.decisionDefend = entity.getLong("decision_defend_probability").intValue();
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_defend_probability", name);
                    continue;
                }
                try {
                    eInfo.decisionFlee = entity.getLong("decision_flee_probability").intValue();
                }
                catch (NullPointerException e) {
                    this.logEntityMissingRequiredValue("decision_flee_probability", name);
                    continue;
                }
                if (eInfo.classType != null) {
                    this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
                    continue;
                }
                if (!eInfo.customName.isEmpty()) {
                    this.customEntityInfoMap.put(eInfo.customName, eInfo);
                    continue;
                }
                this.logger.error("Cannot add entity to internal config, no \"name\" or \"custom_name\"");
            }
        }
        return true;
    }

    private void logNotFound(String option) {
        this.logger.warn("Config option \"" + option + "\" not found, setting defaults");
    }

    private void logNotFound(String option, String defaultValue) {
        this.logger.warn("Config option \"" + option + "\" not found, defaulting to \"" + defaultValue + "\"");
    }

    private void logEntityInvalidValue(String option, String name, String defaultValue) {
        this.logger.warn("Invalid \"" + option + "\" for \"" + name + "\", defaulting to " + defaultValue);
    }

    private void logEntityMissingRequiredValue(String option, String name) {
        this.logger.error("Entity \"" + name + "\" does not have option \"" + option + "\", skipping...");
    }

    private void logEntityMissingOptionalValue(String option, String name, String defaultValue) {
        this.logger.info("Entity \"" + name + "\" does not have optional option \"" + option + "\", defaulting to \"" + defaultValue + "\"...");
    }

    private String getRegexEntityName(String name) {
        String regex = "^\\s*name\\s*=\\s*";
        regex = regex + "(\"" + name + "\"";
        regex = regex + "|'" + name + "'";
        regex = regex + "|\"\"\"" + name + "\"\"\"";
        regex = regex + "|'''" + name + "''')";
        return regex;
    }

    private String getRegexCustomEntityName(String name) {
        String regex = "^\\s*custom_name\\s*=\\s*";
        regex = regex + "(\"" + name + "\"";
        regex = regex + "|'" + name + "'";
        regex = regex + "|\"\"\"" + name + "\"\"\"";
        regex = regex + "|'''" + name + "''')";
        return regex;
    }

    private boolean addEntityEntry(EntityInfo eInfo) {
        if (eInfo.classType == null && eInfo.customName.isEmpty()) {
            this.logger.error("addEntityEntry: Got invalid eInfo, no name of any type");
            return false;
        }
        try {
            File config = new File("config/TurnBasedMinecraft/TBM_Config.toml");
            FileWriter fw = new FileWriter(config, true);
            fw.write("[[server_config.entity]]\n");
            if (eInfo.classType != null) {
                fw.write("name = \"" + eInfo.classType.getName() + "\"\n");
            } else {
                fw.write("custom_name = \"" + eInfo.customName + "\"\n");
            }
            fw.write("attack_power = " + eInfo.attackPower + "\n");
            fw.write("attack_probability = " + eInfo.attackProbability + "\n");
            if (eInfo.attackVariance > 0) {
                fw.write("attack_variance = " + eInfo.attackVariance + "\n");
            }
            if (eInfo.attackEffect != EntityInfo.Effect.UNKNOWN && eInfo.attackEffectProbability > 0) {
                fw.write("attack_effect = \"" + eInfo.attackEffect.toString() + "\"\n");
                fw.write("attack_effect_probability = " + eInfo.attackEffectProbability + "\n");
            }
            if (eInfo.defenseDamage > 0 && eInfo.defenseDamageProbability > 0) {
                fw.write("defense_damage = " + eInfo.defenseDamage + "\n");
                fw.write("defense_damage_probability = " + eInfo.defenseDamageProbability + "\n");
            }
            fw.write("evasion = " + eInfo.evasion + "\n");
            fw.write("speed = " + eInfo.speed + "\n");
            if (eInfo.ignoreBattle) {
                fw.write("ignore_battle = true\n");
            }
            fw.write("category = \"" + eInfo.category + "\"\n");
            fw.write("decision_attack_probability = " + eInfo.decisionAttack + "\n");
            fw.write("decision_defend_probability = " + eInfo.decisionDefend + "\n");
            fw.write("decision_flee_probability = " + eInfo.decisionFlee + "\n");
            fw.close();
            if (eInfo.classType != null) {
                this.entityInfoMap.put(eInfo.classType.getName(), eInfo);
            } else {
                this.customEntityInfoMap.put(eInfo.customName, eInfo);
            }
        }
        catch (Throwable t) {
            if (eInfo.classType != null) {
                this.logger.error("Failed to add entity entry (name = \"" + eInfo.classType.getName() + "\")");
            } else {
                this.logger.error("Failed to add custom entity entry (custom_name = \"" + eInfo.customName + "\")");
            }
            return false;
        }
        return true;
    }

    protected boolean editEntityEntry(EntityInfo eInfo) {
        try {
            Matcher m;
            Pattern p;
            String cached = new String();
            char[] buf = new char[1024];
            int read = 0;
            File config = new File("config/TurnBasedMinecraft/TBM_Config.toml");
            FileReader fr = new FileReader(config);
            read = fr.read(buf);
            while (read != -1) {
                cached = cached + String.valueOf(buf, 0, read);
                read = fr.read(buf);
            }
            fr.close();
            int nameIndex = -1;
            if (eInfo.classType != null) {
                p = Pattern.compile(this.getRegexEntityName(eInfo.classType.getName()), 8);
                m = p.matcher(cached);
                if (m.find()) {
                    nameIndex = m.start();
                }
            } else if (!eInfo.customName.isEmpty()) {
                p = Pattern.compile(this.getRegexCustomEntityName(eInfo.customName), 8);
                m = p.matcher(cached);
                if (m.find()) {
                    nameIndex = m.start();
                }
            } else {
                this.logger.error("EntityInfo does not have classType or customName, cannot edit/add");
                return false;
            }
            int entryIndex = -1;
            int nextIndex = -1;
            if (nameIndex != -1) {
                Pattern p2 = Pattern.compile("^\\s*\\[\\[\\s*server_config\\s*\\.\\s*entity\\s*]]", 8);
                Matcher m2 = p2.matcher(cached.substring(0, nameIndex));
                while (m2.find()) {
                    entryIndex = m2.start();
                }
                if (entryIndex == -1) {
                    this.logger.warn("editEntityEntry: could not find header for entry \"" + eInfo.classType.getName() + "\", skipping to adding it...");
                    return this.addEntityEntry(eInfo);
                }
                p2 = Pattern.compile("^\\s*\\[", 8);
                m2 = p2.matcher(cached.substring(nameIndex));
                if (m2.find()) {
                    nextIndex = m2.start() + nameIndex;
                }
            } else {
                if (eInfo.classType != null) {
                    this.logger.warn("editEntityEntry: could not find entry for \"" + eInfo.classType.getName() + "\", skipping to adding it...");
                } else if (!eInfo.customName.isEmpty()) {
                    this.logger.warn("editEntityEntry: could not find entry for \"" + eInfo.customName + "\", skipping to adding it...");
                }
                return this.addEntityEntry(eInfo);
            }
            String cut = null;
            cut = nextIndex != -1 ? cached.substring(0, entryIndex) + cached.substring(nextIndex) : cached.substring(0, entryIndex);
            FileWriter fw = new FileWriter(config);
            fw.write(cut);
            fw.close();
            return this.addEntityEntry(eInfo);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int getPlayerSpeed() {
        return this.playerSpeed;
    }

    public int getPlayerHasteSpeed() {
        return this.playerHasteSpeed;
    }

    public int getPlayerSlowSpeed() {
        return this.playerSlowSpeed;
    }

    public int getPlayerAttackProbability() {
        return this.playerAttackProbability;
    }

    public int getPlayerEvasion() {
        return this.playerEvasion;
    }

    public int getDefenseDuration() {
        return this.defenseDuration;
    }

    public int getFleeGoodProbability() {
        return this.fleeGoodProbability;
    }

    public int getFleeBadProbability() {
        return this.fleeBadProbability;
    }

    public EntityInfo getEntityInfo(String classFullName) {
        EntityInfo eInfo = this.entityInfoMap.get(classFullName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getEntityInfoReference(String classFullName) {
        return this.entityInfoMap.get(classFullName);
    }

    protected EntityInfo getMatchingEntityInfo(Object entity) {
        if (entity == null) {
            return null;
        }
        EntityInfo matching = this.entityInfoMap.get(entity.getClass().getName());
        if (matching != null && matching.classType.isInstance(entity)) {
            return matching;
        }
        return null;
    }

    public EntityInfo getCustomEntityInfo(String customName) {
        EntityInfo eInfo = this.customEntityInfoMap.get(customName);
        if (eInfo != null) {
            eInfo = eInfo.clone();
        }
        return eInfo;
    }

    protected EntityInfo getCustomEntityInfoReference(String customName) {
        return this.customEntityInfoMap.get(customName);
    }

    private int getConfigFileVersion(InputStream io) {
        int version = 0;
        try {
            TomlParseResult result = Toml.parse(io, TomlVersion.V0_5_0);
            version = result.getLong("version").intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    private int getConfigFileVersion(File configFile) {
        int version = 0;
        try {
            TomlParseResult result = Toml.parse(configFile.toPath(), TomlVersion.V0_5_0);
            version = result.getLong("version").intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public boolean isIgnoreBattleType(String type) {
        return this.ignoreBattleTypes.contains(type);
    }

    public int getMinimumHitPercentage() {
        return this.minimumHitPercentage;
    }

    public int getMaxInBattle() {
        return this.maxInBattle;
    }

    public boolean isBattleMusicType(String type) {
        return this.musicBattleTypes.contains(type.toLowerCase());
    }

    public boolean isSillyMusicType(String type) {
        return this.musicSillyTypes.contains(type.toLowerCase());
    }

    public boolean isFreezeCombatantsEnabled() {
        return this.freezeCombatantsInBattle;
    }

    public int getSillyMusicThreshold() {
        return this.sillyMusicThreshold;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public long getDecisionDurationNanos() {
        return this.battleDecisionDurationNanos;
    }

    public int getDecisionDurationSeconds() {
        return (int)(this.battleDecisionDurationNanos / 1000000000L);
    }

    protected void addBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.add(id);
    }

    protected void removeBattleIgnoringPlayer(int id) {
        this.battleIgnoringPlayers.remove(id);
    }

    protected void clearBattleIgnoringPlayers() {
        this.battleIgnoringPlayers.clear();
    }

    protected Set<Integer> getBattleIgnoringPlayers() {
        return this.battleIgnoringPlayers;
    }

    public boolean getIfOnlyOPsCanDisableTurnBasedForSelf() {
        return this.onlyOPsSelfDisableTB;
    }

    protected void setBattleDisabledForAll(boolean isDisabled) {
        this.battleDisabledForAll = isDisabled;
    }

    protected boolean getBattleDisabledForAll() {
        return this.battleDisabledForAll;
    }

    public boolean isOldBattleBehaviorEnabled() {
        return this.oldBattleBehaviorEnabled;
    }

    public int getLeaveBattleCooldownSeconds() {
        return this.leaveBattleCooldownSeconds;
    }

    public long getLeaveBattleCooldownNanos() {
        return (long)this.leaveBattleCooldownSeconds * 1000000000L;
    }

    public int getAggroStartBattleDistance() {
        return this.aggroStartBattleDistance;
    }
}

