/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common;

import com.seodisparate.TurnBasedMinecraft.common.AttackEventHandler;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMDisable;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMDisableAll;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMEdit;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMEnable;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMEnableAll;
import com.seodisparate.TurnBasedMinecraft.common.CommandTBMSet;
import com.seodisparate.TurnBasedMinecraft.common.CommonProxy;
import com.seodisparate.TurnBasedMinecraft.common.PlayerJoinEventHandler;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleMessage;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketBattleRequestInfo;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketEditingMessage;
import com.seodisparate.TurnBasedMinecraft.common.networking.PacketGeneralMessage;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="com.seodisparate.turnbasedminecraft", name="Turn Based Minecraft Mod", version="1.8")
public class TurnBasedMinecraftMod {
    public static final String MODID = "com.seodisparate.turnbasedminecraft";
    public static final String NAME = "Turn Based Minecraft Mod";
    public static final String VERSION = "1.8";
    public static final String CONFIG_FILENAME = "TBM_Config.toml";
    public static final String CONFIG_DIRECTORY = "config/TurnBasedMinecraft/";
    public static final String CONFIG_FILE_PATH = "config/TurnBasedMinecraft/TBM_Config.toml";
    public static final String CONFIG_INTERNAL_PATH = "/assets/TurnBasedMinecraft/TBM_Config.toml";
    public static final String MUSIC_ROOT = "config/TurnBasedMinecraft/Music/";
    public static final String MUSIC_SILLY = "config/TurnBasedMinecraft/Music/silly/";
    public static final String MUSIC_BATTLE = "config/TurnBasedMinecraft/Music/battle/";
    public static final SimpleNetworkWrapper NWINSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("seodisparate.tbmc");
    protected static Logger logger;
    private static int packetHandlerID;
    @SidedProxy(modId="com.seodisparate.turnbasedminecraft", serverSide="com.seodisparate.TurnBasedMinecraft.common.CommonProxy", clientSide="com.seodisparate.TurnBasedMinecraft.client.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.setLogger(logger);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.initialize();
        NWINSTANCE.registerMessage(PacketBattleInfo.HandlerBattleInfo.class, PacketBattleInfo.class, packetHandlerID++, Side.CLIENT);
        NWINSTANCE.registerMessage(PacketBattleRequestInfo.HandlerBattleRequestInfo.class, PacketBattleRequestInfo.class, packetHandlerID++, Side.SERVER);
        NWINSTANCE.registerMessage(PacketBattleDecision.HandleBattleDecision.class, PacketBattleDecision.class, packetHandlerID++, Side.SERVER);
        NWINSTANCE.registerMessage(PacketBattleMessage.HandlerBattleMessage.class, PacketBattleMessage.class, packetHandlerID++, Side.CLIENT);
        NWINSTANCE.registerMessage(PacketGeneralMessage.HandlerGeneralMessage.class, PacketGeneralMessage.class, packetHandlerID++, Side.CLIENT);
        NWINSTANCE.registerMessage(PacketEditingMessage.HandlerEditingMessage.class, PacketEditingMessage.class, packetHandlerID++, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new AttackEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerJoinEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        logger.debug("About to initialize BattleManager");
        if (proxy.initializeBattleManager()) {
            logger.debug("Initialized BattleManager");
        }
        proxy.getConfig().clearBattleIgnoringPlayers();
        event.registerServerCommand((ICommand)new CommandTBMDisable(proxy.getConfig()));
        event.registerServerCommand((ICommand)new CommandTBMEnable(proxy.getConfig()));
        event.registerServerCommand((ICommand)new CommandTBMSet(proxy.getConfig()));
        event.registerServerCommand((ICommand)new CommandTBMDisableAll(proxy.getConfig()));
        event.registerServerCommand((ICommand)new CommandTBMEnableAll(proxy.getConfig()));
        event.registerServerCommand((ICommand)new CommandTBMEdit(proxy.getConfig()));
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        logger.debug("About to cleanup BattleManager");
        if (proxy.cleanupBattleManager()) {
            logger.debug("Cleaned up BattleManager");
        }
    }

    static {
        packetHandlerID = 0;
    }
}

