/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common.networking;

import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBattleInfo
implements IMessage {
    private Collection<Integer> sideA;
    private Collection<Integer> sideB;
    private long decisionNanos;

    public PacketBattleInfo() {
        this.sideA = new ArrayList<Integer>();
        this.sideB = new ArrayList<Integer>();
        this.decisionNanos = TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos();
    }

    public PacketBattleInfo(Collection<Integer> sideA, Collection<Integer> sideB, long decisionNanos) {
        this.sideA = sideA;
        this.sideB = sideB;
        this.decisionNanos = decisionNanos;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int sideACount = buf.readInt();
        int sideBCount = buf.readInt();
        for (i = 0; i < sideACount; ++i) {
            this.sideA.add(buf.readInt());
        }
        for (i = 0; i < sideBCount; ++i) {
            this.sideB.add(buf.readInt());
        }
        this.decisionNanos = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.sideA.size());
        buf.writeInt(this.sideB.size());
        for (Integer id : this.sideA) {
            buf.writeInt(id.intValue());
        }
        for (Integer id : this.sideB) {
            buf.writeInt(id.intValue());
        }
        buf.writeLong(this.decisionNanos);
    }

    public static class HandlerBattleInfo
    implements IMessageHandler<PacketBattleInfo, IMessage> {
        public IMessage onMessage(PacketBattleInfo message, MessageContext ctx) {
            Entity e;
            if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
                return null;
            }
            TurnBasedMinecraftMod.proxy.getLocalBattle().clearCombatants();
            for (Integer id : message.sideA) {
                e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id.intValue());
                if (e == null) continue;
                TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideA(e);
            }
            for (Integer id : message.sideB) {
                e = Minecraft.func_71410_x().field_71441_e.func_73045_a(id.intValue());
                if (e == null) continue;
                TurnBasedMinecraftMod.proxy.getLocalBattle().addCombatantToSideB(e);
            }
            TurnBasedMinecraftMod.proxy.setBattleGuiTime((int)(message.decisionNanos / 1000000000L));
            TurnBasedMinecraftMod.proxy.setBattleGuiBattleChanged();
            return null;
        }
    }
}

