/*
 * Decompiled with CFR 0.152.
 */
package com.seodisparate.TurnBasedMinecraft.common.networking;

import com.seodisparate.TurnBasedMinecraft.common.EntityInfo;
import com.seodisparate.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEditingMessage
implements IMessage {
    Type type = Type.ATTACK_ENTITY;
    EntityInfo entityInfo = new EntityInfo();

    public PacketEditingMessage() {
    }

    public PacketEditingMessage(Type type) {
        this.type = type;
    }

    public PacketEditingMessage(Type type, EntityInfo entityInfo) {
        this.type = type;
        if (entityInfo != null) {
            this.entityInfo = entityInfo;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.valueOf(buf.readInt());
        try {
            this.entityInfo.classType = this.getClass().getClassLoader().loadClass(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.entityInfo.ignoreBattle = buf.readBoolean();
        this.entityInfo.attackPower = buf.readInt();
        this.entityInfo.attackProbability = buf.readInt();
        this.entityInfo.attackVariance = buf.readInt();
        this.entityInfo.attackEffect = EntityInfo.Effect.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entityInfo.attackEffectProbability = buf.readInt();
        this.entityInfo.defenseDamage = buf.readInt();
        this.entityInfo.defenseDamageProbability = buf.readInt();
        this.entityInfo.evasion = buf.readInt();
        this.entityInfo.speed = buf.readInt();
        this.entityInfo.category = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.entityInfo.decisionAttack = buf.readInt();
        this.entityInfo.decisionDefend = buf.readInt();
        this.entityInfo.decisionFlee = buf.readInt();
        this.entityInfo.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.getValue());
        if (this.entityInfo.classType != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityInfo.classType.getName());
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"unknown");
        }
        buf.writeBoolean(this.entityInfo.ignoreBattle);
        buf.writeInt(this.entityInfo.attackPower);
        buf.writeInt(this.entityInfo.attackProbability);
        buf.writeInt(this.entityInfo.attackVariance);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityInfo.attackEffect.toString());
        buf.writeInt(this.entityInfo.attackEffectProbability);
        buf.writeInt(this.entityInfo.defenseDamage);
        buf.writeInt(this.entityInfo.defenseDamageProbability);
        buf.writeInt(this.entityInfo.evasion);
        buf.writeInt(this.entityInfo.speed);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityInfo.category);
        buf.writeInt(this.entityInfo.decisionAttack);
        buf.writeInt(this.entityInfo.decisionDefend);
        buf.writeInt(this.entityInfo.decisionFlee);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityInfo.customName);
    }

    public static class HandlerEditingMessage
    implements IMessageHandler<PacketEditingMessage, IMessage> {
        public IMessage onMessage(PacketEditingMessage message, MessageContext ctx) {
            switch (message.type) {
                case ATTACK_ENTITY: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("Attack the entity you want to edit for TurnBasedMinecraftMod. ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    TextComponentString cancel = new TextComponentString("Cancel");
                    cancel.func_150256_b().func_150238_a(TextFormatting.RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel"));
                    text.func_150257_a((ITextComponent)cancel);
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case PICK_EDIT: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("Edit what value? ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    TextComponentString option = new TextComponentString("IgB");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("IgnoreBattle")));
                    TextComponentString value = new TextComponentString("(" + message.entityInfo.ignoreBattle + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("AP");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("AttackPower")));
                    value = new TextComponentString("(" + message.entityInfo.attackPower + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("APr");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("AttackProbability")));
                    value = new TextComponentString("(" + message.entityInfo.attackProbability + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("AV");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("AttackVariance")));
                    value = new TextComponentString("(" + message.entityInfo.attackVariance + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("AE");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("AttackEffect")));
                    value = new TextComponentString("(" + message.entityInfo.attackEffect.toString() + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("AEPr");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("AttackEffectProbability")));
                    value = new TextComponentString("(" + message.entityInfo.attackEffectProbability + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("DD");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("DefenseDamage")));
                    value = new TextComponentString("(" + message.entityInfo.defenseDamage + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("DDPr");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("DefenseDamageProbability")));
                    value = new TextComponentString("(" + message.entityInfo.defenseDamageProbability + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("E");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Evasion")));
                    value = new TextComponentString("(" + message.entityInfo.evasion + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("S");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Speed")));
                    value = new TextComponentString("(" + message.entityInfo.speed + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("C");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Category")));
                    value = new TextComponentString("(" + message.entityInfo.category + ") ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("DecA");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("DecisionAttack")));
                    value = new TextComponentString("(" + message.entityInfo.decisionAttack + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("DecD");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("DecisionDefend")));
                    value = new TextComponentString("(" + message.entityInfo.decisionDefend + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("DecF");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("DecisionFlee")));
                    value = new TextComponentString("(" + message.entityInfo.decisionFlee + "%) ");
                    value.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    option.func_150257_a((ITextComponent)value);
                    text.func_150257_a((ITextComponent)option);
                    option = new TextComponentString("Finished Editing");
                    option.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit finish"));
                    text.func_150257_a((ITextComponent)option).func_150258_a(" ");
                    option = new TextComponentString("Cancel");
                    option.func_150256_b().func_150238_a(TextFormatting.RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit cancel"));
                    text.func_150257_a((ITextComponent)option);
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_IGNORE_BATTLE: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("ignoreBattle: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    TextComponentString option = new TextComponentString("true");
                    option.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle true"));
                    text.func_150257_a((ITextComponent)option);
                    text.func_150258_a(" ");
                    option = new TextComponentString("false");
                    option.func_150256_b().func_150238_a(TextFormatting.RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit ignoreBattle false"));
                    text.func_150257_a((ITextComponent)option);
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_ATTACK_POWER: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("attackPower: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponentString option = new TextComponentString(Integer.toString(i));
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackPower " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 15) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit attackPower <integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_ATTACK_PROBABILITY: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("attackProbability: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 10; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackProbability " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit attackProbability <percentage-integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_ATTACK_VARIANCE: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("attackVariance: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 10; ++i) {
                        TextComponentString option = new TextComponentString(Integer.toString(i));
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackVariance " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 10) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit attackVariance <integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_ATTACK_EFFECT: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("attackEffect: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (EntityInfo.Effect e : EntityInfo.Effect.values()) {
                        TextComponentString option = new TextComponentString(e.toString());
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffect " + e.toString()));
                        text.func_150257_a((ITextComponent)option);
                        if (e == EntityInfo.Effect.UNKNOWN) continue;
                        text.func_150258_a(", ");
                    }
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_ATTACK_EFFECT_PROBABILITY: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("attackEffectProbability: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit attackEffectProbability " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit attackEffectProbability <percentage-integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("defenseDamage: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 15; ++i) {
                        TextComponentString option = new TextComponentString(Integer.toString(i));
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamage " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 15) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit defenseDamage <integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_DEFENSE_DAMAGE_PROBABILITY: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("defenseDamageProbability: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit defenseDamageProbability " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit defenseDamageProbability <percentage-integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_EVASION: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("evasion: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit evasion " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit evasion <percentage-integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_SPEED: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("speed: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i));
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit speed " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    text.func_150258_a(" (or use command \"/tbm-edit edit speed <integer>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_CATEGORY: {
                    TextComponentString optionInfoBool;
                    TextComponentString optionInfo;
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("category: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    TextComponentString option = new TextComponentString("monster");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category monster"));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("monster")) {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("disabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.RED);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    } else {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("enabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    }
                    text.func_150257_a((ITextComponent)option).func_150258_a(", ");
                    option = new TextComponentString("animal");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category animal"));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("animal")) {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("disabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.RED);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    } else {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("enabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    }
                    text.func_150257_a((ITextComponent)option).func_150258_a(", ");
                    option = new TextComponentString("passive");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category passive"));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("passive")) {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("disabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.RED);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    } else {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("enabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    }
                    text.func_150257_a((ITextComponent)option).func_150258_a(", ");
                    option = new TextComponentString("boss");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category boss"));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("boss")) {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("disabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.RED);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    } else {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("enabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    }
                    text.func_150257_a((ITextComponent)option).func_150258_a(", ");
                    option = new TextComponentString("player");
                    option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit category player"));
                    if (TurnBasedMinecraftMod.proxy.getConfig().isIgnoreBattleType("player")) {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("disabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.RED);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    } else {
                        optionInfo = new TextComponentString("(battle-");
                        optionInfo.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        optionInfoBool = new TextComponentString("enabled");
                        optionInfoBool.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        optionInfo.func_150257_a((ITextComponent)optionInfoBool).func_150258_a(")");
                        option.func_150257_a((ITextComponent)optionInfo);
                    }
                    text.func_150257_a((ITextComponent)option);
                    text.func_150258_a(" (or use command \"/tbm-edit edit category <string>\")");
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_DECISION_ATTACK: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("decisionAttack: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionAttack " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_DECISION_DEFEND: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("decisionDefend: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionDefend " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
                case EDIT_DECISION_FLEE: {
                    TextComponentString prefix = new TextComponentString("TBM: ");
                    prefix.func_150256_b().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true));
                    TextComponentString text = new TextComponentString("decisionFlee: ");
                    text.func_150256_b().func_150238_a(TextFormatting.WHITE).func_150227_a(Boolean.valueOf(false));
                    for (int i = 0; i <= 100; i += 10) {
                        TextComponentString option = new TextComponentString(Integer.toString(i) + "%");
                        option.func_150256_b().func_150238_a(TextFormatting.YELLOW).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tbm-edit edit decisionFlee " + Integer.toString(i)));
                        text.func_150257_a((ITextComponent)option);
                        if (i >= 100) continue;
                        text.func_150258_a(", ");
                    }
                    prefix.func_150257_a((ITextComponent)text);
                    TurnBasedMinecraftMod.proxy.displayTextComponent((ITextComponent)prefix);
                    break;
                }
            }
            return null;
        }
    }

    public static enum Type {
        ATTACK_ENTITY(0),
        PICK_EDIT(1),
        EDIT_IGNORE_BATTLE(2),
        EDIT_ATTACK_POWER(3),
        EDIT_ATTACK_PROBABILITY(4),
        EDIT_ATTACK_VARIANCE(5),
        EDIT_ATTACK_EFFECT(6),
        EDIT_ATTACK_EFFECT_PROBABILITY(7),
        EDIT_DEFENSE_DAMAGE(8),
        EDIT_DEFENSE_DAMAGE_PROBABILITY(9),
        EDIT_EVASION(10),
        EDIT_SPEED(11),
        EDIT_CATEGORY(12),
        EDIT_DECISION_ATTACK(13),
        EDIT_DECISION_DEFEND(14),
        EDIT_DECISION_FLEE(15);

        private static Map<Integer, Type> map;
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, Type>();
            for (Type t : Type.values()) {
                map.put(t.value, t);
            }
        }
    }
}

