/*
 * Decompiled with CFR 0.152.
 */
package shadow.turnbasedmc.net.consensys.cava.toml;

import java.util.List;
import shadow.turnbasedmc.net.consensys.cava.toml.ErrorReporter;
import shadow.turnbasedmc.net.consensys.cava.toml.KeyVisitor;
import shadow.turnbasedmc.net.consensys.cava.toml.MutableTomlTable;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlParseError;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlPosition;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlVersion;
import shadow.turnbasedmc.net.consensys.cava.toml.ValueVisitor;
import shadow.turnbasedmc.net.consensys.cava.toml.internal.TomlParser;
import shadow.turnbasedmc.net.consensys.cava.toml.internal.TomlParserBaseVisitor;

final class LineVisitor
extends TomlParserBaseVisitor<MutableTomlTable> {
    private final MutableTomlTable table;
    private final ErrorReporter errorReporter;
    private final TomlVersion version;
    private MutableTomlTable currentTable;

    LineVisitor(ErrorReporter errorReporter, TomlVersion version) {
        this.currentTable = this.table = new MutableTomlTable();
        this.errorReporter = errorReporter;
        this.version = version;
    }

    @Override
    public MutableTomlTable visitKeyval(TomlParser.KeyvalContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        TomlParser.ValContext valContext = ctx.val();
        if (keyContext == null || valContext == null) {
            return this.table;
        }
        try {
            List<String> path = keyContext.accept(new KeyVisitor());
            if (path == null || path.isEmpty()) {
                return this.table;
            }
            if (!this.version.after(TomlVersion.V0_4_0) && path.size() > 1) {
                throw new TomlParseError("Dotted keys are not supported", new TomlPosition(keyContext));
            }
            Object value = valContext.accept(new ValueVisitor());
            if (value != null) {
                this.currentTable.set(path, value, new TomlPosition(ctx));
            }
            return this.table;
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
            return this.table;
        }
    }

    @Override
    public MutableTomlTable visitStandardTable(TomlParser.StandardTableContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.table;
        }
        List<String> path = keyContext.accept(new KeyVisitor());
        if (path == null) {
            return this.table;
        }
        try {
            this.currentTable = this.table.createTable(path, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.table;
    }

    @Override
    public MutableTomlTable visitArrayTable(TomlParser.ArrayTableContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.table;
        }
        List<String> path = keyContext.accept(new KeyVisitor());
        if (path == null) {
            return this.table;
        }
        try {
            this.currentTable = this.table.createArrayTable(path, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.table;
    }

    @Override
    protected MutableTomlTable aggregateResult(MutableTomlTable aggregate, MutableTomlTable nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected MutableTomlTable defaultResult() {
        return this.table;
    }
}

