/*
 * Decompiled with CFR 0.152.
 */
package shadow.turnbasedmc.net.consensys.cava.toml;

import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.turnbasedmc.javax.annotation.Nullable;
import shadow.turnbasedmc.net.consensys.cava.toml.AccumulatingErrorListener;
import shadow.turnbasedmc.net.consensys.cava.toml.KeyVisitor;
import shadow.turnbasedmc.net.consensys.cava.toml.LineVisitor;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlParseError;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlParseResult;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlPosition;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlTable;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlVersion;
import shadow.turnbasedmc.net.consensys.cava.toml.internal.TomlLexer;
import shadow.turnbasedmc.net.consensys.cava.toml.internal.TomlParser;
import shadow.turnbasedmc.org.antlr.v4.runtime.CharStream;
import shadow.turnbasedmc.org.antlr.v4.runtime.CharStreams;
import shadow.turnbasedmc.org.antlr.v4.runtime.CommonTokenStream;

final class Parser {
    private Parser() {
    }

    static TomlParseResult parse(CharStream stream, TomlVersion version) {
        TomlLexer lexer = new TomlLexer(stream);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        final AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        TomlParser.TomlContext tree = parser.toml();
        final TomlTable table = tree.accept(new LineVisitor(errorListener, version));
        return new TomlParseResult(){

            @Override
            public int size() {
                return table.size();
            }

            @Override
            public boolean isEmpty() {
                return table.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                return table.keySet();
            }

            @Override
            public Set<List<String>> keyPathSet(boolean includeTables) {
                return table.keyPathSet(includeTables);
            }

            @Override
            @Nullable
            public Object get(List<String> path) {
                return table.get(path);
            }

            @Override
            @Nullable
            public TomlPosition inputPositionOf(List<String> path) {
                return table.inputPositionOf(path);
            }

            @Override
            public Map<String, Object> toMap() {
                return table.toMap();
            }

            @Override
            public List<TomlParseError> errors() {
                return errorListener.errors();
            }
        };
    }

    static List<String> parseDottedKey(String dottedKey) {
        TomlLexer lexer = new TomlLexer(CharStreams.fromString(dottedKey));
        lexer.mode(1);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        List<String> keyList = parser.tomlKey().accept(new KeyVisitor());
        List<TomlParseError> errors = errorListener.errors();
        if (!errors.isEmpty()) {
            TomlParseError e = errors.get(0);
            throw new IllegalArgumentException("Invalid key: " + e.getMessage(), e);
        }
        return keyList;
    }
}

