/*
 * Decompiled with CFR 0.152.
 */
package shadow.turnbasedmc.net.consensys.cava.toml;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Optional;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlArray;
import shadow.turnbasedmc.net.consensys.cava.toml.TomlTable;

enum TomlType {
    STRING("string", String.class),
    INTEGER("integer", Long.class),
    FLOAT("float", Double.class),
    BOOLEAN("boolean", Boolean.class),
    OFFSET_DATE_TIME("offset date-time", OffsetDateTime.class),
    LOCAL_DATE_TIME("local date-time", LocalDateTime.class),
    LOCAL_DATE("local date", LocalDate.class),
    LOCAL_TIME("local time", LocalTime.class),
    ARRAY("array", TomlArray.class),
    TABLE("table", TomlTable.class);

    private final String name;
    private final Class<?> clazz;

    private TomlType(String name, Class<?> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    static Optional<TomlType> typeFor(Object obj) {
        return TomlType.typeForClass(obj.getClass());
    }

    static Optional<TomlType> typeForClass(Class<?> clazz) {
        return Arrays.stream(TomlType.values()).filter(t -> t.clazz.isAssignableFrom(clazz)).findAny();
    }

    static String typeNameFor(Object obj) {
        return TomlType.typeNameForClass(obj.getClass());
    }

    static String typeNameForClass(Class<?> clazz) {
        return TomlType.typeForClass(clazz).map(t -> t.name).orElseGet(clazz::getSimpleName);
    }

    public String typeName() {
        return this.name;
    }
}

