/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common.networking;

import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleInfo;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class PacketBattleRequestInfo {
    private int battleID;

    public PacketBattleRequestInfo() {
    }

    public PacketBattleRequestInfo(int battleID) {
        this.battleID = battleID;
    }

    public static class Consumer
    implements BiConsumer<PacketBattleRequestInfo, CustomPayloadEvent.Context> {
        @Override
        public void accept(PacketBattleRequestInfo pkt, CustomPayloadEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                Battle b = TurnBasedMinecraftMod.proxy.getBattleManager().getBattleByID(pkt.battleID);
                if (b == null) {
                    return;
                }
                TurnBasedMinecraftMod.getHandler().reply((Object)new PacketBattleInfo(b.getSideAIDs(), b.getSideBIDs(), b.getTimerNanos(), TurnBasedMinecraftMod.proxy.getConfig().getDecisionDurationNanos(), !TurnBasedMinecraftMod.proxy.getConfig().isBattleDecisionDurationForever()), ctx);
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, PacketBattleRequestInfo> {
        @Override
        public PacketBattleRequestInfo apply(FriendlyByteBuf buf) {
            return new PacketBattleRequestInfo(buf.readInt());
        }
    }

    public static class Encoder
    implements BiConsumer<PacketBattleRequestInfo, FriendlyByteBuf> {
        @Override
        public void accept(PacketBattleRequestInfo pkt, FriendlyByteBuf buf) {
            buf.writeInt(pkt.battleID);
        }
    }
}

