/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.EntitySelectionButton;
import com.burnedkirby.TurnBasedMinecraft.client.ItemSelectionButton;
import com.burnedkirby.TurnBasedMinecraft.common.Battle;
import com.burnedkirby.TurnBasedMinecraft.common.Combatant;
import com.burnedkirby.TurnBasedMinecraft.common.TurnBasedMinecraftMod;
import com.burnedkirby.TurnBasedMinecraft.common.networking.PacketBattleDecision;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.PacketDistributor;

public class BattleGui
extends Screen {
    private AtomicInteger timeRemaining = new AtomicInteger(15);
    private int timerMax = this.timeRemaining.get();
    private boolean turnTimerEnabled;
    private long lastInstant = System.nanoTime();
    private long elapsedTime = 0L;
    private MenuState state = MenuState.MAIN_MENU;
    private boolean stateChanged = true;
    private String info;

    public BattleGui() {
        super((Component)Component.m_237113_((String)"Battle Gui"));
    }

    private void setState(MenuState state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void turnBegin() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.ACTION);
        }
        this.setState(MenuState.WAITING);
    }

    public void turnEnd() {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() != null) {
            TurnBasedMinecraftMod.proxy.getLocalBattle().setState(Battle.State.DECISION);
        }
        this.timeRemaining.set(this.timerMax);
        this.elapsedTime = 0L;
        this.lastInstant = System.nanoTime();
        this.setState(MenuState.MAIN_MENU);
    }

    public void battleChanged() {
        this.stateChanged = true;
    }

    public void updateState() {
        if (!this.stateChanged) {
            return;
        }
        this.stateChanged = false;
        this.m_169413_();
        switch (this.state) {
            case MAIN_MENU: {
                this.info = "What will you do?";
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Attack"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ATTACK)).m_252987_(this.f_96543_ * 3 / 7 - 25, 40, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Defend"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DEFEND)).m_252987_(this.f_96543_ * 4 / 7 - 25, 40, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Item"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.ITEM)).m_252987_(this.f_96543_ * 3 / 7 - 25, 60, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Flee"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.FLEE)).m_252987_(this.f_96543_ * 4 / 7 - 25, 60, 50, 20).m_253136_());
                break;
            }
            case ATTACK_TARGET: {
                this.info = "Who will you attack?";
                int y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideAEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.m_142416_(new EntitySelectionButton(this.f_96543_ / 4 - 60, y, 120, 20, e.getValue().entity.m_5446_(), (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.m_142416_(new EntitySelectionButton(this.f_96543_ / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), true, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                y = 30;
                try {
                    for (Map.Entry<Integer, Combatant> e : TurnBasedMinecraftMod.proxy.getLocalBattle().getSideBEntrySet()) {
                        if (e.getValue().entity != null) {
                            this.m_142416_(new EntitySelectionButton(this.f_96543_ * 3 / 4 - 60, y, 120, 20, e.getValue().entity.m_5446_(), (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        } else {
                            this.m_142416_(new EntitySelectionButton(this.f_96543_ * 3 / 4 - 60, y, 120, 20, "Unknown", (int)e.getKey(), false, button -> this.entityButtonActionEvent(button, ButtonAction.ATTACK_TARGET)));
                        }
                        y += 20;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).m_252987_(this.f_96543_ / 2 - 30, this.f_96544_ - 120, 60, 20).m_253136_());
                break;
            }
            case ITEM_ACTION: {
                this.info = "What will you do with an item?";
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Switch Held"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.SWITCH_HELD_ITEM)).m_252987_(this.f_96543_ / 4 - 40, this.f_96544_ - 120, 80, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Use"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.DECIDE_USE_ITEM)).m_252987_(this.f_96543_ * 2 / 4 - 40, this.f_96544_ - 120, 80, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).m_252987_(this.f_96543_ * 3 / 4 - 40, this.f_96544_ - 120, 80, 20).m_253136_());
                break;
            }
            case WAITING: {
                this.info = "Waiting...";
                break;
            }
            case SWITCH_ITEM: {
                this.info = "To which item will you switch to?";
                for (int i = 0; i < 9; ++i) {
                    this.m_142416_(new ItemSelectionButton(this.f_96543_ / 2 - 88 + i * 20, this.f_96544_ - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_ITEM_SWITCH)));
                }
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).m_252987_(this.f_96543_ / 2 - 40, this.f_96544_ - 120, 80, 20).m_253136_());
                break;
            }
            case USE_ITEM: {
                this.info = "Which item will you use?";
                for (int i = 0; i < 9; ++i) {
                    this.m_142416_(new ItemSelectionButton(this.f_96543_ / 2 - 88 + i * 20, this.f_96544_ - 19, 16, 16, i, button -> this.itemButtonActionEvent(button, ButtonAction.DO_USE_ITEM)));
                }
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.buttonActionEvent((AbstractButton)button, ButtonAction.CANCEL)).m_252987_(this.f_96543_ / 2 - 40, this.f_96544_ - 120, 80, 20).m_253136_());
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (TurnBasedMinecraftMod.proxy.getLocalBattle() == null) {
            this.drawString(guiGraphics, "Waiting...", this.f_96543_ / 2 - 50, this.f_96544_ / 2, -1);
            return;
        }
        if (TurnBasedMinecraftMod.proxy.getLocalBattle().getState() == Battle.State.DECISION && this.timeRemaining.get() > 0) {
            long nextInstant = System.nanoTime();
            this.elapsedTime += nextInstant - this.lastInstant;
            this.lastInstant = nextInstant;
            while (this.elapsedTime > 1000000000L) {
                this.elapsedTime -= 1000000000L;
                this.timeRemaining.decrementAndGet();
            }
        }
        this.updateState();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Object timeRemainingString = "Time remaining: ";
        int timeRemainingInt = this.timeRemaining.get();
        timeRemainingString = timeRemainingInt > 8 || !this.turnTimerEnabled ? (String)timeRemainingString + "\u00a7a" : (timeRemainingInt > 4 ? (String)timeRemainingString + "\u00a7e" : (String)timeRemainingString + "\u00a7c");
        timeRemainingString = !this.turnTimerEnabled ? (String)timeRemainingString + "Infinity" : (String)timeRemainingString + Integer.toString(timeRemainingInt);
        int stringWidth = this.f_96547_.m_92895_((String)timeRemainingString);
        guiGraphics.m_280509_(this.f_96543_ / 2 - stringWidth / 2, 5, this.f_96543_ / 2 + stringWidth / 2, 15, 0x70000000);
        this.drawString(guiGraphics, (String)timeRemainingString, this.f_96543_ / 2 - stringWidth / 2, 5, -1);
        stringWidth = this.f_96547_.m_92895_(this.info);
        guiGraphics.m_280509_(this.f_96543_ / 2 - stringWidth / 2, 20, this.f_96543_ / 2 + stringWidth / 2, 30, 0x70000000);
        this.drawString(guiGraphics, this.info, this.f_96543_ / 2 - stringWidth / 2, 20, -1);
    }

    protected void buttonActionEvent(AbstractButton button, ButtonAction action) {
        switch (action) {
            case ATTACK: {
                this.setState(MenuState.ATTACK_TARGET);
                break;
            }
            case DEFEND: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.DEFEND, 0), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            case ITEM: {
                this.setState(MenuState.ITEM_ACTION);
                break;
            }
            case FLEE: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.FLEE, 0), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            case ATTACK_TARGET: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case SWITCH_HELD_ITEM: {
                this.setState(MenuState.SWITCH_ITEM);
                break;
            }
            case DECIDE_USE_ITEM: {
                this.setState(MenuState.USE_ITEM);
                break;
            }
            case CANCEL: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_ITEM_SWITCH: {
                this.setState(MenuState.MAIN_MENU);
                break;
            }
            case DO_USE_ITEM: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    protected void entityButtonActionEvent(EntitySelectionButton button, ButtonAction action) {
        if (action.equals((Object)ButtonAction.ATTACK_TARGET)) {
            TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.ATTACK, button.getID()), PacketDistributor.SERVER.noArg());
            this.setState(MenuState.WAITING);
        } else {
            this.setState(MenuState.MAIN_MENU);
        }
    }

    protected void itemButtonActionEvent(ItemSelectionButton button, ButtonAction action) {
        switch (action) {
            case DO_ITEM_SWITCH: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.SWITCH_ITEM, button.getID()), PacketDistributor.SERVER.noArg());
                if (button.getID() >= 0 && button.getID() < 9) {
                    Minecraft.m_91087_().f_91074_.m_150109_().f_35977_ = button.getID();
                }
                this.setState(MenuState.WAITING);
                break;
            }
            case DO_USE_ITEM: {
                TurnBasedMinecraftMod.getHandler().send((Object)new PacketBattleDecision(TurnBasedMinecraftMod.proxy.getLocalBattle().getId(), Battle.Decision.USE_ITEM, button.getID()), PacketDistributor.SERVER.noArg());
                this.setState(MenuState.WAITING);
                break;
            }
            default: {
                this.setState(MenuState.MAIN_MENU);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int a, int b, int c) {
        if (this.getMinecraft().f_91074_.m_7500_()) {
            return super.m_7933_(a, b, c);
        }
        return false;
    }

    public void m_280273_(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    public boolean m_7920_(int a, int b, int c) {
        if (this.getMinecraft().f_91074_.m_7500_()) {
            return super.m_7920_(a, b, c);
        }
        return false;
    }

    public void setTimeRemaining(int remaining) {
        this.timeRemaining.set(remaining);
    }

    private void drawString(GuiGraphics guiGraphics, String string, int x, int y, int color) {
        guiGraphics.m_280488_(this.f_96547_, string, x, y, color);
    }

    public void setTurnTimerEnabled(boolean enabled) {
        this.turnTimerEnabled = enabled;
    }

    public void setTurnTimerMax(int timerMax) {
        this.timerMax = timerMax;
    }

    private static enum MenuState {
        MAIN_MENU(0),
        ATTACK_TARGET(1),
        ITEM_ACTION(2),
        WAITING(3),
        SWITCH_ITEM(4),
        USE_ITEM(5);

        private int value;
        private static Map<Integer, MenuState> map;

        private MenuState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MenuState valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, MenuState>();
            for (MenuState state : MenuState.values()) {
                map.put(state.getValue(), state);
            }
        }
    }

    private static enum ButtonAction {
        ATTACK(0),
        DEFEND(1),
        ITEM(2),
        FLEE(3),
        ATTACK_TARGET(4),
        SWITCH_HELD_ITEM(5),
        DECIDE_USE_ITEM(6),
        CANCEL(7),
        DO_ITEM_SWITCH(8),
        DO_USE_ITEM(9);

        private int value;
        private static Map<Integer, ButtonAction> map;

        private ButtonAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ButtonAction valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new HashMap<Integer, ButtonAction>();
            for (ButtonAction action : ButtonAction.values()) {
                map.put(action.getValue(), action);
            }
        }
    }
}

