/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.client;

import com.burnedkirby.TurnBasedMinecraft.client.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClientConfigGui
extends Screen {
    private final int widget_height = 20;
    private boolean dirtyFlag = true;
    private boolean accepted = false;
    private EditBox battleListEditBox = null;
    private EditBox sillyListEditBox = null;
    private SliderPercentage sillyMusicThresholdSlider = null;
    private Checkbox affectedByMasterVolCheckbox = null;
    private Checkbox affectedByMusicVolCheckbox = null;
    private SliderPercentage volumeSlider = null;

    public ClientConfigGui() {
        super((Component)Component.literal((String)"TurnBasedMC Client Config"));
    }

    public void onDirty() {
        this.clearWidgets();
        int widget_x_offset = 5;
        int widget_width = this.width / 2 - widget_x_offset * 2;
        int top_offset = 5;
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset, widget_width, 20, (Component)Component.literal((String)"Battle Music Categories"), this.font));
        if (this.battleListEditBox == null) {
            this.battleListEditBox = new EditBox(this.font, this.width / 2 + widget_x_offset, top_offset, widget_width, 20, (Component)Component.literal((String)"Battle Music Categories Edit Box"));
        } else {
            this.battleListEditBox.setPosition(this.width / 2 + widget_x_offset, top_offset);
            this.battleListEditBox.setSize(widget_width, 20);
        }
        Object tempString = "";
        for (String category : (List)ClientConfig.CLIENT.battleMusicList.get()) {
            if (((String)tempString).isEmpty()) {
                tempString = category;
                continue;
            }
            tempString = (String)tempString + "," + category;
        }
        this.battleListEditBox.setMaxLength(128);
        this.battleListEditBox.setValue((String)tempString);
        this.addRenderableWidget((GuiEventListener)this.battleListEditBox);
        this.addRenderableWidget((GuiEventListener)new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset += 20, widget_width, 20, (Component)Component.literal((String)"Silly Music Categories"), this.font));
        if (this.sillyListEditBox == null) {
            this.sillyListEditBox = new EditBox(this.font, this.width / 2 + widget_x_offset, top_offset, widget_width, 20, (Component)Component.literal((String)"Silly Music Categories Edit Box"));
        } else {
            this.sillyListEditBox.setPosition(this.width / 2 + widget_x_offset, top_offset);
            this.sillyListEditBox.setSize(widget_width, 20);
        }
        tempString = "";
        for (String category : (List)ClientConfig.CLIENT.sillyMusicList.get()) {
            if (((String)tempString).isEmpty()) {
                tempString = category;
                continue;
            }
            tempString = (String)tempString + "," + category;
        }
        this.sillyListEditBox.setMaxLength(128);
        this.sillyListEditBox.setValue((String)tempString);
        this.addRenderableWidget((GuiEventListener)this.sillyListEditBox);
        StringWidget stringWidget = new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset += 20, widget_width, 20, (Component)Component.literal((String)"Silly Music Threshold"), this.font);
        stringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"Ratio of minimum of silly mobs in battle to play silly music")));
        this.addRenderableWidget((GuiEventListener)stringWidget);
        if (this.sillyMusicThresholdSlider == null) {
            this.sillyMusicThresholdSlider = new SliderPercentage(this.width / 2 + widget_x_offset, top_offset, widget_width, 20, (Component)Component.literal((String)("Silly Music Threshold: " + String.format("%.1f%%", (Double)ClientConfig.CLIENT.sillyMusicThreshold.get() * 100.0))), (Double)ClientConfig.CLIENT.sillyMusicThreshold.get(), "Silly Music Threshold: ");
        } else {
            this.sillyMusicThresholdSlider.setPosition(this.width / 2 + widget_x_offset, top_offset);
            this.sillyMusicThresholdSlider.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.sillyMusicThresholdSlider);
        stringWidget = new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset += 20, widget_width, 20, (Component)Component.literal((String)"Affected by Master Vol."), this.font);
        stringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"If enabled, volume is affected by global master volume.")));
        this.addRenderableWidget((GuiEventListener)stringWidget);
        if (this.affectedByMasterVolCheckbox == null) {
            this.affectedByMasterVolCheckbox = Checkbox.builder((Component)Component.literal((String)""), (Font)this.font).pos(this.width / 2 + widget_x_offset, top_offset).build();
        } else {
            this.affectedByMasterVolCheckbox.setPosition(this.width / 2 + widget_x_offset, top_offset);
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue() && !this.affectedByMasterVolCheckbox.selected() || !((Boolean)ClientConfig.CLIENT.volumeAffectedByMasterVolume.get()).booleanValue() && this.affectedByMasterVolCheckbox.selected()) {
            this.affectedByMasterVolCheckbox.onPress();
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMasterVolCheckbox);
        stringWidget = new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset += 20, widget_width, 20, (Component)Component.literal((String)"Affected by Music Vol."), this.font);
        stringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"If enabled, volume is affected by global music volume.")));
        this.addRenderableWidget((GuiEventListener)stringWidget);
        if (this.affectedByMusicVolCheckbox == null) {
            this.affectedByMusicVolCheckbox = Checkbox.builder((Component)Component.literal((String)""), (Font)this.font).pos(this.width / 2 + widget_x_offset, top_offset).build();
        } else {
            this.affectedByMusicVolCheckbox.setPosition(this.width / 2 + widget_x_offset, top_offset);
        }
        if (((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue() && !this.affectedByMusicVolCheckbox.selected() || !((Boolean)ClientConfig.CLIENT.volumeAffectedByMusicVolume.get()).booleanValue() && this.affectedByMusicVolCheckbox.selected()) {
            this.affectedByMusicVolCheckbox.onPress();
        }
        this.addRenderableWidget((GuiEventListener)this.affectedByMusicVolCheckbox);
        stringWidget = new StringWidget(this.width / 2 - widget_width + widget_x_offset, top_offset += 20, widget_width, 20, (Component)Component.literal((String)"Music Volume"), this.font);
        stringWidget.setTooltip(Tooltip.create((Component)Component.literal((String)"Volume of battle/silly music")));
        this.addRenderableWidget((GuiEventListener)stringWidget);
        if (this.volumeSlider == null) {
            this.volumeSlider = new SliderPercentage(this.width / 2 + widget_x_offset, top_offset, widget_width, 20, (Component)Component.literal((String)("Volume: " + String.format("%.1f%%", (Double)ClientConfig.CLIENT.musicVolume.get() * 100.0))), (Double)ClientConfig.CLIENT.musicVolume.get(), "Volume: ");
        } else {
            this.volumeSlider.setPosition(this.width / 2 + widget_x_offset, top_offset);
            this.volumeSlider.setSize(widget_width, 20);
        }
        this.addRenderableWidget((GuiEventListener)this.volumeSlider);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> Minecraft.getInstance().setScreen(null)).bounds(this.width / 2 - widget_width + widget_x_offset, this.height - 20, widget_width, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Accept"), b -> {
            this.accepted = true;
        }).bounds(this.width / 2 + widget_x_offset, this.height - 20, widget_width, 20).build());
        this.dirtyFlag = false;
    }

    private void doAccepted() {
        String temp = this.battleListEditBox.getValue();
        ArrayList<String> battleList = new ArrayList<String>();
        for (String category : temp.split(",")) {
            battleList.add(category.strip());
        }
        ClientConfig.CLIENT.battleMusicList.set(battleList);
        temp = this.sillyListEditBox.getValue();
        ArrayList<String> sillyList = new ArrayList<String>();
        for (String category : temp.split(",")) {
            sillyList.add(category.strip());
        }
        ClientConfig.CLIENT.sillyMusicList.set(sillyList);
        ClientConfig.CLIENT.sillyMusicThreshold.set((Object)this.sillyMusicThresholdSlider.percentage);
        ClientConfig.CLIENT.volumeAffectedByMasterVolume.set((Object)this.affectedByMasterVolCheckbox.selected());
        ClientConfig.CLIENT.volumeAffectedByMusicVolume.set((Object)this.affectedByMusicVolCheckbox.selected());
        ClientConfig.CLIENT.musicVolume.set((Object)this.volumeSlider.percentage);
        ClientConfig.CLIENT_SPEC.save();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.accepted) {
            this.doAccepted();
            Minecraft.getInstance().setScreen(null);
            return;
        }
        if (this.dirtyFlag) {
            this.onDirty();
        }
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        this.dirtyFlag = true;
        super.resize(pMinecraft, pWidth, pHeight);
    }

    private static class SliderPercentage
    extends AbstractSliderButton {
        private final String messagePrefix;
        private double percentage;

        public SliderPercentage(int x, int y, int width, int height, Component message, double percentage, String messagePrefix) {
            super(x, y, width, height, message, percentage);
            this.percentage = percentage;
            this.messagePrefix = messagePrefix;
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)(this.messagePrefix + String.format("%.1f%%", this.percentage * 100.0))));
        }

        protected void applyValue() {
            this.percentage = this.value;
        }
    }
}

