/*
 * Decompiled with CFR 0.152.
 */
package com.burnedkirby.TurnBasedMinecraft.common;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class EntityInfo {
    public Class classType;
    public boolean ignoreBattle;
    public int attackPower;
    public int attackProbability;
    public int attackVariance;
    public Effect attackEffect;
    public int attackEffectProbability;
    public int defenseDamage;
    public int defenseDamageProbability;
    public int evasion;
    public int speed;
    public int hasteSpeed;
    public int slowSpeed;
    public String category;
    public int decisionAttack;
    public int decisionDefend;
    public int decisionFlee;
    public String customName;
    public String playerName;

    public EntityInfo() {
        this.classType = null;
        this.ignoreBattle = false;
        this.attackPower = 0;
        this.attackProbability = 70;
        this.attackVariance = 0;
        this.attackEffect = Effect.UNKNOWN;
        this.attackEffectProbability = 50;
        this.defenseDamage = 0;
        this.defenseDamageProbability = 0;
        this.evasion = 15;
        this.speed = 50;
        this.hasteSpeed = 80;
        this.slowSpeed = 20;
        this.category = "unknown";
        this.decisionAttack = 70;
        this.decisionDefend = 20;
        this.decisionFlee = 10;
        this.customName = "";
        this.playerName = "";
    }

    public EntityInfo(Class classType, boolean ignoreBattle, int attackPower, int attackProbability, int attackVariance, Effect attackEffect, int attackEffectProbability, int defenseDamage, int defenseDamageProbability, int evasion, int speed, int hasteSpeed, int slowSpeed, String category, int decisionAttack, int decisionDefend, int decisionFlee, String customName, String playerName) {
        this.classType = classType;
        this.ignoreBattle = ignoreBattle;
        this.attackPower = attackPower;
        this.attackProbability = attackProbability;
        this.attackVariance = attackVariance;
        this.attackEffect = attackEffect;
        this.attackEffectProbability = attackEffectProbability;
        this.defenseDamage = defenseDamage;
        this.defenseDamageProbability = defenseDamageProbability;
        this.evasion = evasion;
        this.speed = speed;
        this.hasteSpeed = hasteSpeed;
        this.slowSpeed = slowSpeed;
        this.category = category;
        this.decisionAttack = decisionAttack;
        this.decisionDefend = decisionDefend;
        this.decisionFlee = decisionFlee;
        this.customName = customName;
        this.playerName = playerName;
    }

    public EntityInfo clone() {
        EntityInfo newEntityInfo = new EntityInfo();
        newEntityInfo.classType = this.classType;
        newEntityInfo.ignoreBattle = this.ignoreBattle;
        newEntityInfo.attackPower = this.attackPower;
        newEntityInfo.attackProbability = this.attackProbability;
        newEntityInfo.attackVariance = this.attackVariance;
        newEntityInfo.attackEffect = this.attackEffect;
        newEntityInfo.attackEffectProbability = this.attackEffectProbability;
        newEntityInfo.defenseDamage = this.defenseDamage;
        newEntityInfo.defenseDamageProbability = this.defenseDamageProbability;
        newEntityInfo.evasion = this.evasion;
        newEntityInfo.speed = this.speed;
        newEntityInfo.hasteSpeed = this.hasteSpeed;
        newEntityInfo.slowSpeed = this.slowSpeed;
        newEntityInfo.category = this.category;
        newEntityInfo.decisionAttack = this.decisionAttack;
        newEntityInfo.decisionDefend = this.decisionDefend;
        newEntityInfo.decisionFlee = this.decisionFlee;
        newEntityInfo.customName = this.customName;
        newEntityInfo.playerName = this.playerName;
        return newEntityInfo;
    }

    public static enum Effect {
        SPEED,
        SLOW,
        HASTE,
        MINING_FATIGUE,
        STRENGTH,
        JUMP_BOOST,
        NAUSEA,
        REGENERATION,
        RESISTANCE,
        FIRE_RESISTANCE,
        WATER_BREATHING,
        INVISIBILITY,
        BLINDNESS,
        NIGHT_VISION,
        HUNGER,
        WEAKNESS,
        POISON,
        WITHER,
        HEALTH_BOOST,
        ABSORPTION,
        SATURATION,
        GLOWING,
        LEVITATION,
        LUCK,
        UNLUCK,
        SLOW_FALLING,
        CONDUIT_POWER,
        DOLPHINS_GRACE,
        BAD_OMEN,
        FIRE,
        UNKNOWN;


        public static Effect fromString(String c) {
            if ((c = c.toLowerCase()).equals("speed")) {
                return SPEED;
            }
            if (c.equals("slow")) {
                return SLOW;
            }
            if (c.equals("haste")) {
                return HASTE;
            }
            if (c.equals("mining_fatigue") || c.equals("fatigue")) {
                return MINING_FATIGUE;
            }
            if (c.equals("strength")) {
                return STRENGTH;
            }
            if (c.equals("jump_boost")) {
                return JUMP_BOOST;
            }
            if (c.equals("nausea")) {
                return NAUSEA;
            }
            if (c.equals("regeneration")) {
                return REGENERATION;
            }
            if (c.equals("resistance")) {
                return RESISTANCE;
            }
            if (c.equals("fire_resistance")) {
                return FIRE_RESISTANCE;
            }
            if (c.equals("water_breathing")) {
                return WATER_BREATHING;
            }
            if (c.equals("invisibility")) {
                return INVISIBILITY;
            }
            if (c.equals("blindness") || c.equals("blind")) {
                return BLINDNESS;
            }
            if (c.equals("night_vision")) {
                return NIGHT_VISION;
            }
            if (c.equals("hunger")) {
                return HUNGER;
            }
            if (c.equals("weakness")) {
                return WEAKNESS;
            }
            if (c.equals("poison")) {
                return POISON;
            }
            if (c.equals("wither")) {
                return WITHER;
            }
            if (c.equals("health_boost")) {
                return HEALTH_BOOST;
            }
            if (c.equals("absorption")) {
                return ABSORPTION;
            }
            if (c.equals("saturation")) {
                return SATURATION;
            }
            if (c.equals("glowing")) {
                return GLOWING;
            }
            if (c.equals("levitation")) {
                return LEVITATION;
            }
            if (c.equals("luck")) {
                return LUCK;
            }
            if (c.equals("unluck")) {
                return UNLUCK;
            }
            if (c.equals("slow_falling")) {
                return SLOW_FALLING;
            }
            if (c.equals("conduit_power")) {
                return CONDUIT_POWER;
            }
            if (c.equals("dolphins_grace")) {
                return DOLPHINS_GRACE;
            }
            if (c.equals("bad_omen")) {
                return BAD_OMEN;
            }
            if (c.equals("fire")) {
                return FIRE;
            }
            return UNKNOWN;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "speed";
                }
                case 1: {
                    return "slow";
                }
                case 2: {
                    return "haste";
                }
                case 3: {
                    return "mining_fatigue";
                }
                case 4: {
                    return "strength";
                }
                case 5: {
                    return "jump_boost";
                }
                case 6: {
                    return "nausea";
                }
                case 7: {
                    return "regeneration";
                }
                case 8: {
                    return "resistance";
                }
                case 9: {
                    return "fire_resistance";
                }
                case 10: {
                    return "water_breathing";
                }
                case 11: {
                    return "invisibility";
                }
                case 12: {
                    return "blindness";
                }
                case 13: {
                    return "night_vision";
                }
                case 14: {
                    return "hunger";
                }
                case 15: {
                    return "weakness";
                }
                case 16: {
                    return "poison";
                }
                case 17: {
                    return "wither";
                }
                case 18: {
                    return "health_boost";
                }
                case 19: {
                    return "absorption";
                }
                case 20: {
                    return "saturation";
                }
                case 21: {
                    return "glowing";
                }
                case 22: {
                    return "levitation";
                }
                case 23: {
                    return "luck";
                }
                case 24: {
                    return "unluck";
                }
                case 25: {
                    return "slow_falling";
                }
                case 26: {
                    return "conduit_power";
                }
                case 27: {
                    return "dolphins_grace";
                }
                case 28: {
                    return "bad_omen";
                }
                case 29: {
                    return "fire";
                }
            }
            return "unknown";
        }

        public MobEffectInstance getPotionEffect() {
            return this.getPotionEffect(140, 0);
        }

        public MobEffectInstance getPotionEffect(int duration, int amplifier) {
            switch (this.ordinal()) {
                case 0: {
                    return new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, amplifier);
                }
                case 1: {
                    return new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, amplifier);
                }
                case 2: {
                    return new MobEffectInstance(MobEffects.DIG_SPEED, duration, amplifier);
                }
                case 3: {
                    return new MobEffectInstance(MobEffects.DIG_SLOWDOWN, duration, amplifier);
                }
                case 4: {
                    return new MobEffectInstance(MobEffects.DAMAGE_BOOST, duration, amplifier);
                }
                case 5: {
                    return new MobEffectInstance(MobEffects.JUMP, duration, amplifier);
                }
                case 6: {
                    return new MobEffectInstance(MobEffects.CONFUSION, duration, amplifier);
                }
                case 7: {
                    return new MobEffectInstance(MobEffects.REGENERATION, duration, amplifier);
                }
                case 8: {
                    return new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration, amplifier);
                }
                case 9: {
                    return new MobEffectInstance(MobEffects.FIRE_RESISTANCE, duration, amplifier);
                }
                case 10: {
                    return new MobEffectInstance(MobEffects.WATER_BREATHING, duration, amplifier);
                }
                case 11: {
                    return new MobEffectInstance(MobEffects.INVISIBILITY, duration, amplifier);
                }
                case 12: {
                    return new MobEffectInstance(MobEffects.BLINDNESS, duration, amplifier);
                }
                case 13: {
                    return new MobEffectInstance(MobEffects.NIGHT_VISION, duration, amplifier);
                }
                case 14: {
                    return new MobEffectInstance(MobEffects.HUNGER, duration, amplifier);
                }
                case 15: {
                    return new MobEffectInstance(MobEffects.WEAKNESS, duration, amplifier);
                }
                case 16: {
                    return new MobEffectInstance(MobEffects.POISON, duration, amplifier);
                }
                case 17: {
                    return new MobEffectInstance(MobEffects.WITHER, duration, amplifier);
                }
                case 18: {
                    return new MobEffectInstance(MobEffects.HEALTH_BOOST, duration, amplifier);
                }
                case 19: {
                    return new MobEffectInstance(MobEffects.ABSORPTION, duration, amplifier);
                }
                case 20: {
                    return new MobEffectInstance(MobEffects.SATURATION, duration, amplifier);
                }
                case 21: {
                    return new MobEffectInstance(MobEffects.GLOWING, duration, amplifier);
                }
                case 22: {
                    return new MobEffectInstance(MobEffects.LEVITATION, duration, amplifier);
                }
                case 23: {
                    return new MobEffectInstance(MobEffects.LUCK, duration, amplifier);
                }
                case 24: {
                    return new MobEffectInstance(MobEffects.UNLUCK, duration, amplifier);
                }
                case 25: {
                    return new MobEffectInstance(MobEffects.SLOW_FALLING, duration, amplifier);
                }
                case 26: {
                    return new MobEffectInstance(MobEffects.CONDUIT_POWER, duration, amplifier);
                }
                case 27: {
                    return new MobEffectInstance(MobEffects.DOLPHINS_GRACE, duration, amplifier);
                }
                case 28: {
                    return new MobEffectInstance(MobEffects.BAD_OMEN, duration, amplifier);
                }
                case 29: {
                    return null;
                }
            }
            return null;
        }

        public void applyEffectToEntity(LivingEntity entity) {
            this.applyEffectToEntity(entity, 240, 0);
        }

        public void applyEffectToEntity(LivingEntity entity, int duration, int amplifier) {
            if (this == FIRE) {
                entity.setRemainingFireTicks(duration / 2);
                return;
            }
            if (this != UNKNOWN) {
                entity.addEffect(this.getPotionEffect(duration, amplifier));
            }
        }

        public String getAffectedString() {
            switch (this.ordinal()) {
                case 0: {
                    return "made faster";
                }
                case 1: {
                    return "made slower";
                }
                case 2: {
                    return "made hastier";
                }
                case 3: {
                    return "fatigued";
                }
                case 4: {
                    return "strengthened";
                }
                case 5: {
                    return "jump boosted";
                }
                case 6: {
                    return "made nauseous";
                }
                case 7: {
                    return "given regeneration";
                }
                case 8: {
                    return "given resistance";
                }
                case 9: {
                    return "given fire resistance";
                }
                case 10: {
                    return "made able to breathe underwater";
                }
                case 11: {
                    return "given invisibility";
                }
                case 12: {
                    return "made blind";
                }
                case 13: {
                    return "given night vision";
                }
                case 14: {
                    return "made hungry";
                }
                case 15: {
                    return "made weak";
                }
                case 16: {
                    return "poisoned";
                }
                case 17: {
                    return "withered";
                }
                case 18: {
                    return "given more health";
                }
                case 19: {
                    return "given absorption";
                }
                case 20: {
                    return "given saturation";
                }
                case 21: {
                    return "made to glow";
                }
                case 22: {
                    return "made to levitate";
                }
                case 23: {
                    return "given luck";
                }
                case 24: {
                    return "made unlucky";
                }
                case 25: {
                    return "falls slower";
                }
                case 26: {
                    return "made able to live underwater";
                }
                case 28: {
                    return "feels a bad omen";
                }
                case 29: {
                    return "set on fire";
                }
            }
            return "given unknown";
        }
    }
}

